/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.DecoratorLocation;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class SpinnerLabelButton
extends JPanel {
    private JButton upButton;
    private JButton downButton;
    private DecoratorLocation labelAlignment;
    private JLabel spinnerLabel;
    public final Signal<?, ?, ?, ?, ?> up = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> down = Signals.createSignal();

    public SpinnerLabelButton(String spinnerName, String text) {
        this(spinnerName, text, DecoratorLocation.NorthSouth);
    }

    public SpinnerLabelButton(String spinnerName, String text, DecoratorLocation alignment) {
        this.setName(spinnerName);
        this.labelAlignment = alignment;
        if (text != null && !text.isEmpty()) {
            this.spinnerLabel = new JLabel();
            this.spinnerLabel.setName(spinnerName + "Value");
            this.spinnerLabel.setVerticalTextPosition(0);
            this.spinnerLabel.setVerticalAlignment(0);
            this.spinnerLabel.setHorizontalAlignment(0);
            this.spinnerLabel.setHorizontalTextPosition(0);
            this.setLabelText(text);
        } else {
            this.labelAlignment = DecoratorLocation.NorthSouth;
        }
        this.upButton = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
        this.upButton.setName(spinnerName + "Up");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinnerLabelButton.this.up.emit();
            }
        });
        this.downButton = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
        this.downButton.setName(spinnerName + "Down");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinnerLabelButton.this.down.emit();
            }
        });
        if (DecoratorLocation.NorthSouth.equals((Object)this.labelAlignment)) {
            this.createNorthSouthAlignment();
        } else if (DecoratorLocation.West.equals((Object)this.labelAlignment)) {
            this.createWestAlignment();
        } else {
            throw new IllegalArgumentException("Can not create SpinnerLabelButton with 'Aligment' of : " + alignment);
        }
    }

    private void createNorthSouthAlignment() {
        if (this.spinnerLabel != null) {
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(6, 3)));
            this.add((Component)this.upButton, new Rectangle(0, 0, 6, 1));
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BorderLayout(0, 0));
            labelPanel.add((Component)this.spinnerLabel, "Center");
            this.add((Component)labelPanel, new Rectangle(0, 1, 6, 1));
            this.add((Component)this.downButton, new Rectangle(0, 2, 6, 1));
        } else {
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(6, 2)));
            this.add((Component)this.upButton, new Rectangle(0, 0, 6, 1));
            this.add((Component)this.downButton, new Rectangle(0, 2, 6, 1));
        }
    }

    private void createWestAlignment() {
        this.spinnerLabel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(2, 2)));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        labelPanel.add((Component)this.spinnerLabel, "Center");
        JPanel upbuttonPanel = new JPanel();
        upbuttonPanel.setLayout(new BorderLayout());
        upbuttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        upbuttonPanel.add((Component)this.upButton, "Center");
        JPanel downButtonPanel = new JPanel();
        downButtonPanel.setLayout(new BorderLayout());
        downButtonPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        downButtonPanel.add((Component)this.downButton, "Center");
        this.add((Component)labelPanel, new Rectangle(0, 0, 1, 2));
        this.add((Component)upbuttonPanel, new Rectangle(1, 0, 1, 1));
        this.add((Component)downButtonPanel, new Rectangle(1, 1, 1, 1));
    }

    public void setLabelText(String text) {
        if (this.spinnerLabel != null) {
            if (text != null) {
                this.spinnerLabel.setText(new HtmlBuilder().append(text).heading(2).center().toString());
            } else {
                this.spinnerLabel.setText("");
            }
        }
    }
}

