/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class TimePanel
extends JPanel {
    private JLabel timeLabel;
    protected JLabel nowLabel;
    protected Time timeDue;
    protected Time originalTime;

    public TimePanel() {
        this.init();
    }

    protected void init() {
        this.setName("timePanel");
        this.nowLabel = new JLabel();
        this.nowLabel.setForeground(Color.RED);
        this.timeLabel = new JLabel();
        this.timeLabel.setName("timeLabel");
        JPanel displayPanel = new JPanel();
        displayPanel.add((Component)this.timeLabel, new Rectangle(0, 0, 1, 1));
        displayPanel.add((Component)this.nowLabel, new Rectangle(1, 2, 2, 1));
        SpinLabel hours = new SpinLabel("Hours");
        hours.up.connect((Object)this, "moveHoursUp");
        hours.down.connect((Object)this, "moveHoursDown");
        SpinLabel minutes = new SpinLabel("Minutes");
        minutes.up.connect((Object)this, "moveMinutesUp");
        minutes.down.connect((Object)this, "moveMinutesDown");
        this.setLayout((LayoutManager)new GraphPaperLayout(10, 10));
        this.add((Component)displayPanel, new Rectangle(0, 2, 5, 6));
        this.add((Component)hours, new Rectangle(5, 0, 2, 10));
        this.add((Component)minutes, new Rectangle(8, 0, 2, 10));
        this.setBorder();
    }

    protected void setBorder() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Time Due:"), BorderFactory.createEmptyBorder(25, 25, 25, 25)));
    }

    public void reset() {
        this.originalTime = this.timeDue = DateTimeUtils.roundToMinutes((Time)new Time(System.currentTimeMillis()), (int)5);
        this.displayTime();
    }

    public void moveHoursUp() {
        this.adjustTime(11, 1);
    }

    public void moveHoursDown() {
        this.adjustTime(11, -1);
    }

    public void moveMinutesUp() {
        this.adjustTime(12, 5);
    }

    public void moveMinutesDown() {
        this.adjustTime(12, -5);
    }

    public boolean hasTime() {
        return !this.originalTime.equals(this.timeDue);
    }

    public Time getTimeDue() {
        return this.timeDue;
    }

    public Time getOriginalTime() {
        return this.originalTime;
    }

    protected void adjustTime(int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.timeDue);
        cal.roll(field, amount);
        this.timeDue = new Time(cal.getTimeInMillis());
        this.displayTime();
    }

    private void setTimeLabelText(String text) {
        this.timeLabel.setText("<html><h1>" + text + "</h1></html>");
    }

    private void setNowLabelText(String text) {
        this.nowLabel.setText("<html><h1>" + text + "</h1></html>");
    }

    protected void displayTime() {
        this.setTimeLabelText(new SimpleDateFormat("h:mm a").format(this.timeDue));
        if (!this.timeDue.equals(this.originalTime)) {
            this.timeLabel.setForeground(null);
            this.setNowLabelText("");
        } else {
            this.timeLabel.setForeground(Color.GRAY);
            this.setNowLabelText("NOW");
        }
    }

    private static class SpinLabel
    extends JPanel
    implements ActionListener {
        private JButton upButton;
        private JButton downButton;
        public final Signal up = Signals.createSignal();
        public final Signal down = Signals.createSignal();

        public SpinLabel(String label) {
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(6, 3)));
            JPanel textPanel = new JPanel(new FlowLayout(1, 0, -3));
            textPanel.add(new JLabel("<html><center><h2>" + label + "<html><h2></center>"));
            this.setName(label);
            this.add((Component)textPanel, new Rectangle(0, 1, 6, 1));
            this.upButton = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
            this.upButton.setName("up");
            this.upButton.addActionListener(this);
            this.add((Component)this.upButton, new Rectangle(0, 0, 6, 1));
            this.downButton = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
            this.downButton.addActionListener(this);
            this.downButton.setName("down");
            this.add((Component)this.downButton, new Rectangle(0, 2, 6, 1));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.upButton) {
                this.up.emit();
            } else if (source == this.downButton) {
                this.down.emit();
            }
        }
    }
}

