/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.saveaccount.details.SpinnerLabelButton;
import waitermate.gui.screens.ordering.saveaccount.details.TimePanel;

public class TimeSpinnerPanel
extends TimePanel {
    public final Signal<?, ?, ?, ?, ?> changed = Signals.createSignal();
    private JLabel amPmLabel;
    private SpinnerLabelButton hoursButton;
    private SpinnerLabelButton minutesButton;
    private SimpleDateFormat hoursFormat = new SimpleDateFormat("hh");
    private SimpleDateFormat minutesFormat = new SimpleDateFormat("mm");
    private SimpleDateFormat amPmFormat = new SimpleDateFormat("a");
    private JLabel orginalTimeLabel;
    private Date currentTime;
    private Date date = new Date();

    public TimeSpinnerPanel() {
        this.currentTime = this.getDateRounded(new Date(), new Time(System.currentTimeMillis()));
        this.hoursButton = new SpinnerLabelButton("hoursTimeSpinner", "00");
        this.hoursButton.up.connect((Object)this, "moveHoursUp");
        this.hoursButton.down.connect((Object)this, "moveHoursDown");
        JLabel timeSeperator = new JLabel(new HtmlBuilder().append(":").heading(2).center().toString());
        timeSeperator.setVerticalTextPosition(0);
        timeSeperator.setVerticalAlignment(0);
        timeSeperator.setHorizontalAlignment(0);
        timeSeperator.setHorizontalTextPosition(0);
        JPanel timeSeperatorPanel = new JPanel();
        timeSeperatorPanel.setLayout(new BorderLayout(0, 0));
        timeSeperatorPanel.add((Component)timeSeperator, "Center");
        this.minutesButton = new SpinnerLabelButton("minutesTimeSpinner", "00");
        this.minutesButton.up.connect((Object)this, "moveMinutesUp");
        this.minutesButton.down.connect((Object)this, "moveMinutesDown");
        this.amPmLabel = new JLabel("AM");
        this.amPmLabel.setVerticalTextPosition(0);
        this.amPmLabel.setVerticalAlignment(0);
        this.amPmLabel.setHorizontalAlignment(0);
        this.amPmLabel.setHorizontalTextPosition(0);
        JPanel amPmPanel = new JPanel();
        amPmPanel.setLayout(new BorderLayout(0, 0));
        amPmPanel.add((Component)this.amPmLabel, "Center");
        this.nowLabel = new JLabel("NOW");
        this.nowLabel.setVerticalTextPosition(0);
        this.nowLabel.setVerticalAlignment(0);
        this.nowLabel.setHorizontalAlignment(0);
        this.nowLabel.setHorizontalTextPosition(0);
        JPanel nowLabelPanel = new JPanel();
        nowLabelPanel.setLayout(new BorderLayout(0, 0));
        nowLabelPanel.add((Component)this.nowLabel, "Center");
        this.orginalTimeLabel = new JLabel("Original Time:");
        this.orginalTimeLabel.setName("orginalTimeSpinner");
        this.orginalTimeLabel.setVerticalTextPosition(0);
        this.orginalTimeLabel.setVerticalAlignment(0);
        this.orginalTimeLabel.setHorizontalAlignment(4);
        JPanel orginalTimePanel = new JPanel(new FlowLayout(2));
        orginalTimePanel.add(this.orginalTimeLabel);
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(7, 7)));
        this.add((Component)orginalTimePanel, new Rectangle(0, 0, 7, 1));
        this.add((Component)this.hoursButton, new Rectangle(0, 1, 2, 6));
        this.add((Component)timeSeperatorPanel, new Rectangle(2, 3, 1, 2));
        this.add((Component)this.minutesButton, new Rectangle(3, 1, 2, 6));
        this.add((Component)amPmPanel, new Rectangle(5, 3, 2, 2));
        this.add((Component)nowLabelPanel, new Rectangle(5, 5, 2, 2));
        this.displayTime();
    }

    @Override
    protected void init() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Time Due :"), BorderFactory.createEmptyBorder(0, 25, 5, 25)));
    }

    @Override
    protected void displayTime() {
        if (this.timeDue != null) {
            this.hoursButton.setLabelText(this.hoursFormat.format(this.timeDue));
            this.minutesButton.setLabelText(this.minutesFormat.format(this.timeDue));
            this.amPmLabel.setText(this.getAmPmLabelString(this.timeDue));
            if (this.isTimeEqual(this.currentTime, DateTimeUtils.combineDateAndTime((Date)this.date, (Date)this.timeDue))) {
                this.nowLabel.setText(new HtmlBuilder().appendFont("NOW", "RED", true, false, 0).heading(2).center().toString());
            } else {
                this.nowLabel.setText("");
            }
            this.orginalTimeLabel.setText(new HtmlBuilder().append("Original Time: ").append(new SimpleDateFormat("h:mm a").format(this.originalTime)).toString());
        }
    }

    private boolean isTimeEqual(Date orginalTime, Date checkTime) {
        String currentDateTime = DateTimeUtils.getDateTimeFormat().format(orginalTime);
        String timeDueString = DateTimeUtils.getDateTimeFormat().format(checkTime);
        return currentDateTime.equals(timeDueString);
    }

    public boolean isOriginalSet() {
        return this.isTimeEqual(this.originalTime, DateTimeUtils.combineDateAndTime((Date)this.date, (Date)this.timeDue));
    }

    private String getAmPmLabelString(Time time) {
        return new HtmlBuilder().append(this.amPmFormat.format(time)).heading(2).center().toString();
    }

    @Override
    protected void adjustTime(int field, int amount) {
        super.adjustTime(field, amount);
        this.changed.emit();
    }

    public void setDateTime(Date orginal, Date dueTime) {
        this.date = orginal;
        this.setTime(new Time(orginal.getTime()), new Time(dueTime.getTime()));
    }

    public void setTime(Date time) {
        this.timeDue = DateTimeUtils.roundToMinutes((Time)new Time(time.getTime()), (int)5);
        this.displayTime();
    }

    public void setTime(Time orginal, Time dueTime) {
        this.originalTime = orginal != null ? DateTimeUtils.roundToMinutes((Time)orginal, (int)5) : DateTimeUtils.roundToMinutes((Time)new Time(System.currentTimeMillis()), (int)5);
        this.timeDue = DateTimeUtils.roundToMinutes((Time)dueTime, (int)5);
        this.displayTime();
    }

    public Date getSelectDatetime() {
        return DateTimeUtils.combineDateAndTime((Date)this.date, (Date)this.timeDue);
    }

    private Date getDateRounded(Date newDate, Time newTime) {
        Date combined = DateTimeUtils.combineDateAndTime((Date)newDate, (Date)DateTimeUtils.roundToMinutes((Time)newTime, (int)5));
        return DateTimeUtils.clearMillis((Date)combined);
    }
}

