/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.seatadmin;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.customer.search.CustomerSearch;
import waitermate.gui.screens.ordering.seatadmin.CustomerDetailPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;

public class SeatAdmin
extends AbstractScreen
implements ChangeListener {
    public static final String SEAT_ADMIN = "seatAdmin";
    public static final String SEAT_TABS = "seatAdmin_seatTabs";
    private static final Dimension SIZE = new Dimension(350, 200);
    private final TableAccount account;
    private final int startingSeat;
    private final Signal done;
    private final CustomerAssignmentHelper helper;
    private JTabbedPane seatTabs;
    private final List<CustomerDetailPanel> detailPanels;
    private PopupWindow customerSearchDialog;
    private JButton assignToAllButton;
    private JButton clearSeatButton;
    public final Signal<Customer, ?, ?, ?, ?> gotCustomer = Signals.createSignal(Customer.class, (String)"customer");
    private final Signal searchCustomerSignal = Signals.createSignal();
    private final Signal assignToAllSignal = Signals.createSignal();
    private final Signal clearSeatSignal = Signals.createSignal();

    public SeatAdmin(TableAccount theAccount, int selectedSeat, Signal emitWhenDone) {
        this.searchCustomerSignal.connect((Object)this, "gotSearchCustomer");
        this.assignToAllSignal.connect((Object)this, "gotAssignToAll");
        this.clearSeatSignal.connect((Object)this, "gotClearSeat");
        this.account = theAccount;
        this.startingSeat = selectedSeat;
        this.done = emitWhenDone;
        this.helper = new CustomerAssignmentHelper();
        this.detailPanels = new ArrayList<CustomerDetailPanel>();
    }

    public JComponent getMainArea() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.buildSeatTabs(), "Center");
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.setName(SEAT_ADMIN);
        return mainPanel;
    }

    public NavBar getNavBar() {
        NavBar nav = new NavBar();
        nav.setText("Seat Admin");
        nav.addLeft((Component)nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/find.png"), "Search Customer", "searchCustomer", this.searchCustomerSignal));
        this.assignToAllButton = nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/customer.png"), "Assign to All", "assignToAll", this.assignToAllSignal);
        nav.addLeft((Component)this.assignToAllButton);
        this.clearSeatButton = nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/deleteLarge.png"), "Clear Seat", "clearSeat", this.clearSeatSignal);
        nav.addRight((Component)this.clearSeatButton);
        nav.addRight((Component)nav.getOkButton());
        nav.ok.connect(this.done);
        return nav;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.seatTabs.setSelectedIndex(((JTabbedPane)e.getSource()).getSelectedIndex());
        int seat = this.seatTabs.getSelectedIndex();
        Customer customer = this.account.getCustomerForSeat(seat);
        boolean enableCustomerFunctions = customer != null;
        this.toggleButtonsEnabled(enableCustomerFunctions);
    }

    public void setCustomer(Customer customer) {
        CustomerAssignmentContext context = new CustomerAssignmentContext(customer, (Account)this.account, this.seatTabs.getSelectedIndex(), LoginManager.getEventContext());
        boolean success = this.helper.assignCustomer(context);
        if (success) {
            this.detailPanels.get(this.seatTabs.getSelectedIndex()).setCustomer(customer);
            this.toggleButtonsEnabled(true);
            this.gotCustomer.emit((Object)customer);
        }
    }

    void gotSearchCustomer() {
        CustomerSearch customerSearch = new CustomerSearch(Arrays.asList(new Object[0]), true, false);
        customerSearch.getMainArea().setPreferredSize(ScreenResource.getMaxDialogDimension());
        customerSearch.selected.connect((Object)this, "gotCustomerFromSearch");
        customerSearch.setFullScreen(false);
        this.customerSearchDialog = new PopupWindow(customerSearch.getNavBar(), false);
        this.customerSearchDialog.setComponent(customerSearch.getMainArea());
        this.customerSearchDialog.setBaseDialog(false);
        this.customerSearchDialog.start();
    }

    void gotCustomerFromSearch(Customer customer) {
        ScreenResource.stopWindow((JComponent)this.customerSearchDialog);
        this.customerSearchDialog = null;
        this.setCustomer(customer);
    }

    void gotAssignToAll() {
        String customerName = this.account.getCustomerForSeat(this.seatTabs.getSelectedIndex()).getName();
        String message = "Are you sure you want to assign this customer?";
        String allSeats = "Assign " + customerName + " to ALL seats";
        String unassignedSeats = "Assign " + customerName + " ONLY to unassigned seats";
        ObjectPopupWindow popup = new ObjectPopupWindow("Are you sure you want to assign this customer?", Arrays.asList(allSeats, unassignedSeats), 1, 2, true);
        String selected = (String)popup.start();
        if (selected == allSeats) {
            this.assignToAllSeats(false);
        } else if (selected == unassignedSeats) {
            this.assignToAllSeats(true);
        }
    }

    void gotClearSeat() {
        int selectedSeat = this.seatTabs.getSelectedIndex();
        this.account.removeSeatLink(selectedSeat);
        this.detailPanels.get(selectedSeat).setCustomer(null);
        this.toggleButtonsEnabled(false);
        this.helper.updateItemsForCustomer(new CustomerAssignmentContext(this.account.getCustomerForSeat(selectedSeat), (Account)this.account, selectedSeat, LoginManager.getEventContext()));
    }

    private JTabbedPane buildSeatTabs() {
        this.seatTabs = new JTabbedPane(4);
        this.seatTabs.setFont(OrderMateTheme.getLargeFont());
        this.seatTabs.setName(SEAT_TABS);
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.seatTabs);
        for (int i = 0; i <= this.account.getNumPatrons(); ++i) {
            String tabTitle = i == 0 ? "All" : String.valueOf(i);
            this.seatTabs.addTab(tabTitle, this.buildCustomerSeatPanel(i));
        }
        this.seatTabs.setSelectedIndex(this.startingSeat);
        this.seatTabs.addChangeListener(this);
        this.toggleButtonsEnabled(this.account.getCustomerForSeat(this.startingSeat) != null);
        return this.seatTabs;
    }

    private JPanel buildCustomerSeatPanel(int seat) {
        CustomerDetailPanel detailPanel = new CustomerDetailPanel();
        Customer customer = this.account.getCustomerForSeat(seat);
        detailPanel.setCustomer(customer);
        String text = "Customer Assigned to " + (seat == 0 ? "'All'" : "Seat " + seat);
        JLabel title = new JLabel(text, 0);
        title.setFont(OrderMateTheme.getLargeFont());
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(new EmptyBorder(5, 5, 0, 0));
        container.setPreferredSize(SIZE);
        container.add(this.wrapInBorderPanel(title));
        container.add(Box.createVerticalStrut(20));
        container.add(this.wrapInBorderPanel(detailPanel));
        this.detailPanels.add(detailPanel);
        return container;
    }

    private JPanel wrapInBorderPanel(Component comp) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add(comp, "Center");
        return wrapper;
    }

    private void toggleButtonsEnabled(boolean enable) {
        this.assignToAllButton.setEnabled(enable);
        this.clearSeatButton.setEnabled(enable);
    }

    private void assignToSeat(Customer toAssign, int seat) {
        CustomerAssignmentContext context = new CustomerAssignmentContext(toAssign, (Account)this.account, seat, LoginManager.getEventContext());
        this.helper.assignCustomer(context);
        this.detailPanels.get(seat).setCustomer(toAssign);
    }

    private void assignToAllSeats(boolean unassignedOnly) {
        for (int i = 0; i <= this.account.getNumPatrons(); ++i) {
            Customer existingCustomer = this.account.getCustomerForSeat(i);
            if (unassignedOnly) {
                if (existingCustomer != null) continue;
                this.assignToSeat(this.account.getCustomerForSeat(this.seatTabs.getSelectedIndex()), i);
                continue;
            }
            this.assignToSeat(this.account.getCustomerForSeat(this.seatTabs.getSelectedIndex()), i);
        }
    }
}

