/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.transferitems.selectitems;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.Sellable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.accountitems.SelectItemsPanel;
import waitermate.gui.screens.ordering.transferitems.selectitems.SelectItemsNav;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class SelectItems
extends AbstractScreen {
    private final SelectItemsPanel gui;
    private final SelectItemsNav navBar;
    public final Signal<Set, ?, ?, ?, ?> items = Signals.createSignal(Set.class, (String)"selectedItems");
    public final Signal<Account, ?, ?, ?, ?> itemsSplit = Signals.createSignal(Account.class, (String)"fromAccount");
    public final Signal back = Signals.createSignal();
    private QuickCondition preOkCondition = new AtLeastOnePreOkCondition();

    public SelectItems() {
        this(false, true);
    }

    public SelectItems(boolean showBack, boolean showCancel) {
        this.gui = this.createGuiPanel();
        this.gui.itemsSplit.connect((Object)this, "gotItemsSplit");
        this.navBar = new SelectItemsNav(showBack, showCancel);
        this.navBar.back.connect((Object)this.back, "emit");
        this.navBar.cancel.connect((Object)this.back, "emit");
        this.navBar.ok.connect((Object)this, "gotOk");
        this.navBar.selectAll.connect((Object)this.gui, "selectAll");
        this.navBar.selectNone.connect((Object)this.gui, "selectNone");
    }

    protected SelectItemsPanel createGuiPanel() {
        SelectItemsPanel panelToReturn = new SelectItemsPanel();
        panelToReturn.setCurrentCourse(Course.getDefault());
        return panelToReturn;
    }

    public void startSelection(List<Sellable> itemList) {
        this.gui.setCourse(Course.getCourses().indexOf(Course.getDefault()));
        this.gui.selectNone();
        this.gui.setItems(itemList);
        this.gui.invalidate();
        this.display();
    }

    public void gotItemsSplit(Account forAccount) {
        this.itemsSplit.emit((Object)forAccount);
    }

    public void startSelection(List<Sellable> itemList, String title) {
        this.navBar.setText(title);
        this.startSelection(itemList);
    }

    public void startSelection(List<Sellable> itemList, Set<Sellable> selectedItems) {
        this.gui.setCourse(Course.getCourses().indexOf(Course.getDefault()));
        this.gui.selectNone();
        this.gui.setItems(itemList);
        this.gui.setSelectedItems(new ArrayList<Sellable>(selectedItems));
        this.gui.invalidate();
        this.display();
    }

    public void showSelection() {
        this.display();
    }

    public void gotOk() {
        Set<Sellable> selected = this.gui.getSelectedItems();
        if (this.preOkCondition.isMet()) {
            this.items.emit(selected);
        } else {
            Dialogs.displayOkDialog((String)this.preOkCondition.getErrorDialogText(), (String)this.preOkCondition.getErrorDialogLabel());
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    public void setPreOkCondition(QuickCondition newCond) {
        this.preOkCondition = newCond == null ? new NoPreOkCondition() : newCond;
    }

    public class AtLeastOnePreOkCondition
    implements QuickCondition {
        @Override
        public boolean isMet() {
            return !SelectItems.this.gui.getSelectedItems().isEmpty();
        }

        @Override
        public String getErrorDialogText() {
            return "To continue you must select an item";
        }

        @Override
        public String getErrorDialogLabel() {
            return "No items selected";
        }
    }

    public static class NoPreOkCondition
    implements QuickCondition {
        @Override
        public boolean isMet() {
            return true;
        }

        @Override
        public String getErrorDialogText() {
            return "";
        }

        @Override
        public String getErrorDialogLabel() {
            return "";
        }
    }

    private static interface QuickCondition {
        public boolean isMet();

        public String getErrorDialogText();

        public String getErrorDialogLabel();
    }
}

