/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.transferitems.selectsourceaccount;

import java.awt.Component;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.sales.Account;
import ordermate.database.tables.LogicalTable;
import waitermate.gui.screens.selectaccount.AbstractAccountSelection;
import waitermate.gui.screens.selectaccount.SelectAccount;
import waitermate.gui.screens.selectaccount.online.OnlineAccountSelection;
import waitermate.gui.screens.selectaccount.phone.PhoneSelection;
import waitermate.gui.screens.selectaccount.table.TableAccountSelection;
import waitermate.gui.screens.selectaccount.takeaway.DriveThruSelection;
import waitermate.gui.screens.selectaccount.takeaway.TakeawaySelection;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.BarTabSelection;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class SelectSourceAccount
extends SelectAccount {
    @Override
    protected void initScreens(boolean isUnallocatedTables) {
        Terminal myTerminal = Terminal.getLocalHost();
        for (TerminalMode mode : myTerminal.getTerminalModes()) {
            if (mode.getMode().equals("Tables")) {
                this.tables = new TableAccountSelection(true, false);
                this.tables.setDisplayLastTableAccessedText(false);
                this.tables.tableSelected.connect((Object)this, "gotTable");
                this.tables.accountsSelected.connect((Object)this, "gotAccountsSelected");
                this.tables.setAllowInterfaceUnlocking(true);
                this.setupSelectScreen(mode, this.tables);
                continue;
            }
            if (mode.getMode().equals("Phone")) {
                this.setupSelectScreen(mode, new PhoneSelection(false));
                continue;
            }
            if (mode.getMode().equals("Phone with Delivery")) {
                this.setupSelectScreen(mode, new PhoneSelection(true));
                continue;
            }
            if (mode.getMode().equals("Takeaway")) {
                this.setupSelectScreen(mode, new TakeawaySelection());
                continue;
            }
            if (mode.getMode().equals("Drive Thru")) {
                this.setupSelectScreen(mode, new DriveThruSelection());
                continue;
            }
            if (mode.getMode().equals("Bar Tabs")) {
                this.setupSelectScreen(mode, new BarTabSelection(false));
                continue;
            }
            if (!mode.getMode().equals("Online")) continue;
            this.setupSelectScreen(mode, new OnlineAccountSelection());
        }
    }

    private void setupSelectScreen(TerminalMode mode, AbstractAccountSelection screen) {
        this.addGuiState(screen, mode.getLabel());
        screen.accountSelected.connect((Object)this, "gotAccount");
        this.setupNavBar(screen.getNavBar());
    }

    @Override
    protected void setupNavBar(NavBar nav) {
        nav.hideAllButtons();
        nav.addLeft((Component)nav.getBackButton());
        nav.back.connect((Object)this.back, "emit");
        nav.setText("Select account to transfer");
    }

    public void gotAccountsSelected(List<Account> accounts) {
        this.accountsSelected.emit(accounts);
    }

    @Override
    public void gotTable(LogicalTable theTable) {
        if (theTable.isLocked() || theTable.hasAccount()) {
            super.gotTable(theTable);
        } else {
            Dialogs.displayOkDialog((String)"Table has no items", (String)"This table contains no items that can be transferred.");
        }
    }
}

