/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.transferitems.summary;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.transferitems.summary.SummaryPanel;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class TransferSummary
extends AbstractScreen {
    private SummaryPanel gui;
    private NavBar nav;
    public final Signal back = Signals.createSignal();
    public final Signal cancel = Signals.createSignal();
    public final Signal ok = Signals.createSignal();
    private Account source;
    private Account target;
    private List toTransfer;
    private final CoversHelper ch;

    public TransferSummary() {
        this.gui = new SummaryPanel();
        this.gui.changeSourceNumPatrons.connect((Object)this, "gotChangeSourceNumPatrons");
        this.gui.changeTargetNumPatrons.connect((Object)this, "gotChangeTargetNumPatrons");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.setText("Are you sure you wish to continue?");
        this.nav.addRight((Component)this.nav.getCancelButton());
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.ch = new CoversHelper();
    }

    public void showSummary(List itemsToTransfer, Account newSource, Account newTarget) {
        this.source = newSource;
        this.target = newTarget;
        this.toTransfer = itemsToTransfer;
        this.gui.setItems(this.toTransfer);
        this.gui.setAccounts(this.source, this.target);
        this.gui.setTargetPatronsVisible(this.target.isNumberPatronsModifiable(null));
        if (DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            this.gui.setSourcePatronsVisible(false);
            this.gui.setTargetPatronsVisible(false);
        } else if (this.source.isNumberPatronsModifiable(itemsToTransfer)) {
            this.gui.setSourcePatronsVisible(true);
            this.gui.setSourceNumPatrons(((TableAccount)this.source).evaluateNumberPatrons(this.target, this.toTransfer));
        } else {
            this.gui.setSourcePatronsVisible(false);
        }
        this.display();
    }

    void gotOk() {
        if (this.source.isNumberPatronsModifiable(this.toTransfer)) {
            ((TableAccount)this.source).setNumPatrons(this.gui.getSourceNumPatrons());
        }
        if (this.target.isNumberPatronsModifiable(null)) {
            ((TableAccount)this.target).setNumPatrons(this.gui.getTargetNumPatrons());
        }
        this.ok.emit();
    }

    void gotCancel() {
        this.target.unlock();
        this.cancel.emit();
    }

    void gotBack() {
        this.target.unlock();
        this.back.emit();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotChangeSourceNumPatrons() {
        int numPatron = this.ch.promptForCoversOnly(this.gui.getSourceNumPatrons(), ((TableAccount)this.source).getTable());
        if (numPatron > -1) {
            this.gui.setSourceNumPatrons(numPatron);
        }
    }

    public void gotChangeTargetNumPatrons() {
        int numPatron = this.ch.promptForCoversOnly(this.gui.getTargetNumPatrons(), ((TableAccount)this.target).getTable());
        if (numPatron > -1) {
            this.gui.setTargetNumPatrons(numPatron);
        }
    }
}

