/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.users.User;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.services.hardware.physical.eftpos.CashDrawerManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.AbstractTransactionNav;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public abstract class AbstractTransactionScreen
extends AbstractScreen {
    public final Signal<FinanceTransaction, ?, ?, ?, ?> done = Signals.createSignal(FinanceTransaction.class, (String)"newTransaction");
    public final Signal cancel = Signals.createSignal();
    private Price due;
    private Payable currentGroup;
    private AbstractTransactionNav nav;
    protected SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
    private VirtualEftpos vEftpos;
    protected boolean autoSurchargeEnabled;
    private CashDrawer cashdrawer;

    public void setupNav() {
        this.nav = this.createNavBar();
        this.nav.back.connect((Object)this, "gotCancel");
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.nav.ok.connect((Object)this, "gotDone");
        this.nav.priceSelected.connect((Object)this, "gotRecommendedPriceSelected");
    }

    public abstract AbstractTransactionNav createNavBar();

    protected abstract FinanceTransaction createTransaction(boolean var1);

    public abstract void gotRecommendedPriceSelected(Price var1);

    protected abstract List<Sellable> getPayableItemsFromItemGroup(ItemGroup var1);

    public final NavBar getNavBar() {
        return this.nav;
    }

    protected boolean determineAutoSurcharge() {
        return false;
    }

    protected VirtualEftpos getVirtualEftpos() {
        return this.vEftpos;
    }

    public void startAddingTransaction(Price dueAmount, Payable payGroup) {
        User user = LoginManager.getInstance().getUser();
        Terminal terminal = Terminal.getLocalHost();
        this.cashdrawer = terminal.getAssignedCashDrawer(user);
        this.vEftpos = EftposManager.getInstance().getEftposForCashDrawer(this.cashdrawer, terminal);
        this.autoSurchargeEnabled = this.determineAutoSurcharge();
        this.due = new Price((Number)dueAmount, 0.01);
        this.currentGroup = payGroup;
        if (payGroup instanceof ItemGroup) {
            this.nav.setItems((ItemGroup)payGroup, this.getPayableItemsFromItemGroup((ItemGroup)payGroup));
        }
    }

    protected final Price getDue() {
        return this.due;
    }

    protected final Payable getItemGroup() {
        return this.currentGroup;
    }

    protected final Payable getPayable() {
        return this.currentGroup;
    }

    public void gotDone() {
        if (this.mayCreateTransaction()) {
            FinanceTransaction newTransaction = this.createTransaction(this.autoSurchargeEnabled);
            this.postCreateTransaction(newTransaction);
        } else {
            String message = LoginManager.getInstance().getUser().getName() + " does not have access to a Cashdrawer";
            Dialogs.displayOkDialog((String)message, (String)"Unable to add Transaction");
        }
    }

    protected boolean mayCreateTransaction() {
        return this.cashdrawer != null;
    }

    public void gotCancel() {
        this.cancel.emit();
    }

    protected void postCreateTransaction(FinanceTransaction transaction) {
        this.transactionCompleted(transaction);
    }

    protected void transactionCompleted(FinanceTransaction transaction) {
        if (transaction.getSystemState().equals("ACTIVE")) {
            FinanceSurchargeCalculator.applySurcharge((Payable)this.currentGroup, (FinanceUnit)transaction.getSubType(), (Price)transaction.getSurcharge(), (EventContext)LoginManager.getEventContext());
            if (!this.getItemGroup().getFinanceTransactions().contains(transaction)) {
                this.getItemGroup().addFinanceTransaction(transaction);
            }
            if (transaction.needsOpenCashdrawer()) {
                CashDrawerManager.getInstance().openAllCashDrawersPayment(LoginManager.getInstance().getUser(), transaction, Terminal.getLocalHost());
            }
        }
        this.done.emit((Object)transaction);
    }
}

