/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment;

import ordermate.database.sales.Account;
import ordermate.signals.Signal;
import waitermate.gui.screens.payment.paths.AutoSplitPath;
import waitermate.gui.screens.payment.paths.PercentageSplitPath;
import waitermate.gui.screens.payment.paths.SinglePath;
import waitermate.gui.screens.payment.paths.SplitPath;

public class Payments {
    private Signal back;
    private Signal done;
    private boolean restrictSaveToPaid = false;
    private Account payGroup;
    private SplitPath splitPath = new SplitPath();
    private SinglePath singlePath;
    private AutoSplitPath autoPath;
    private PercentageSplitPath percentSplitPath;
    private static final Payments instance = new Payments();

    public static Payments getInstance() {
        return instance;
    }

    private Payments() {
        this.splitPath.done.connect((Object)this, "gotDone");
        this.splitPath.back.connect((Object)this, "gotBack");
        this.splitPath.normalMode.connect((Object)this, "gotResumeSinglePath");
        this.autoPath = new AutoSplitPath();
        this.autoPath.done.connect((Object)this, "gotDone");
        this.autoPath.back.connect((Object)this, "gotBack");
        this.autoPath.normalMode.connect((Object)this, "gotResumeSinglePath");
        this.percentSplitPath = new PercentageSplitPath();
        this.percentSplitPath.done.connect((Object)this, "gotDone");
        this.percentSplitPath.back.connect((Object)this, "gotBack");
        this.singlePath = new SinglePath();
        this.singlePath.done.connect((Object)this, "gotDone");
        this.singlePath.percentageSplitBill.connect((Object)this, "gotPercentSplitBill");
        this.singlePath.autoSplitBill.connect((Object)this, "gotAutoSplitBill");
        this.singlePath.splitBill.connect((Object)this, "gotSplitBill");
        this.singlePath.back.connect((Object)this, "gotBack");
    }

    public void startPayment(Account toPay, Signal newBack, Signal newDone, boolean newRestrictSaveToPaid) {
        this.back = newBack;
        this.done = newDone;
        this.payGroup = toPay;
        this.restrictSaveToPaid = newRestrictSaveToPaid;
        this.singlePath.start(toPay, this.restrictSaveToPaid);
    }

    void gotResumeSinglePath() {
        this.singlePath.start(this.payGroup, this.restrictSaveToPaid);
    }

    void gotSplitBill() {
        this.splitPath.start(this.payGroup, true);
    }

    void gotAutoSplitBill() {
        this.autoPath.start(this.payGroup, true);
    }

    void gotPercentSplitBill() {
        this.percentSplitPath.start(this.payGroup, true);
    }

    void gotBack() {
        this.back.emit();
    }

    void gotDone() {
        this.done.emit();
        this.payGroup = null;
    }

    public void refreshSinglePath() {
        if (this.singlePath != null) {
            this.singlePath.done.disconnectAll();
            this.singlePath.percentageSplitBill.disconnectAll();
            this.singlePath.autoSplitBill.disconnectAll();
            this.singlePath.splitBill.disconnectAll();
            this.singlePath.back.disconnectAll();
        }
        this.singlePath = new SinglePath();
        this.singlePath.done.connect((Object)this, "gotDone");
        this.singlePath.percentageSplitBill.connect((Object)this, "gotPercentSplitBill");
        this.singlePath.autoSplitBill.connect((Object)this, "gotAutoSplitBill");
        this.singlePath.splitBill.connect((Object)this, "gotSplitBill");
        this.singlePath.back.connect((Object)this, "gotBack");
    }
}

