/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.cashtransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.users.AllPermissions;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.PriceModel;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;

class CashTransactionPanel
extends JPanel
implements ActionListener {
    public static final int PAID_EDIT = 1;
    public static final int TIP_EDIT = 2;
    public static final int TENDERED_EDIT = 3;
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH;
    private static int COMPONENT_START;
    private static int COMPONENT_WIDTH;
    private JLabel due;
    private JLabel subTotal;
    private JLabel change;
    private JLabel balance;
    private JToggleButton paid;
    private JToggleButton tip;
    private JToggleButton tendered;
    private Keypad keypad;
    private ButtonGroup buttonGroup;
    private JLabel total;
    private JLabel rounding;
    public final Signal paidUpdated = Signals.createSignal(Price.class, (String)"paidValue");
    public final Signal tipUpdated = Signals.createSignal(Price.class, (String)"tipValue");
    public final Signal tenderedUpdated = Signals.createSignal(Price.class, (String)"tenderedValue");

    public CashTransactionPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(25, 20)));
        this.buttonGroup = new ButtonGroup();
        JLabel amountLabel = new JLabel(Internationalization.getLiteralFor((String)"AMOUNT") + ":");
        JLabel keypadLabel = new JLabel();
        this.keypad = new Keypad.KeypadBuilder().setOutputLabel(keypadLabel).setShowMinusSignButton(true).build();
        this.keypad.setModel((KeypadModel)new PriceModel());
        this.keypad.setRenderer(Keypad.PRICE_RENDERER);
        this.keypad.setFirstPress(true);
        JPanel keypadPanel = new JPanel();
        keypadPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        keypadPanel.setBorder(BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"AMOUNT_ENTRY")));
        keypadPanel.add((Component)amountLabel, new Rectangle(1, 0, 2, 1));
        keypadPanel.add((Component)keypadLabel, new Rectangle(3, 0, 5, 1));
        keypadPanel.add((Component)this.keypad, new Rectangle(1, 1, 8, 8));
        this.add((Component)keypadPanel, new Rectangle(13, 1, 11, 18));
        JPanel textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 10), 0, 0));
        this.add((Component)textPanel, new Rectangle(1, 0, 11, 20));
        JPanel totalsPanels = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 0, 0));
        JLabel totalLabel = new JLabel(Internationalization.getLiteralFor((String)"TOTAL"));
        totalLabel.setFont(OrderMateTheme.getSmallFont());
        totalsPanels.add((Component)totalLabel, new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.total = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.total.setFont(OrderMateTheme.getSmallFont());
        totalLabel.setLabelFor(this.total);
        totalsPanels.add((Component)this.total, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        JLabel roundingLabel = new JLabel(Internationalization.getLiteralFor((String)"ROUNDING"));
        roundingLabel.setFont(OrderMateTheme.getSmallFont());
        totalsPanels.add((Component)roundingLabel, new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        this.rounding = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.rounding.setFont(OrderMateTheme.getSmallFont());
        roundingLabel.setLabelFor(this.rounding);
        totalsPanels.add((Component)this.rounding, new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
        JLabel dueLabel = new JLabel(Internationalization.getLiteralFor((String)"DUE"));
        dueLabel.setFont(OrderMateTheme.getLargeFont());
        totalsPanels.add((Component)dueLabel, new Rectangle(LABEL_START, 2, LABEL_WIDTH, 1));
        this.due = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.due.setFont(OrderMateTheme.getLargeFont());
        dueLabel.setLabelFor(this.due);
        totalsPanels.add((Component)this.due, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, 1));
        textPanel.add((Component)totalsPanels, new Rectangle(0, 1, 10, 1));
        JPanel group1 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 5, 5));
        group1.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SUBTOTAL")));
        textPanel.add((Component)group1, new Rectangle(0, 2, 10, 4));
        JLabel paidLabel = new JLabel(Internationalization.getLiteralFor((String)"PAID"));
        group1.add((Component)paidLabel, new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.paid = new JToggleButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.paid.setName("paidButton");
        this.paid.addActionListener(this);
        paidLabel.setLabelFor(this.paid);
        this.buttonGroup.add(this.paid);
        group1.add((Component)this.paid, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"TIP")), new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        this.tip = new JToggleButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.tip.setName("tipButton");
        this.tip.addActionListener(this);
        this.buttonGroup.add(this.tip);
        group1.add((Component)new StandardSecurityDecorator((JComponent)this.tip, AllPermissions.TIPS), new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
        group1.add((Component)new JLabel("       " + Internationalization.getLiteralFor((String)"SUB_TOTAL")), new Rectangle(LABEL_START, 2, LABEL_WIDTH, 1));
        this.subTotal = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        group1.add((Component)this.subTotal, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, 1));
        JPanel group2 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 2), 5, 5));
        group2.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"CHANGE")));
        textPanel.add((Component)group2, new Rectangle(0, 6, 10, 3));
        JLabel tenderedLabel = new JLabel(Internationalization.getLiteralFor((String)"AMOUNT_TENDERED"));
        tenderedLabel.setFont(OrderMateTheme.getLargeFont());
        group2.add((Component)tenderedLabel, new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.tendered = new JToggleButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.tendered.setName("tenderedButton");
        this.tendered.setFont(OrderMateTheme.getLargeFont());
        this.tendered.addActionListener(this);
        this.buttonGroup.add(this.tendered);
        group2.add((Component)this.tendered, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        JLabel changeLabel = new JLabel(Internationalization.getLiteralFor((String)"CHANGE"));
        changeLabel.setFont(OrderMateTheme.getLargeFont());
        group2.add((Component)changeLabel, new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        this.change = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.change.setFont(OrderMateTheme.getLargeFont());
        group2.add((Component)this.change, new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
        JLabel balanceLabel = new JLabel(Internationalization.getLiteralFor((String)"BALANCE"));
        balanceLabel.setFont(OrderMateTheme.getMediumFont());
        textPanel.add((Component)balanceLabel, new Rectangle(LABEL_START, 9, LABEL_WIDTH, 1));
        this.balance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.balance.setFont(OrderMateTheme.getMediumFont());
        textPanel.add((Component)this.balance, new Rectangle(COMPONENT_START, 9, COMPONENT_WIDTH, 1));
        this.keypad.updated.connect((Object)this, "keypadUpdated");
    }

    public void setDetails(Price dueAmount, Price paidAmount, Price tipAmount, Price tenderedAmount) {
        this.total.setText(dueAmount.getRawValueToOneCent().toString());
        this.rounding.setText(dueAmount.getAppliedRoundingAmt().toString());
        this.due.setText(dueAmount.toString());
        this.paid.setText(paidAmount.toString());
        this.tip.setText(tipAmount.toString());
        this.tendered.setText(tenderedAmount.toString());
        Price changeAmount = new Price(tenderedAmount.doubleValue() - (tipAmount.doubleValue() + paidAmount.doubleValue()));
        Price balanceAmount = new Price(dueAmount.doubleValue() - paidAmount.doubleValue());
        Price subtotalAmount = new Price(tipAmount.doubleValue() + paidAmount.doubleValue());
        this.updateDisplay(balanceAmount, changeAmount, subtotalAmount);
        if (this.paid.isSelected()) {
            this.keypad.setValue(String.valueOf(paidAmount.toString()));
        } else if (this.tip.isSelected()) {
            this.keypad.setValue(String.valueOf(tipAmount.toString()));
        } else if (this.tendered.isSelected()) {
            this.keypad.setValue(String.valueOf(tenderedAmount.toString()));
        }
    }

    public void setPaidEnabled(boolean enabled) {
        this.paid.setEnabled(enabled);
    }

    public void resetDisplay() {
        this.tendered.setSelected(true);
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(true);
        this.keypad.showMinusSign(false);
        if (ExperimentalFeatureHelper.isWMCustomRefundEnabled() && LoginManager.getInstance().getUser() != null && LoginManager.getInstance().getUser().hasPermission(AllPermissions.WAITERMATE_CUSTOM_REFUND)) {
            this.keypad.showMinusSign(true);
        }
    }

    public void updateDisplay(Price balanceAmount, Price changeAmount, Price subtotalAmount) {
        if (balanceAmount.doubleValue() >= 0.0) {
            this.balance.setText(balanceAmount.toString());
            this.balance.setForeground(null);
        } else {
            this.balance.setText(balanceAmount.toString());
            this.balance.setForeground(Color.RED);
        }
        this.subTotal.setText(subtotalAmount.toString());
        if (changeAmount.doubleValue() >= 0.0) {
            this.change.setText(changeAmount.toString());
            this.change.setForeground(null);
        } else {
            this.change.setText(changeAmount.toString());
            this.change.setForeground(Color.RED);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.paid) {
            String text = this.paid.getText();
            this.keypad.setValue(text);
            this.keypad.setFirstPress(true);
            this.keypad.setOverwrite(true);
        } else if (e.getSource() == this.tip) {
            String text = this.tip.getText();
            this.keypad.setValue(text);
            this.keypad.setFirstPress(true);
            this.keypad.setOverwrite(true);
        } else if (e.getSource() == this.tendered) {
            String text = this.tendered.getText();
            this.keypad.setValue(text);
            this.keypad.setFirstPress(true);
            this.keypad.setOverwrite(true);
        }
    }

    void keypadUpdated() {
        double keypadValue = this.keypad.getValueAsDouble();
        Price tempPrice = new Price(keypadValue);
        if (this.paid.isSelected()) {
            this.paid.setText(tempPrice.toString());
            this.paidUpdated.emit((Object)tempPrice);
        } else if (this.tip.isSelected()) {
            this.tip.setText(tempPrice.toString());
            this.tipUpdated.emit((Object)tempPrice);
        } else if (this.tendered.isSelected()) {
            this.tendered.setText(tempPrice.toString());
            this.tenderedUpdated.emit((Object)tempPrice);
        }
    }

    static {
        COMPONENT_START = LABEL_WIDTH = 6;
        COMPONENT_WIDTH = 4;
    }
}

