/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.cashtransaction;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.Denomination;
import waitermate.guikit.dialogs.PopupWindow;

public class DenominationPopup {
    private static final Map<Denomination, String> iconMap = new HashMap<Denomination, String>();

    public void showDenominations(Collection<Denomination> deNoms) {
        JPanel holder = new JPanel();
        holder.setLayout(new FlowLayout(0, 20, 20));
        Price total = Price.ZERO_DOLLAR;
        for (Denomination nom : deNoms) {
            holder.add(this.renderNom(nom));
            total = total.add(new Price(nom.getValue(), 0.01));
        }
        PopupWindow popup = new PopupWindow();
        popup.setComponent((JComponent)holder);
        popup.setText("Please give " + total.toString(true) + " in change");
        popup.setOkButtonVisible(true);
        popup.setCancelButtonVisible(false);
        popup.setPreferredSize(new Dimension(600, 320));
        popup.start();
    }

    private JComponent renderNom(Denomination nom) {
        JLabel label = new JLabel();
        label.setIcon(IconLoader.get((String)iconMap.get(nom)));
        return label;
    }

    static {
        iconMap.put(Denomination.getFiveCents(), "/waitermate/images/fiveCents.png");
        iconMap.put(Denomination.getTenCents(), "/waitermate/images/tenCents.png");
        iconMap.put(Denomination.getTwentyCents(), "/waitermate/images/twentyCents.png");
        iconMap.put(Denomination.getFiftyCents(), "/waitermate/images/fiftyCents.png");
        iconMap.put(Denomination.getOneDollar(), "/waitermate/images/oneDollar.png");
        iconMap.put(Denomination.getTwoDollars(), "/waitermate/images/twoDollars.png");
        iconMap.put(Denomination.getFiveDollars(), "/waitermate/images/fiveDollars.png");
        iconMap.put(Denomination.getTenDollars(), "/waitermate/images/tenDollars.png");
        iconMap.put(Denomination.getTwentyDollars(), "/waitermate/images/twentyDollars.png");
        iconMap.put(Denomination.getFiftyDollars(), "/waitermate/images/fiftyDollars.png");
        iconMap.put(Denomination.getOneHundredDollars(), "/waitermate/images/hundredDollars.png");
    }
}

