/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.Task;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.integration.PropertyIntegrationUtils;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.debtor.SelectDebtorNavBar;
import waitermate.gui.screens.debtor.adddebtor.AddDebtor;
import waitermate.gui.screens.debtor.components.DebtorSelectionPanel;
import waitermate.gui.screens.payment.debtorTransaction.WaitermateDebtorAccessController;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.ProgressDialog;

public class DebtorTransaction
extends AbstractScreen {
    private Signal cancelSignal;
    private Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelectedSignal;
    private SelectDebtorNavBar nav = new SelectDebtorNavBar(true);
    private DebtorSelectionPanel debtorSelectionPanel = new DebtorSelectionPanel(this.nav);
    private AddDebtor addDebtorScreen = new AddDebtor();
    private Class typeFilter;
    private static DebtorTransaction instance = new DebtorTransaction();
    private WaitermateDebtorAccessController controller;

    public static DebtorTransaction getInstance() {
        return instance;
    }

    public static Signal createDebtorSelectedSignal() {
        return Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    }

    public static Signal createCancelledSignal() {
        return Signals.createSignal();
    }

    protected DebtorTransaction() {
        this.debtorSelectionPanel.setSetUp(false);
        this.nav.newDebtorSignal.connect((Object)this, "gotNewDebtor");
        this.nav.showReportButton(false);
        this.nav.back.connect((Object)this, "gotCancel");
        this.debtorSelectionPanel.debtorSelectedSignal.connect((Object)this, "gotDebtor");
        this.debtorSelectionPanel.back.connect((Object)this, "gotBack");
        this.addDebtorScreen.backSignal.connect((Object)this, "gotBack");
        this.addDebtorScreen.saveDebtorSignal.connect((Object)this, "gotDebtor");
        WaiterMateInputAdapter.getInstance().customerInput.connect((Object)this, "gotCustomerSwipe");
    }

    public JComponent getMainArea() {
        return this.debtorSelectionPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotBack() {
        this.display();
    }

    public void gotCancel() {
        this.cancelSignal.emit();
    }

    private void debtorSelected(AbstractDebtor debtor) {
        this.debtorSelectedSignal.emit((Object)debtor);
    }

    public void gotNewDebtor() {
        this.addDebtorScreen.start();
    }

    public void start(Signal cancel, Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected) {
        this.start(null, cancel, debtorSelected, null, null, "");
    }

    public void start(Class debtorType, Signal cancelled, Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected, Customer customer, Account account, String navText) {
        this.start(debtorType, cancelled, debtorSelected, new ArrayList<String>(), customer, account, navText);
    }

    public void start(Class debtorType, Signal cancelled, Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected, final String paymentStatus, Customer customer, Account account, String navText) {
        this.start(debtorType, cancelled, debtorSelected, (List<String>)new ArrayList<String>(){
            {
                this.add(paymentStatus);
            }
        }, customer, account, navText);
    }

    public void start(Class debtorType, Signal cancelled, Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected, List<String> paymentStatus, Customer customer, Account account, String navText) {
        this.debtorSelectionPanel.setSetUp(false);
        this.controller = new WaitermateDebtorAccessController();
        this.controller.setCustomer(customer);
        this.controller.setAccount(account);
        this.typeFilter = debtorType;
        this.debtorSelectionPanel.setTypeFilter(debtorType);
        this.debtorSelectedSignal = debtorSelected;
        this.cancelSignal = cancelled;
        this.getNavBar().setText(navText);
        this.controller.setDebtorList(this.debtorSelectionPanel.getDebtors());
        if (this.controller.debtorMatchingStrategyRequiresSelection()) {
            super.display();
            if (customer != null) {
                this.debtorSelectionPanel.setCustomer(customer);
            }
            if (paymentStatus != null) {
                for (String filter : paymentStatus) {
                    this.debtorSelectionPanel.gotPaymentStatusFilter(filter);
                }
            }
        } else {
            this.addDebtorScreen.saveDebtorSignal.emit((Object)this.controller.getMatchingDebtor());
        }
        this.debtorSelectionPanel.setSetUp(true);
        this.debtorSelectionPanel.updateModel();
    }

    public void gotCustomerSwipe(Customer customer) {
        if (this.isDisplaying() && this.controller != null) {
            if (SystemProperty.getInstance().isLoyaltyEnabled()) {
                ProgressDialog.doProgressDialog((Task)new LoyaltyResyncTask((GuiHandler)new WaitermateGuiHandler(), customer));
            }
            this.controller.setCustomer(customer);
            this.controller.notifyCustomerChange();
            if (!this.controller.debtorMatchingStrategyRequiresSelection()) {
                this.addDebtorScreen.saveDebtorSignal.emit((Object)this.controller.getMatchingDebtor());
            }
            this.debtorSelectionPanel.setCustomer(customer);
            if (this.controller.getAccount() != null) {
                Account account = this.controller.getAccount();
                account.setCustomer(customer, LoginManager.getEventContext());
                account.save();
                WaitermateAccountGui.getInstance().accountChanged(this.controller.getAccount());
            }
        }
    }

    public void gotDebtor(AbstractDebtor debtor) {
        if (this.controller.allowAccessToDebtor(debtor)) {
            this.debtorSelected(debtor);
        }
    }

    public void setUp() {
        super.setUp();
        this.debtorSelectionPanel.setSetUp(false);
        PropertyIntegrationUtils.synchronize();
        this.debtorSelectionPanel.clearSearch();
        if (this.typeFilter != null) {
            this.debtorSelectionPanel.setTypeFilter(this.typeFilter);
        } else {
            this.debtorSelectionPanel.clearTypeFilter();
        }
        this.debtorSelectionPanel.setSetUp(true);
        this.nav.refresh();
    }
}

