/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.signals.Signal;

public class GuestPanel
extends JPanel {
    private DefaultScrollPaneModel guestListModel = new DefaultScrollPaneModel(1, 3);
    private Signal chargeSignal = null;

    public GuestPanel(Signal chargeSignal) {
        CustomScrollPane guestListScrollPane = new CustomScrollPane((CustomScrollPaneModel)this.guestListModel);
        this.setLayout((LayoutManager)new GraphPaperLayout(1, 1));
        JPanel guestListPanel = new JPanel();
        this.add((Component)guestListPanel, new Rectangle(0, 0, 1, 1));
        guestListPanel.setLayout((LayoutManager)new GraphPaperLayout(1, 1));
        guestListPanel.add((Component)guestListScrollPane, new Rectangle(0, 0, 1, 1));
        this.chargeSignal = chargeSignal;
    }

    public void addAllGuests(List<GuestSuggestion> guests) {
        this.guestListModel.reset();
        if (guests == null || guests.isEmpty()) {
            return;
        }
        for (int i = 0; i < guests.size(); ++i) {
            final GuestSuggestion guestSuggestion = guests.get(i);
            JButton button = new JButton();
            button.setHorizontalAlignment(2);
            button.setHorizontalTextPosition(2);
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuestPanel.this.chargeSignal.emit((Object)guestSuggestion);
                }
            };
            action.putValue("Name", this.getCaption(guestSuggestion));
            button.setAction(action);
            this.guestListModel.addComponent((Component)button);
        }
    }

    private String getCaption(GuestSuggestion guestSuggestion) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table><tr>");
        sb.append("<td>Name</td><td><font size='+1'><span style='font-weight:bold'>");
        if (!StringUtils.isEmpty((String)guestSuggestion.getGuestFirstName())) {
            sb.append(guestSuggestion.getGuestFirstName());
            sb.append("  ");
        }
        sb.append(guestSuggestion.getGuestName());
        sb.append("</span></font></td>");
        if (!guestSuggestion.getRoomNumber().isEmpty()) {
            sb.append("<td>Room Number</td><td><font size='+1'><span style='font-weight:bold'>");
            sb.append(guestSuggestion.getRoomNumber());
            sb.append("</span></font></td>");
        }
        sb.append("</tr></table></html>");
        return sb.toString();
    }
}

