/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.piggy.SearchType;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.piggy.PiggyServiceBuilder;
import ordermate.integration.piggy.PiggyServiceProvider;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.debtorTransaction.GuestPanel;
import waitermate.gui.screens.payment.debtorTransaction.KeyPanel;
import waitermate.gui.screens.payment.debtorTransaction.PiggyDebtorNavBar;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class GuestSearchPanel
extends JPanel {
    protected static int NUM_RESULTS_TO_DISPLAY = 4;
    private static final String GUEST_CHARGED_SUCCESSFULLY = "Guest charged successfully . . .";
    private static final String CHARGE_REQUEST = "Charge Request";
    private static final String PIGGY_CHARGE_REQUEST_FAILED = "Property Integration Charge Request Failed : ";
    private static final String GUEST_CHARGE_REQUEST_FAILED = "Guest charge request failed . . .";
    private static final String DO_YOU_WANT_TO_CHARGE_THIS_GUEST = "Do you want to charge this guest ?";
    private static final String CHARGE_CONFIRMATION = "Charge Confirmation";
    private static final String SEARCHING_GUESTS = "Searching Guests . . .";
    private static final String GUEST_SEARCH_FAILED = "Guest Search failed : ";
    private static final String RESULTS_NOT_FOUND_PLEASE_REFINE_SEARCH = "Results not found: Please refine search";
    private static final String SEARCH_STATUS = "Search Status";
    private static final String PIGGY_SEARCH_FAILED = "Piggy Search Failed : ";
    private static final String REQUEST_STATUS = "Request Status";
    private static final String MONEY = "10000.00";
    private static final String EMPTY_SEARCH = "Please provide a valid search";
    private static final List<String> activeStatus = new ArrayList<String>(Arrays.asList("arrived"));
    private PiggyService piggyService;
    private SearchType searchType;
    String searchText = "";
    public Signal<?, ?, ?, ?, ?> back = Signals.createSignal();
    private JLabel textLabel;
    protected PiggyDebtorNavBar navBar;
    private KeyPanel keyboardPanel = new KeyPanel();
    private GuestPanel suggestionPanel;

    public GuestSearchPanel(boolean addNav, Signal chargeGuestSignal) {
        super(new BorderLayout());
        this.suggestionPanel = new GuestPanel(chargeGuestSignal);
        this.initPiggyService();
        this.setupComponents(addNav);
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
        switch (searchType) {
            case ROOM_NUMBER: {
                this.keyboardPanel.showRoomNumberDialog();
                break;
            }
            case GUEST_NAME: {
                this.keyboardPanel.showGuestNameDialog();
                break;
            }
            case SWIPE_CARD: {
                this.keyboardPanel.showCardSwipeDialog();
                break;
            }
        }
    }

    private void initPiggyService() {
        Terminal terminal = LoginManager.getEventContext().getTerminal();
        Long userId = LoginManager.getEventContext().getUser().getID();
        PiggyServiceBuilder piggyServiceBuilder = new PiggyServiceBuilder().setStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).setTerminalId(terminal.getID()).setTerminalName(terminal.getName());
        PiggyServiceProvider.setPiggyServiceBuilder((PiggyServiceBuilder)piggyServiceBuilder);
        this.piggyService = PiggyServiceProvider.getPiggyService();
    }

    private void setupComponents(boolean addNav) {
        if (addNav) {
            this.setupNavBar();
        }
        JPanel centerPanel = new JPanel();
        this.setPreferredSize(new Dimension(1200, 600));
        this.setMaximumSize(new Dimension(1200, 800));
        centerPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(1, 2), 0, 0));
        centerPanel.add((Component)this.suggestionPanel, new Rectangle(0, 0, 1, 1));
        centerPanel.add((Component)this.keyboardPanel, new Rectangle(0, 1, 1, 1));
        this.add((Component)centerPanel, "Center");
        if (addNav) {
            this.add((Component)((Object)this.navBar), "South");
        }
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    public void gotBack() {
        this.back.emit();
    }

    protected void setupNavBar() {
        this.navBar = new PiggyDebtorNavBar();
        this.navBar.back.connect((Object)this, "gotBack");
        this.navBar.searchButtonSignal.connect((Object)this, "searchButtonClicked");
    }

    private void doTheSearch() {
        GuestSearchTask guestSearchTask = new GuestSearchTask(this.searchText, this.searchType);
        try {
            ProgressDialog.doProgressDialog((Task)guestSearchTask);
            if (guestSearchTask.getResult().getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                List guestSuggestions = guestSearchTask.getResult().getPiggyResponse().getGuestSuggestions();
                if (guestSuggestions.size() == 0) {
                    Dialogs.displayOkDialog((String)RESULTS_NOT_FOUND_PLEASE_REFINE_SEARCH, (String)SEARCH_STATUS);
                } else {
                    this.suggestionPanel.addAllGuests(guestSuggestions);
                }
            } else {
                String errorMessage = guestSearchTask.getResult().getStatusMessage();
                if (guestSearchTask.getResult().getException() != null && guestSearchTask.getResult().getException() instanceof ClientHandlerException) {
                    errorMessage = guestSearchTask.getResult().getStatusMessage();
                } else if (guestSearchTask.getResult().getException() != null) {
                    errorMessage = guestSearchTask.getResult().getException().getMessage();
                }
                OrderMate.LOG.warn(PIGGY_SEARCH_FAILED + errorMessage, (Throwable)guestSearchTask.getResult().getException());
                Dialogs.displayOkDialog((String)GUEST_SEARCH_FAILED, (String)REQUEST_STATUS);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info(PIGGY_SEARCH_FAILED + ex.getMessage());
            Dialogs.displayOkDialog((String)(GUEST_SEARCH_FAILED + ex.getMessage()), (String)REQUEST_STATUS);
        }
    }

    public void searchButtonClicked() {
        this.searchText = this.keyboardPanel.getSearchText(this.searchType);
        if (!StringUtils.isEmpty((String)this.searchText) && !this.searchText.equals("0")) {
            this.doTheSearch();
        } else {
            Dialogs.displayOkDialog((String)EMPTY_SEARCH, (String)SEARCH_STATUS);
        }
    }

    class GuestSearchTask
    extends AbstractTask {
        private String searchText;
        private SearchType searchType;
        private PiggyResult piggyResult;
        private long terminalId;

        public GuestSearchTask(String searchText, SearchType searchType) {
            this.searchType = searchType;
            this.searchText = searchText;
        }

        public void setTerminalId(long terminalId) {
            this.terminalId = terminalId;
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        public String getName() {
            return GuestSearchPanel.SEARCHING_GUESTS;
        }

        public PiggyResult getResult() {
            return this.piggyResult;
        }

        protected void performTask() throws Exception {
            try {
                this.piggyResult = GuestSearchPanel.this.piggyService.searchGuest(this.searchText, this.searchType);
            }
            catch (Exception ex) {
                OrderMate.LOG.error(GuestSearchPanel.GUEST_SEARCH_FAILED + ex.getMessage(), (Throwable)ex);
                this.piggyResult = new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage(), null, ex);
                throw ex;
            }
        }
    }
}

