/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import au.com.ordermate.xmlintegration.piggy.PiggyResponse;
import au.com.ordermate.xmlintegration.piggy.SearchType;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.OrderMate;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.piggy.PiggyServiceBuilder;
import ordermate.integration.piggy.PiggyServiceProvider;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.debtor.components.DebtorPaymentProcessor;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.debtorTransaction.GuestPanel;
import waitermate.gui.screens.payment.debtorTransaction.GuestSearchPanel;
import waitermate.gui.screens.payment.debtorTransaction.KeyPanel;
import waitermate.gui.screens.payment.debtorTransaction.PiggyGuestSearchButtonPanel;
import waitermate.gui.screens.payment.transactions.DebtorSaleHandler;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class PiggyDebtorTransaction
extends AbstractScreen
implements ActionListener {
    private static final String GUEST_CHARGED_SUCCESSFULLY = "Guest charged successfully . . .";
    private static final String CHARGE_REQUEST = "Charge Request";
    private static final String PIGGY_CHARGE_REQUEST_FAILED = "Property Integration Charge Request Failed : ";
    private static final String GUEST_CHARGE_REQUEST_FAILED = "Guest charge request failed . . .";
    private static final String DO_YOU_WANT_TO_CHARGE_THIS_GUEST = "Do you want to charge this guest ?";
    private static final String CHARGE_CONFIRMATION = "Charge Confirmation";
    private static final String SEARCHING_GUESTS = "Searching Guests . . .";
    private static final String GUEST_SEARCH_FAILED = "Guest Search failed : ";
    private static final String RESULTS_NOT_FOUND_PLEASE_REFINE_SEARCH = "Results not found: Please refine search";
    private static final String SEARCH_STATUS = "Search Status";
    private static final String PIGGY_SEARCH_FAILED = "Piggy Search Failed : ";
    private static final String REQUEST_STATUS = "Request Status";
    private static final String MONEY = "10000.00";
    private static final String EMPTY_SEARCH = "Please provide a valid search";
    private static final List<String> activeStatus = new ArrayList<String>(Arrays.asList("arrived"));
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH;
    private static int COMPONENT_START;
    private static int COMPONENT_WIDTH;
    private JLabel due;
    private JLabel paid;
    private JLabel balance;
    private JButton tip;
    private Price tipAmount = Price.ZERO_DOLLAR;
    private JPanel fullPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private KeyPanel keyboardPanel = new KeyPanel();
    private NavBar nav = new NavBar();
    private PiggyGuestSearchButtonPanel guestSearchButtonPanel = new PiggyGuestSearchButtonPanel();
    private Signal currentScreenDisplay = Signals.createSignal();
    private Signal<GuestSuggestion, ?, ?, ?, ?> chargeGuestSignal = Signals.createSignal(GuestSuggestion.class, (String)"guestDetails");
    private GuestPanel suggestionPanel = new GuestPanel(this.chargeGuestSignal);
    private SearchType searchType;
    String searchText = "";
    private Signal done;
    private Signal cancelSignal;
    private DebtorPaymentProcessor debtorPaymentProcessor;
    private DebtorTransactionManager debtorTransactionManager;
    private ItemGroup itemGroup;
    private PiggyService piggyService;
    private GuestSearchPanel searchPanel;
    private JPanel textPanel;

    private void setupPaymentPanels() {
        JLabel dueLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DUE") + "</h2></html>");
        this.textPanel.add((Component)dueLabel, new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.due = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO") + "</h2></html>");
        this.due.setName("dueLabel");
        this.textPanel.add((Component)this.due, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        JPanel group1 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 5, 5));
        group1.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SUBTOTAL")));
        this.textPanel.add((Component)group1, new Rectangle(0, 1, 10, 3));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"PAID")), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.paid = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.paid.setName("paid");
        group1.add((Component)this.paid, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"TIP")), new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        this.tip = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.tip.setName("tip");
        this.tip.addActionListener(this);
        group1.add((Component)new StandardSecurityDecorator((JComponent)this.tip, AllPermissions.TIPS), new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
    }

    private void setupBalancePanel() {
        JLabel balanceLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"BALANCE") + "</h2></html>");
        this.textPanel.add((Component)balanceLabel, new Rectangle(LABEL_START, 5, LABEL_WIDTH, 1));
        this.balance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.balance.setName("balanceLabel");
        this.textPanel.add((Component)this.balance, new Rectangle(COMPONENT_START, 5, COMPONENT_WIDTH, 1));
    }

    private void setupComponents() {
        this.textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 7), 0, 0));
        this.setupPaymentPanels();
        this.setupBalancePanel();
    }

    public void init() {
        this.setupComponents();
        this.fullPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(4, 1), 0, 0));
        this.fullPanel.add((Component)this.guestSearchButtonPanel, new Rectangle(0, 0, 1, 1));
        this.fullPanel.add((Component)this.centerPanel, new Rectangle(1, 0, 3, 1));
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.centerPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(5, 1), 0, 0));
        this.centerPanel.add((Component)this.textPanel, new Rectangle(1, 0, 3, 1));
        this.due.setText("<html><h2>" + this.itemGroup.getDue() + "</h2></html>");
        this.paid.setText(this.itemGroup.getPaid().toString());
        this.tip.setText(Price.ZERO_DOLLAR.toString());
        this.balance.setText("<html><h2>" + this.itemGroup.getDue() + "</h2></html>");
        this.guestSearchButtonPanel.guestNameSearchSignal.connect((Object)this, "showGuestNameDialog");
        this.guestSearchButtonPanel.roomNumberSearchSignal.connect((Object)this, "showRoomNumberDialog");
        this.guestSearchButtonPanel.cardSwipeSearchSignal.connect((Object)this, "showCardSwipeDialog");
        this.nav.back.connect((Object)this, "backButtonPressed");
        this.currentScreenDisplay.connect((Object)this, "showCurrentScreen");
        this.chargeGuestSignal.connect((Object)this, "chargeGuest");
        this.initPiggyService();
        this.searchPanel = new GuestSearchPanel(true, this.chargeGuestSignal);
        this.searchPanel.back.connect((Object)this, "gotBackFromSearch");
    }

    private void showGuestNameDialog() {
        this.searchPanel.setSearchType(SearchType.GUEST_NAME);
        ScreenResource.startModalWindow((JPanel)this.searchPanel);
    }

    private void showRoomNumberDialog() {
        this.searchPanel.setSearchType(SearchType.ROOM_NUMBER);
        ScreenResource.startModalWindow((JPanel)this.searchPanel);
    }

    private void showCardSwipeDialog() {
        this.searchPanel.setSearchType(SearchType.SWIPE_CARD);
        ScreenResource.startModalWindow((JPanel)this.searchPanel);
    }

    public void gotBackFromSearch() {
        ScreenResource.stopWindow((JComponent)this.searchPanel);
    }

    private void initPiggyService() {
        Terminal terminal = LoginManager.getEventContext().getTerminal();
        Long userId = LoginManager.getEventContext().getUser().getID();
        PiggyServiceBuilder piggyServiceBuilder = new PiggyServiceBuilder().setStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).setTerminalId(terminal.getID()).setTerminalName(terminal.getName());
        PiggyServiceProvider.setPiggyServiceBuilder((PiggyServiceBuilder)piggyServiceBuilder);
        this.piggyService = PiggyServiceProvider.getPiggyService();
    }

    private void backButtonPressed() {
        WaiterMateInputAdapter.getInstance().swipecardInput.disconnect((Object)this.keyboardPanel);
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
        this.cancelSignal.emit();
    }

    public JComponent getMainArea() {
        return this.fullPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void searchButtonClicked() {
        this.searchType = this.guestSearchButtonPanel.getSearchType();
        this.searchText = this.keyboardPanel.getSearchText(this.searchType);
        if (!StringUtils.isEmpty((String)this.searchText) && !this.searchText.equals("0")) {
            this.doTheSearch();
        } else {
            Dialogs.displayOkDialog((String)EMPTY_SEARCH, (String)SEARCH_STATUS);
        }
    }

    private void doTheSearch() {
        GuestSearchTask guestSearchTask = new GuestSearchTask(this.searchText, this.searchType);
        try {
            ProgressDialog.doProgressDialog((Task)guestSearchTask);
            if (guestSearchTask.getResult().getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                List guestSuggestions = guestSearchTask.getResult().getPiggyResponse().getGuestSuggestions();
                if (guestSuggestions.size() == 0) {
                    Dialogs.displayOkDialog((String)RESULTS_NOT_FOUND_PLEASE_REFINE_SEARCH, (String)SEARCH_STATUS);
                } else {
                    this.suggestionPanel.addAllGuests(guestSuggestions);
                }
            } else {
                String errorMessage = guestSearchTask.getResult().getStatusMessage();
                if (guestSearchTask.getResult().getException() != null && guestSearchTask.getResult().getException() instanceof ClientHandlerException) {
                    errorMessage = guestSearchTask.getResult().getStatusMessage();
                } else if (guestSearchTask.getResult().getException() != null) {
                    errorMessage = guestSearchTask.getResult().getException().getMessage();
                }
                OrderMate.LOG.warn(PIGGY_SEARCH_FAILED + errorMessage, (Throwable)guestSearchTask.getResult().getException());
                Dialogs.displayOkDialog((String)GUEST_SEARCH_FAILED, (String)REQUEST_STATUS);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info(PIGGY_SEARCH_FAILED + ex.getMessage());
            Dialogs.displayOkDialog((String)(GUEST_SEARCH_FAILED + ex.getMessage()), (String)REQUEST_STATUS);
        }
    }

    public void setDebtorPaymentProcessor(DebtorPaymentProcessor debtorPaymentProcessor) {
        this.debtorPaymentProcessor = debtorPaymentProcessor;
    }

    public void setDebtorTransactionManager(DebtorTransactionManager debtorTransactionManager) {
        this.debtorTransactionManager = debtorTransactionManager;
    }

    public void setItemGroup(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    public void setDoneSignal(Signal done) {
        this.done = done;
    }

    private AbstractDebtor createRoomAccountDebtor(GuestSuggestion guestSuggestion) {
        this.closeAccountByStatusOfReservation(guestSuggestion);
        DebtorGroup piggyDebtorGroup = PiggyConfig.getConfig().getDebtorGroup();
        RoomAccount roomAccount = RoomAccount.getDebtorByNameAndExtID((String)guestSuggestion.getGuestName(), (String)guestSuggestion.getReservationId());
        if (roomAccount == null) {
            Price creditLimit = SystemProperty.getInstance().getRoomCreditLimit();
            if (guestSuggestion.getCreditLimit().doubleValue() > 0.0) {
                creditLimit = new Price((Number)guestSuggestion.getCreditLimit(), 0.01);
            }
            roomAccount = RoomAccount.createRoomAccount((String)guestSuggestion.getReservationId(), (Integer)guestSuggestion.getRoomAccountId(), (String)guestSuggestion.getGuestName(), (String)guestSuggestion.getRoomNumber(), (int)0, (Price)creditLimit, (Price)this.itemGroup.getAccount().getDue());
            roomAccount.setGroup(piggyDebtorGroup);
        } else {
            roomAccount.setExtID(guestSuggestion.getReservationId());
            if (guestSuggestion.getCreditLimit().doubleValue() > 0.0) {
                roomAccount.setCreditLimit(new Price((Number)guestSuggestion.getCreditLimit(), 0.01));
            }
            roomAccount.save();
        }
        return roomAccount;
    }

    private void closeAccountByStatusOfReservation(GuestSuggestion guestSuggestion) {
        if (guestSuggestion == null || guestSuggestion.getReservationId() == null || guestSuggestion.getReservationId().equals("")) {
            return;
        }
        String status = null;
        try {
            PiggyResult piggyResult = this.piggyService.retrieveReservationDetail(guestSuggestion.getReservationId());
            List guestSuggestionList = piggyResult.getPiggyResponse().getGuestSuggestions();
            if (guestSuggestionList != null && guestSuggestionList.size() > 0) {
                GuestSuggestion guestSuggestionFromRMS = (GuestSuggestion)guestSuggestionList.get(0);
                status = guestSuggestionFromRMS.getReservationStatus().toLowerCase();
            }
        }
        catch (Exception e) {
            String error = "Fetch reservation status failed duo to" + e;
            OrderMate.LOG.info(error);
        }
        if (status == null || status.equals("") || activeStatus.contains(status)) {
            return;
        }
        RoomAccount roomAccount = RoomAccount.getDebtorByNameAndExtID((String)guestSuggestion.getGuestName(), (String)guestSuggestion.getReservationId());
        OrderMate.LOG.info("Deactivated room account had data: \nRoom = " + roomAccount.getRoomNumber() + "\nFolio = " + roomAccount.getFolio() + "\nName = " + roomAccount.getLabel());
        roomAccount.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chargeGuest(GuestSuggestion gs) {
        if (Dialogs.displayChoiceDialog((String)DO_YOU_WANT_TO_CHARGE_THIS_GUEST, (String)CHARGE_CONFIRMATION, (boolean)true)) {
            this.gotBackFromSearch();
            AbstractDebtor debtor = null;
            try {
                BigDecimal totalAmount = this.itemGroup.getDue().toBigDecimal();
                Account account = this.itemGroup.getAccount();
                BigDecimal balance = gs.getBalanceAmount();
                if (balance == null) {
                    balance = BigDecimal.ZERO;
                }
                RoomAccount roomAccount = RoomAccount.getDebtorByNameAndExtID((String)gs.getGuestName(), (String)gs.getReservationId());
                BigDecimal creditLimit = gs.getCreditLimit() != null && gs.getCreditLimit().doubleValue() > 0.0 ? gs.getCreditLimit() : (roomAccount != null ? roomAccount.getCreditLimit().toBigDecimal() : SystemProperty.getInstance().getRoomCreditLimit().toBigDecimal());
                BigDecimal newBalance = balance.add(totalAmount);
                if (newBalance.compareTo(creditLimit) > 0) {
                    Price creditLimitPrice = new Price((Number)creditLimit, 0.01);
                    Dialogs.displayOkDialog((String)("The Credit Limit " + creditLimitPrice + " is reached, the Room Account charge cannot proceed"), (String)"Credit Limit is Reached");
                    return;
                }
                if (!account.isPersistent()) {
                    account.save();
                }
                List salesItemList = this.itemGroup.getAllItemsModifiable();
                PiggyResult piggyResult = this.piggyService.chargeGuest(account.getID(), gs, totalAmount, this.tipAmount.toBigDecimal(), salesItemList);
                if (piggyResult.isSuccess()) {
                    PiggyResponse chargeResponse = piggyResult.getPiggyResponse();
                    if (chargeResponse.isSuccess()) {
                        debtor = this.createRoomAccountDebtor(gs);
                        debtor.lock(account.getUser());
                        this.debtorPaymentProcessor.payToDebtor(account, debtor, this.debtorTransactionManager, this.tipAmount.toBigDecimal());
                        new DebtorSaleHandler().salePerformed(debtor, account);
                        WaitermateSaveAccount.getInstance().printClosingReceipts(account);
                        WaitermateSaveAccount.getInstance().printPrep(account);
                        debtor.unlock();
                        this.done.emit();
                        Dialogs.displayOkDialog((String)GUEST_CHARGED_SUCCESSFULLY, (String)CHARGE_REQUEST);
                    } else {
                        Dialogs.displayOkDialog((String)chargeResponse.getDescription(), (String)CHARGE_REQUEST);
                    }
                } else {
                    TerminalEventLog.getInst().logDebtorSaleFailed(LoginManager.getEventContext(), gs.getGuestName(), (ItemGroup)account);
                    OrderMate.LOG.info(PIGGY_CHARGE_REQUEST_FAILED + piggyResult.getStatusMessage());
                    Dialogs.displayOkDialog((String)GUEST_CHARGE_REQUEST_FAILED, (String)CHARGE_REQUEST);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
                Dialogs.displayOkDialog((String)GUEST_CHARGE_REQUEST_FAILED, (String)CHARGE_REQUEST);
            }
            finally {
                if (debtor != null) {
                    debtor.unlock();
                }
            }
        }
    }

    private void showCurrentScreen() {
        this.display(true);
    }

    public void setCancelSignal(Signal cancelSignal) {
        this.cancelSignal = cancelSignal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double newTip;
        if (e.getSource() == this.tip && (newTip = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"TIP") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")))) != Double.MIN_VALUE) {
            this.tipAmount = new Price(newTip, 0.01);
            this.tip.setText(this.tipAmount.toString());
            Price balanceAmount = this.tipAmount.add(this.itemGroup.getDue());
            this.balance.setText("<html><h2>" + balanceAmount + "</h2></html>");
        }
    }

    public void tearDown() {
        super.tearDown();
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
    }

    static {
        COMPONENT_START = LABEL_WIDTH = 7;
        COMPONENT_WIDTH = 3;
    }

    class GuestSearchTask
    extends AbstractTask {
        private String searchText;
        private SearchType searchType;
        private PiggyResult piggyResult;
        private long terminalId;

        public GuestSearchTask(String searchText, SearchType searchType) {
            this.searchType = searchType;
            this.searchText = searchText;
        }

        public void setTerminalId(long terminalId) {
            this.terminalId = terminalId;
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        public String getName() {
            return PiggyDebtorTransaction.SEARCHING_GUESTS;
        }

        public PiggyResult getResult() {
            return this.piggyResult;
        }

        protected void performTask() throws Exception {
            try {
                this.piggyResult = PiggyDebtorTransaction.this.piggyService.searchGuest(this.searchText, this.searchType);
            }
            catch (Exception ex) {
                OrderMate.LOG.error(PiggyDebtorTransaction.GUEST_SEARCH_FAILED + ex.getMessage(), (Throwable)ex);
                this.piggyResult = new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage(), null, ex);
                throw ex;
            }
        }
    }
}

