/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.Lockable;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorAccessController;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.matchingstrategy.AbstractCustomerToDebtorMatchingStrategy;
import ordermate.database.finance.debtors.matchingstrategy.CustomerToDebtorMatchingStrategy;
import ordermate.database.finance.debtors.matchingstrategy.CustomerToDebtorMatchingStrategyFactory;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.users.AllPermissions;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.gui.dialogs.UnlockDialog;
import waitermate.gui.modify.security.SwipeOverSecurityDecorator;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class WaitermateDebtorAccessController
implements DebtorAccessController {
    private Customer customer;
    private Account account;
    private List<AbstractDebtor> debtors;
    private PopupWindow debtorCustomerLockDialog;
    private PopupWindow confirmDialog;

    public boolean allowAccessToDebtor(AbstractDebtor debtor) {
        if (SystemProperty.getInstance().isLockDebtorWithoutCustomerSet()) {
            switch (this.checkDebtorForCustomer(debtor)) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.doDebtorCustomerLockShow()) break;
                    return false;
                }
                case 3: {
                    this.doCannotApplyDebtorToAccountShow();
                    return false;
                }
                default: {
                    throw new IllegalStateException("Unexpected case in switch statement");
                }
            }
        }
        if (!debtor.isLocked(LoginManager.getInstance().getUser()) && debtor.isLocked()) {
            UnlockDialog dialog = new UnlockDialog();
            if (dialog.display((Lockable)debtor, "Debtor account")) {
                return false;
            }
        } else if (debtor.relock(LoginManager.getInstance().getUser())) {
            return true;
        }
        return false;
    }

    private void doCannotApplyDebtorToAccountShow() {
        this.confirmDialog = Dialogs.createDialog((JComponent)Dialogs.createMessageLabel((String)"The Customer on the Account does not match the Debtor's Customer"), (String)"Cannot Apply Account to Debtor", null, null, (boolean)false, (boolean)false, (boolean)true);
        Dialogs.displayDialog((PopupWindow)this.confirmDialog, null, null);
    }

    private boolean doDebtorCustomerLockShow() {
        this.configureDebtorCustomerLockDialog();
        this.debtorCustomerLockDialog = Dialogs.setupPopupWindowForDialog((PopupWindow)this.debtorCustomerLockDialog, (JComponent)Dialogs.createMessageLabel((String)""), (String)"Swipe Customer Card", null, null, (boolean)true, (boolean)false);
        boolean result = Dialogs.displayDialog((PopupWindow)this.debtorCustomerLockDialog, null, null);
        return result;
    }

    private void configureDebtorCustomerLockDialog() {
        NavBar dialogNav = new NavBar();
        dialogNav.addLeft((Component)dialogNav.getCancelButton());
        this.debtorCustomerLockDialog = new PopupWindow(dialogNav, true);
        JButton customOkButton = dialogNav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/ok.png"), Internationalization.getLiteralFor((String)"OK"), "customOkButton");
        SwipeOverSecurityDecorator decoratedOk = new SwipeOverSecurityDecorator(customOkButton, AllPermissions.ACCESS_DEBTOR_ACCOUNTS, this.debtorCustomerLockDialog.getNavBar().ok, new String[]{"DebtorTransaction", "AbstractPaymentsScreen", "SelectAccount"});
        decoratedOk.setOverrideExistingImage(false);
        dialogNav.addRight((Component)((Object)decoratedOk));
    }

    int checkDebtorForCustomer(AbstractDebtor debtor) {
        int toReturn = 1;
        if (debtor instanceof CustomerDebtor) {
            Customer debtorCust = ((CustomerDebtor)debtor).getCustomer();
            if (debtorCust == null || this.customer == null) {
                toReturn = 2;
            } else if (!((CustomerDebtor)debtor).getCustomer().equals((Object)this.customer)) {
                toReturn = 3;
            }
        }
        return toReturn;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public void setDebtorList(List<AbstractDebtor> debtors) {
        this.debtors = debtors;
    }

    public boolean debtorMatchingStrategyRequiresSelection() {
        return this.getMatchingDebtor() == null;
    }

    public AbstractDebtor getMatchingDebtor() {
        AbstractCustomerToDebtorMatchingStrategy stratToUse = CustomerToDebtorMatchingStrategyFactory.getStrategy((CustomerToDebtorMatchingStrategy)SystemProperty.getInstance().getCustomerToDebtorMatchingStrategy());
        stratToUse.setController((DebtorAccessController)this);
        return stratToUse.matchDebtor(this.debtors);
    }

    public void notifyCustomerChange() {
        if (ScreenResource.isShowing((JComponent)this.debtorCustomerLockDialog)) {
            ScreenResource.stopWindow((JComponent)this.debtorCustomerLockDialog);
        } else if (ScreenResource.isShowing((JComponent)this.confirmDialog)) {
            ScreenResource.stopWindow((JComponent)this.confirmDialog);
        }
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }
}

