/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.eftpos;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionHelper;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.eftpos.WebPaymentRequest;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.ItemGroup;
import ordermate.integration.eftpos.EftposLogger;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.paypal.remote.WebPaymentIntegrationQueries;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateCustomerDisplayGuiHandler;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;
import waitermate.gui.screens.payment.eftpos.BlockingPanel;
import waitermate.gui.screens.payment.eftpos.EftposResultHandler;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;

public class EftposController {
    private BlockingPanel blockingPanel;
    public Signal<EftposTransaction, ?, ?, ?, ?> txnAdded = Signals.createSignal(EftposTransaction.class, (String)"added");
    public Signal<EftposTransaction, ?, ?, ?, ?> txnRemoved = Signals.createSignal(EftposTransaction.class, (String)"removed");
    public Signal<EftposTransaction, ?, ?, ?, ?> eftposFinished = Signals.createSignal(EftposTransaction.class, (String)"modified");
    public Signal<PreauthResult, ?, ?, ?, ?> preauthFinished = Signals.createSignal(PreauthResult.class, (String)"result");
    private Thread transactionThread = null;
    private EftposResultHandler resultHandler;
    private GuiHandler handler = new WaitermateGuiHandler();

    public Thread getTransactionThread() {
        return this.transactionThread;
    }

    public void performTransaction(EftposTransaction transaction, boolean reversed, Payable payable) {
        this.initResultHandler();
        EftposRequest request = this.makeEftposRequest(transaction, reversed, payable);
        if (request != null) {
            this.startTransaction(request);
        }
    }

    public List<String> getSupportedPreAuthTypes(PreauthTransaction txn) {
        return EftposManager.getInstance().getSupportedPreAuthTransactions(txn);
    }

    public void performPreauth(final PreauthRequest request) {
        this.initResultHandler();
        if (this.transactionThread == null) {
            if (this.blockingPanel == null) {
                this.blockingPanel = new BlockingPanel();
            }
            String message = "";
            message = Internationalization.getLiteralFor((String)"PLEASE_FOLLOW_PROMPTS_ON_EFTPOS_MACHINE");
            this.blockingPanel.setBlockingText(HtmlUtils.html((String)message));
            if (WaiterMateCustomerDisplay.isActive()) {
                message = Internationalization.getLiteralFor((String)"TOTAL") + " " + Internationalization.getLiteralFor((String)"DUE") + ": " + request.getTxn().getAmount().toString(true) + " - " + Internationalization.getLiteralFor((String)"PLEASE_HOLD_CARD_AGAINST_READER_TO_PAY");
                WaiterMateCustomerDisplay.getInstance().displayDialog(message);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenResource.startModalWindow((JPanel)EftposController.this.blockingPanel);
                }
            });
            Runnable eftposRunner = new Runnable(){

                @Override
                public void run() {
                    PreauthResult result = null;
                    try {
                        result = EftposManager.getInstance().performPreauthorisation(request);
                    }
                    catch (Exception ex) {
                        result = new PreauthResult(request, EftposStatus.ERROR, "Unknown Error", null);
                        OrderMate.LOG.error("Problem processing Eftpos Transaction", (Throwable)ex);
                    }
                    if (result == null) {
                        result = new PreauthResult(request, EftposStatus.ERROR, "Unknown Error occured during Pre-Auth", null);
                    }
                    final PreauthResult finalResult = result;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EftposController.this.stopPreauthTransaction(finalResult);
                        }
                    });
                }
            };
            this.transactionThread = new Thread(eftposRunner);
            this.transactionThread.start();
        } else {
            OrderMate.LOG.warn("startTransaction was called while a startTransaction task is running - call ignored");
        }
    }

    private void initResultHandler() {
        if (WaiterMateCustomerDisplay.isActive()) {
            this.handler = new WaitermateCustomerDisplayGuiHandler();
        }
        this.resultHandler = new EftposResultHandler(this, this.handler);
    }

    public void performTipAdjust(EftposTransaction transaction, Price tipAmount) {
        this.initResultHandler();
        if (transaction.adjustTipAmount(tipAmount)) {
            EftposRequest request = new EftposRequest(transaction, null, true, false, true);
            if (this.isOriginalTransactionTyroMobile(request)) {
                EventContext context = LoginManager.getEventContext();
                request.setTerminalToUse(context.getTerminal());
                request.setCashDrawerToUse(context.getTerminal().getAssignedCashDrawer(context.getUser()));
                request.setUpdateOriginalDetails(false);
            }
            this.startTransaction(request);
        }
    }

    public void performWebPayment(WebTransaction txn, Payable payable, WebPaymentCustomer customer) {
        this.initResultHandler();
        if (customer != null) {
            WebPaymentRequest request = new WebPaymentRequest((EftposTransaction)txn, payable, true, false, false, customer);
            this.startTransaction((EftposRequest)request);
        }
    }

    private EftposRequest makeEftposRequest(EftposTransaction txn, boolean reversed, Payable payable) {
        if (payable == null) {
            this.resultHandler.showEftposNotAllowedDialog(Internationalization.getLiteralFor((String)"EFTPOS_TRANSACTIONS_MUST_BE_FOR_A_PAYABLE_OBJECT"), Internationalization.getLiteralFor((String)"NO_PAYABLE_OBJECT"));
        }
        if (txn.getPaid().equals((Object)Price.ZERO_DOLLAR) && txn.getCashOut().equals((Object)Price.ZERO_DOLLAR) && txn.getTip().equals((Object)Price.ZERO_DOLLAR)) {
            this.resultHandler.showEftposNotAllowedDialog(Internationalization.getLiteralFor((String)"ZERO_DOLLAR_TRANSACTIONS_ARE_NOT_PERMITTED"), Internationalization.getLiteralFor((String)"CANNOT_PERFORM_ZERO_DOLLAR_TRANSACTION"));
            return null;
        }
        if (reversed && txn.getPaid().equals((Object)Price.ZERO_DOLLAR) && !txn.getCashOut().equals((Object)Price.ZERO_DOLLAR)) {
            this.resultHandler.showEftposNotAllowedDialog(Internationalization.getLiteralFor((String)"CASHOUTS_CANNOT_BE_REFUNDED"), Internationalization.getLiteralFor((String)"CANNOT_REFUND_CASHOUT"));
            return null;
        }
        boolean blocking = this.isBlockingTransaction(txn);
        if (txn instanceof WebTransaction) {
            return new WebPaymentRequest(txn, payable, blocking, reversed, false, WebPaymentIntegrationQueries.getPayPalIntegration());
        }
        return new EftposRequest(txn, payable, blocking, reversed, false);
    }

    private void startTransaction(final EftposRequest request) {
        EftposLogger.logMessage((String)"EftposController.startTransaction method invoked");
        if (request.isReversal() && request.getTransaction().getVirtualEftpos() != null && EftposType.ADYEN.equals((Object)request.getTransaction().getVirtualEftpos().getEftposType())) {
            String value = (String)Dialogs.displaySelectionDialog((String)"Select Refund Amount?", Arrays.asList("Partial", "Full Refund"));
            if (value == null) {
                return;
            }
            if ("Partial".equals(value)) {
                double partialRefundPrice = Dialogs.getPriceDouble((String)"Please choose the amount to refund");
                if (Double.MIN_VALUE == partialRefundPrice) {
                    return;
                }
                Price newPrice = new Price(partialRefundPrice, 0.01);
                if (newPrice.greaterThan((Object)FinanceTransactionHelper.getInstance().getAmountNotRefunded((FinanceTransaction)request.getTransaction())) || newPrice.greaterThan((Object)request.getPayable().getPaid())) {
                    Dialogs.displayOkDialog((String)"Cannot refund more than amount paid", (String)"Error Creating Request");
                    return;
                }
                request.setReversalAmount(newPrice);
            } else if ("Full Refund".equals(value) && !Dialogs.displayChoiceDialog((String)"This will refund the entire amount to the card, continue?", (String)"Refund Transaction", (boolean)false)) {
                return;
            }
        }
        if (this.transactionThread == null) {
            if (request.isBlocking()) {
                if (this.blockingPanel == null) {
                    this.blockingPanel = new BlockingPanel();
                }
                String message = "";
                if (request.getTransaction() instanceof WebTransaction) {
                    EftposLogger.logMessage((String)"EftposController.startTransaction transaction is WebTransaction");
                    message = "Completing web transaction...";
                    this.blockingPanel.setBlockingText(HtmlUtils.html((String)message));
                    EftposLogger.logMessage((String)("EftposController.startTransaction WebTransaction display dialog with message : " + message));
                    if (WaiterMateCustomerDisplay.isActive()) {
                        WaiterMateCustomerDisplay.getInstance().displayDialog(message);
                    }
                } else {
                    message = Internationalization.getLiteralFor((String)"PLEASE_FOLLOW_PROMPTS_ON_EFTPOS_MACHINE");
                    EftposLogger.logMessage((String)("EftposController.startTransaction display dialog with message : " + message));
                    this.blockingPanel.setBlockingText(HtmlUtils.html((String)message));
                    if (WaiterMateCustomerDisplay.isActive()) {
                        message = Internationalization.getLiteralFor((String)"TOTAL") + " " + Internationalization.getLiteralFor((String)"DUE") + ": " + request.getTransaction().getPaid().toString(true) + " - " + Internationalization.getLiteralFor((String)"PLEASE_HOLD_CARD_AGAINST_READER_TO_PAY");
                        WaiterMateCustomerDisplay.getInstance().displayDialog(message);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EftposLogger.logMessage((String)"EftposController.startTransaction before start Modal Window");
                        ScreenResource.startModalWindow((JPanel)EftposController.this.blockingPanel);
                        EftposLogger.logMessage((String)"EftposController.startTransaction after start Modal Window");
                    }
                });
            }
            Runnable eftposRunner = new Runnable(){

                @Override
                public void run() {
                    EftposResult result = null;
                    try {
                        EftposLogger.logMessage((String)"EftposController.startTransaction initiating a performTransaction ");
                        result = EftposManager.getInstance().performTransaction(request);
                        EftposLogger.logMessage((String)("EftposController.startTransaction completed performTransaction with result eftposStatus : " + result.getEftposStatus()));
                    }
                    catch (Exception ex) {
                        result = new EftposResult(request, EftposStatus.ERROR, request.getTransaction().getSubType(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
                        OrderMate.LOG.error("Problem processing Eftpos Transaction", (Throwable)ex);
                    }
                    final EftposResult finalResult = result;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EftposController.this.stopTransaction(finalResult);
                        }
                    });
                }
            };
            this.transactionThread = new Thread(eftposRunner, "Blocking Eftpos");
            this.transactionThread.start();
        } else {
            OrderMate.LOG.warn("startTransaction was called while a startTransaction task is running - call ignored");
        }
    }

    private void stopTransaction(EftposResult result) {
        EftposLogger.logMessage((String)"EftposController.stopTransaction method entered.");
        this.initiateTeardown();
        EftposTransaction transaction = result.getRequest().getTransaction();
        if (result.getRequest().isTippingAdjustment()) {
            if (!result.isApproved()) {
                transaction.adjustTipAmount(Price.ZERO_DOLLAR);
                OrderMateLog.LOG.info("Tipping has not been adjusted");
            } else {
                OrderMateLog.LOG.info("Tipping has been adjusted, clearing RRN");
                transaction.setTipReference(null);
                transaction.getPayoffGroup().save();
            }
        }
        if (transaction.getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.PROCESSED)) {
            Payable payable = result.getRequest().getPayable();
            if (payable != null && !payable.getFinanceTransactions().contains(transaction)) {
                payable.addFinanceTransaction((FinanceTransaction)transaction);
            }
            if (result.isApproved()) {
                this.resultHandler.handleEftposAllGood(result);
            } else {
                this.resultHandler.handleEftposNoGood(result);
            }
        } else {
            this.resultHandler.handleProblemStatus(result);
        }
        this.eftposFinished.emit((Object)result.getRequest().getTransaction());
        this.transactionThread = null;
    }

    private void stopPreauthTransaction(PreauthResult result) {
        this.initiateTeardown();
        this.preauthFinished.emit((Object)result);
        this.transactionThread = null;
    }

    private void initiateTeardown() {
        EftposLogger.logMessage((String)"EftposController.initiateTearDown : method entered ");
        int count = 0;
        while (count < 10 && !ScreenResource.isShowing((JComponent)this.blockingPanel)) {
            ++count;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex2) {
                OrderMateLog.LOG.warn("Interrupted while waiting for blocking panel to appear", (Throwable)ex2);
            }
        }
        EftposLogger.logMessage((String)"EftposController.initiateTearDown : Requesting Blocking Panel to be closed");
        EftposLogger.logMessage((String)"EftposController.initiateTearDown : before stopWindow ");
        ScreenResource.stopWindow((JComponent)this.blockingPanel);
        EftposLogger.logMessage((String)"EftposController.initiateTearDown : after stopWindow ");
        EftposLogger.logMessage((String)"EftposController.initiateTearDown : Blocking Panel successfully closed");
        if (WaiterMateCustomerDisplay.isActive()) {
            WaiterMateCustomerDisplay.getInstance().stopDialog();
        }
        EftposLogger.logMessage((String)"EftposController.initiateTearDown : completed ");
    }

    void performOfflineTransaction(EftposTransaction txn, boolean isReversal, Payable payable) {
        this.initResultHandler();
        EftposTransaction newTxn = txn;
        if (!isReversal) {
            newTxn = txn.copyTransaction();
        }
        EftposRequest newRequest = this.makeEftposRequest(newTxn, isReversal, payable);
        EftposResult result = EftposManager.getInstance().performOfflineTransaction(newRequest);
        if (result.isApproved()) {
            ItemGroup account = null;
            if (payable != null && payable instanceof ItemGroup) {
                account = (ItemGroup)payable;
            }
            TerminalEventLog.logOfflineEftpos((EventContext)LoginManager.getEventContext(), (FinanceTransaction)txn, account);
            EftposTransaction finalTxn = result.getRequest().getTransaction();
            if (isReversal) {
                payable.removeFinanceTransaction((FinanceTransaction)finalTxn);
                this.txnRemoved.emit((Object)finalTxn);
            } else {
                payable.addFinanceTransaction((FinanceTransaction)finalTxn);
                this.txnAdded.emit((Object)finalTxn);
            }
        }
        this.eftposFinished.emit((Object)result.getRequest().getTransaction());
    }

    private boolean isBlockingTransaction(EftposTransaction transaction) {
        return true;
    }

    private boolean isOriginalTransactionTyroMobile(EftposRequest request) {
        return request.getTransaction().getVirtualEftpos() != null && EftposType.TYROMOBILE.equals((Object)request.getTransaction().getVirtualEftpos().getEftposType());
    }
}

