/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.eftpos;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.integration.eftpos.EftposLogger;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

class EftposResultHandler {
    private static final String ERROR = "Error During Transaction";
    private final EftposController controller;
    private final GuiHandler guiHandler;

    public EftposResultHandler(EftposController controller, GuiHandler handler) {
        this.controller = controller;
        this.guiHandler = handler;
    }

    void handleEftposAllGood(EftposResult result) {
        EftposLogger.logMessage((String)"EftposResultHandler.handleEftposAllGood method entered");
        if (result.getRequest().isReversal() && !result.getRequest().getTransaction().getCashOut().equals((Object)Price.ZERO_DOLLAR)) {
            StringBuilder message = new StringBuilder("<html>" + Internationalization.getLiteralFor((String)"THE_TRANSACTION_HAS_BEEN_REFUNDED_SUCCESSFULLY") + "<p>");
            message.append("However, since Cash Out cannot be refunded,<br>the Cash Out amount <b>has not</b> been refunded.");
            message.append("</html>");
            EftposLogger.logMessage((String)("EftposResultHandler.handleEftposAllGood method before refund complete message " + message));
            this.guiHandler.displayOkDialog(Internationalization.getLiteralFor((String)"REFUND_COMPLETE"), message.toString());
            EftposLogger.logMessage((String)"EftposResultHandler.handleEftposAllGood method after refund complete message ");
        }
        if (result.getRequest().isReversal() && result.getRequest().getPayable() != null) {
            result.getRequest().getPayable().removeFinanceTransaction((FinanceTransaction)result.getRequest().getTransaction());
            this.controller.txnRemoved.emit((Object)result.getRequest().getTransaction());
            if (result.getRequest().getTransaction() != result.getOldEftposTransaction()) {
                result.getRequest().getPayable().removeFinanceTransaction((FinanceTransaction)result.getOldEftposTransaction());
                this.controller.txnRemoved.emit((Object)result.getOldEftposTransaction());
            }
        } else {
            this.controller.txnAdded.emit((Object)result.getRequest().getTransaction());
        }
        EftposLogger.logMessage((String)"EftposResultHandler.handleEftposAllGood method completed");
    }

    void handleEftposNoGood(EftposResult result) {
        EftposLogger.logMessage((String)"handleEftposNoGood : method entered ");
        if (result.getRequest().isBlocking()) {
            EftposLogger.logMessage((String)"handleEftposNoGood : Blocking request ");
            EftposStatus status = result.getEftposStatus();
            EftposLogger.logMessage((String)"handleEftposNoGood : before showing dialog");
            if (result.hasExplicitError()) {
                this.guiHandler.displayOkDialog(HtmlUtils.html((String)result.getExplicitError()), ERROR);
            } else if (status.equals((Object)EftposStatus.CANCELLED)) {
                EftposLogger.logMessage((String)("handleEftposNoGood : inside CANCELLED " + result.isShowError()));
                if (result.isShowError()) {
                    this.guiHandler.displayOkDialog(HtmlUtils.html((String)Internationalization.getLiteralFor((String)"THE_EFTPOS_TRANSACTION_WAS_CANCELLED_BY_THE_USER")), Internationalization.getLiteralFor((String)"EFTPOS_CANCELLED"));
                }
            } else if (status.equals((Object)EftposStatus.DECLINED)) {
                EftposLogger.logMessage((String)"handleEftposNoGood : inside DECLINED ");
                this.guiHandler.displayOkDialog(HtmlUtils.html((String)Internationalization.getLiteralFor((String)"THE_EFTPOS_TRANSACTION_WAS_DECLINED_BY_THE_BANK")), Internationalization.getLiteralFor((String)"EFTPOS_DECLINED"));
            } else if (status.equals((Object)EftposStatus.ERROR)) {
                EftposLogger.logMessage((String)"handleEftposNoGood : inside ERROR ");
                this.guiHandler.displayOkDialog(HtmlUtils.html((String)(Internationalization.getLiteralFor((String)"THE_EFTPOS_TRANSACTION_WAS_REJECTED_BY_THE_BANK") + "<p>" + Internationalization.getLiteralFor((String)"PLEASE_CONTACT_YOUR_EFTPOS_PROVIDER_FOR_FURTHER_INFORMATION"))), Internationalization.getLiteralFor((String)"THE_EFTPOS_WAS_REJECTED_BY_THE_BANK"));
            }
            EftposLogger.logMessage((String)"handleEftposNoGood : after dialog has been closed");
        }
        if (!result.getRequest().isReversal() && result.getRequest().getPayable() != null) {
            result.getRequest().getPayable().removeFinanceTransaction((FinanceTransaction)result.getRequest().getTransaction());
            this.controller.txnRemoved.emit((Object)result.getRequest().getTransaction());
        }
        EftposLogger.logMessage((String)"handleEftposNoGood : method completed");
    }

    void handleProblemStatus(EftposResult result) {
        EftposLogger.logMessage((String)"handleProblemStatus : method entered ");
        if (result.getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.FAILED)) {
            if (this.checkCorrectTerminal(result)) {
                this.showFailureDialog(result);
            }
        } else if (result.getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.BUSY)) {
            this.showEftposBusyDialog(result);
        } else if (result.getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.NOT_CONNECTED)) {
            this.showEftposNotConnectedDialog(result);
        } else if (result.getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.NOT_PROCESSED) && result.getCardType() == null) {
            this.showCannotQuickEftpos(result);
        }
        EftposLogger.logMessage((String)"handleProblemStatus : method completed ");
    }

    void showFailureDialog(EftposResult result) {
        EftposLogger.logMessage((String)"showFailureDialog : method entered ");
        StringBuilder message = new StringBuilder("<html>The Eftpos Transaction has failed<br>");
        if (!StringUtils.isEmpty((String)result.getExplicitError())) {
            message.append(result.getExplicitError() + "<br><br>");
        }
        message.append("WaiterMate will not record this transaction,<br>").append("and all previous dockets that may have printed<br>").append("relating to this transaction are invalid.<br><br>").append("Contact your Eftpos provider regarding the reason for the failure.</html>");
        this.guiHandler.displayOkDialog("Eftpos Transaction Failed", message.toString());
        EftposLogger.logMessage((String)"showFailureDialog : method completed ");
    }

    void showCannotQuickEftpos(EftposResult result) {
        EftposLogger.logMessage((String)"showCannotQuickEftpos : method entered ");
        StringBuilder message = new StringBuilder("<html>Cannot perform a Quick Eftpos<br><br>").append("No Eftpos has been configured for this terminal,<br>").append("or the eftpos terminal cannot read the card type.");
        this.guiHandler.displayOkDialog(Internationalization.getLiteralFor((String)"QUICK_EFTPOS_UNAVAILABLE"), message.toString());
        EftposLogger.logMessage((String)"showCannotQuickEftpos : method completed ");
    }

    void showEftposBusyDialog(EftposResult result) {
        EftposLogger.logMessage((String)"showEftposBusyDialog : method entered ");
        StringBuilder message = new StringBuilder("<html>The Eftpos Terminal attached to CashDrawer:<br>").append(result.getRequest().getTransaction().getCashDrawer().getLabel()).append("<br>appears to be busy, or it may not be connected.").append("<br><br>Please ensure that the eftpos is connected,<br>and wait until the previous transaction is complete.").append("<br>Alternatively try another terminal.</html>");
        if (!result.getRequest().isTippingAdjustment()) {
            EftposLogger.logMessage((String)"showEftposBusyDialog : showing Offiline Enabled ");
            this.doOfflineEnabledWindow(result, message.toString(), Internationalization.getLiteralFor((String)"EFTPOS_BUSY"));
        } else {
            EftposLogger.logMessage((String)"showEftposBusyDialog : showing eftpos Busy dialog");
            this.guiHandler.displayOkDialog(Internationalization.getLiteralFor((String)"EFTPOS_BUSY"), message.toString());
        }
        EftposLogger.logMessage((String)"showEftposBusyDialog : method completed ");
    }

    void showEftposNotConnectedDialog(EftposResult result) {
        EftposLogger.logMessage((String)"showEftposNotConnectedDialog : method entered ");
        StringBuilder message = new StringBuilder("<html>The Eftpos Terminal attached to CashDrawer:").append(result.getRequest().getTransaction().getCashDrawer().getLabel()).append(" cannot be contacted.<br><br>Please check that it is connected, and that ").append("all settings are correctly configured.</html>");
        if (!result.getRequest().isTippingAdjustment() && result.getRequest().getTransaction().getType() != null) {
            EftposLogger.logMessage((String)"showEftposNotConnectedDialog : showing Offiline Enabled ");
            this.doOfflineEnabledWindow(result, message.toString(), Internationalization.getLiteralFor((String)"EFTPOS_NOT_CONNECTED"));
        } else if (result.hasExplicitError()) {
            EftposLogger.logMessage((String)"showEftposNotConnectedDialog : EFTPOS Not Connected with explicit error");
            this.guiHandler.displayOkDialog(Internationalization.getLiteralFor((String)"EFTPOS_NOT_CONNECTED"), result.getExplicitError());
        } else {
            EftposLogger.logMessage((String)"showEftposNotConnectedDialog : EFTPOS Not Connected");
            this.guiHandler.displayOkDialog(Internationalization.getLiteralFor((String)"EFTPOS_NOT_CONNECTED"), message.toString());
        }
        EftposLogger.logMessage((String)"showEftposNotConnectedDialog : method completed");
    }

    void showEftposNotAllowedDialog(String reason, String title) {
        StringBuilder message = new StringBuilder("<html>That Eftpos transaction cannot be performed:<br><br>").append(reason).append("</html>");
        this.guiHandler.displayOkDialog(title, message.toString());
    }

    private boolean checkCorrectTerminal(EftposResult result) {
        if (result.getTerminalID() != null && result.getTerminalID().trim().length() > 0) {
            String actualID = result.getTerminalID().trim();
            String expectedID = EftposManager.getInstance().getEftposTerminalID(result.getRequest());
            if (expectedID != null && (expectedID = expectedID.trim()).length() > 0 && !expectedID.equals(result.getTerminalID())) {
                String warning = "Eftpos transaction cannot be performed on incorrect eftpos terminal, expected:" + expectedID + " but was:" + actualID;
                OrderMateLog.LOG.warn(warning);
                this.guiHandler.displayOkDialog("Incorrect terminal attached", HtmlUtils.html((String)(warning + "<br>" + "Please connect the correct Eftpos terminal for future transactions.")));
                return false;
            }
        }
        return true;
    }

    private void doOfflineEnabledWindow(EftposResult result, String message, String title) {
        EftposLogger.logMessage((String)"doOfflineEnabledWindow : method entered");
        final PopupWindow window = new PopupWindow();
        NavBar bar = window.getNavBar();
        bar.removeRight((Component)bar.getOkButton());
        bar.removeLeft((Component)bar.getCancelButton());
        bar.addRight((Component)bar.getCancelButton());
        bar.getCancelButton().setText(Internationalization.getLiteralFor((String)"CANCEL"));
        JButton offlineBut = bar.constructButton((Icon)IconLoader.get((String)"/waitermate/images/offlineEftpos.png"), Internationalization.getLiteralFor((String)"PERFORM_OFFLINE"), "offlineEftpos");
        StandardSecurityDecorator performOffline = new StandardSecurityDecorator((JComponent)offlineBut, AllPermissions.OFFLINE_EFTPOS);
        offlineBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.gotOk();
            }
        });
        bar.addLeft((Component)performOffline);
        JLabel label = Dialogs.createMessageLabel((String)message);
        window.setComponent((JComponent)label);
        window.setText(title);
        EftposLogger.logMessage((String)"doOfflineEnabledWindow : showing dialog");
        if (Dialogs.displayDialog((PopupWindow)window, null, null)) {
            EftposTransaction txn = result.getRequest().getTransaction();
            this.controller.performOfflineTransaction(txn, result.getRequest().isReversal(), result.getRequest().getPayable());
        } else {
            this.controller.eftposFinished.emit((Object)result.getRequest().getTransaction());
        }
        EftposLogger.logMessage((String)"doOfflineEnabledWindow : method completed");
    }
}

