/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.eftpos;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.payment.AbstractTransactionNav;

public abstract class EftposTransactionNav
extends AbstractTransactionNav {
    public final Signal doOfflineEftpos = Signals.createSignal();
    private StandardSecurityDecorator offlineEftpos;
    public final Signal noteUpdated = Signals.createSignal();
    private JButton noteButton;

    public EftposTransactionNav() {
        super(false);
        this.setText(this.getNavBarName());
        this.removeLeft(this.getBackButton());
        this.addLeft(this.getBackButton());
        this.noteButton = this.constructButton(IconLoader.get((String)"/waitermate/guikit/images/keyboard.png"), Internationalization.getLiteralFor((String)"ADD_NOTE"), "Note", this.noteUpdated);
        this.addLeft(this.noteButton);
        if (this.isOfflineEftposEnabled()) {
            JButton offlineBut = this.constructButton(IconLoader.get((String)"/waitermate/images/offlineEftpos.png"), Internationalization.getLiteralFor((String)"OFFLINE_EFTPOS"), "offlineEftpos", this.doOfflineEftpos);
            this.offlineEftpos = new StandardSecurityDecorator((JComponent)offlineBut, AllPermissions.OFFLINE_EFTPOS);
            this.addLeft((Component)this.offlineEftpos);
        }
    }

    protected boolean isOfflineEftposEnabled() {
        return PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled);
    }

    protected abstract String getNavBarName();

    protected void setEnableOfflineEftpos(boolean value) {
        if (this.offlineEftpos != null) {
            this.offlineEftpos.setEnabled(value);
        }
    }
}

