/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.loyaltytransaction;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Customer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

class LoyaltyRedemptionNav
extends NavBar {
    private JLabel customerLabel;
    private JLabel available;
    private JLabel used;
    private JLabel remaining;
    private JLabel availableAmount;
    private JLabel usedAmount;
    private JLabel remainingAmount;
    public final Signal addItems = Signals.createSignal();

    public LoyaltyRedemptionNav() {
        this.setupComponents();
    }

    private void setupComponents() {
        JComponent infoPanel = this.makeInfoPanel();
        this.addLeft(this.getBackButton());
        this.add(infoPanel, "Center");
        this.addRight(this.getOkButton());
    }

    private JComponent makeInfoPanel() {
        JPanel informationPanel = new JPanel();
        informationPanel.setLayout(new GridLayout(4, 2, 5, 5));
        informationPanel.setBorder(BorderFactory.createTitledBorder("Loyalty Points:"));
        this.available = new JLabel("Points available");
        this.used = new JLabel("Points used");
        this.remaining = new JLabel("Points remaining");
        this.remaining.setForeground(Color.RED);
        this.availableAmount = new JLabel("0");
        this.usedAmount = new JLabel("0");
        this.remainingAmount = new JLabel("0");
        this.remainingAmount.setForeground(Color.RED);
        this.usedAmount.setName("used_Amount");
        this.remainingAmount.setName("remaining_Amount");
        informationPanel.add(new JLabel("Customer"));
        this.customerLabel = new JLabel("None");
        informationPanel.add(this.customerLabel);
        informationPanel.add(this.available);
        informationPanel.add(this.availableAmount);
        informationPanel.add(this.used);
        informationPanel.add(this.usedAmount);
        informationPanel.add(this.remaining);
        informationPanel.add(this.remainingAmount);
        return informationPanel;
    }

    public void setDetails(Customer customer, int availablePoints, int usedPoints) {
        this.customerLabel.setText(customer.getNameAndTitle());
        this.availableAmount.setText(Integer.toString(availablePoints));
        this.usedAmount.setText(Integer.toString(usedPoints));
        this.remainingAmount.setText(Integer.toString(availablePoints - usedPoints));
    }
}

