/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.loyaltytransaction;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.LoyaltyPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.sales.loyalty.RedeemingLoyaltyPointTransaction;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.payment.loyaltytransaction.LoyaltyRedemptionNav;
import waitermate.gui.screens.payment.loyaltytransaction.LoyaltyRedemptionPanel;
import waitermate.gui.screens.payment.loyaltytransaction.RedeemingItem;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.ProgressDialog;

public class LoyaltyRedemptionScreen
extends AbstractScreen {
    private LoyaltyRedemptionPanel gui;
    private LoyaltyRedemptionNav nav;
    private int virtualPoints = 0;
    private final List<RedeemingItem> availableItems = new ArrayList<RedeemingItem>();
    private final Set<RedeemingItem> removedRedemptions = new HashSet<RedeemingItem>();
    private final List<RedeemingItem> addedItems = new ArrayList<RedeemingItem>();
    private ItemGroup account;
    private Customer customer;

    public LoyaltyRedemptionScreen() {
        this.gui = new LoyaltyRedemptionPanel();
        this.gui.removeItem.connect((Object)this, "gotRemoveItem");
        this.gui.addItem.connect((Object)this, "gotAddItem");
        this.nav = new LoyaltyRedemptionNav();
        WaiterMateInputAdapter.getInstance().customerInput.connect((Object)this, "gotCustomerChanged");
        this.nav.ok.connect((Object)this, "gotOK");
    }

    public void startRedeemingItems(ItemGroup payGroup) {
        this.resetCurrentInfo();
        this.account = payGroup;
        this.customer = this.account.getCustomer();
        this.addRedeemableItemsToCollection(this.availableItems, LoyaltyPointAdministrator.getInstance().getAllRedeemableItems(this.account, Integer.MAX_VALUE));
        this.addRedeemableItemsToCollection(this.addedItems, LoyaltyPointAdministrator.getInstance().getAllRedeemedItems(this.account));
        this.show();
    }

    private void updateGui() {
        this.calculateLoyaltyPoints();
        this.gui.setRedeemedItems(this.addedItems);
        this.gui.setAvailableItems(this.cullCannotAffords(this.availableItems));
        this.nav.setDetails(this.customer, this.virtualPoints, this.getPointsUsed());
    }

    private List<RedeemingItem> cullCannotAffords(List<RedeemingItem> items) {
        ArrayList<RedeemingItem> newList = new ArrayList<RedeemingItem>();
        int pointsLeft = this.getPointsLeft();
        for (RedeemingItem nextItem : items) {
            if (nextItem.getCost() / nextItem.getQuantity() > pointsLeft) continue;
            newList.add(nextItem);
        }
        return newList;
    }

    private void calculateLoyaltyPoints() {
        this.virtualPoints = this.customer.getLoyaltyPoints();
        for (RedeemingItem nextItem : this.removedRedemptions) {
            if (!this.customer.equals((Object)nextItem.getCustomer())) continue;
            this.virtualPoints += nextItem.getCost();
        }
    }

    private void addRedeemableItemsToCollection(Collection<RedeemingItem> items, Collection<SalesLineItem> lineItems) {
        for (SalesLineItem nextItem : lineItems) {
            int qty;
            int n = qty = nextItem.getQuantity().getValue().intValue() > 0 ? nextItem.getQuantity().getValue().intValue() : 1;
            if (!nextItem.hasLoyaltyPointsAvailable()) {
                items.add(new RedeemingItem(nextItem, qty, this.resolveCustomer(nextItem), true));
                continue;
            }
            items.add(new RedeemingItem(nextItem, qty, null, false));
        }
    }

    private Customer resolveCustomer(SalesLineItem theItem) {
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        for (SalesPriceAdjustment nextAdj : theItem.getPriceAdjustments()) {
            RedeemingLoyaltyPointTransaction txn;
            if (!loyaltyAdj.equals((Object)nextAdj.getInventoryPriceAdjustment()) || (txn = ((SalesPriceAdjustmentUsage)nextAdj.getPriceAdjustmentUsagesSafe().get(0)).getActiveLoyaltyTransaction()) == null) continue;
            return txn.getCustomer();
        }
        return null;
    }

    void gotAddItem(RedeemingItem toAdd) {
        RedeemingItem removedItem;
        RedeemingItem addedItem = this.getEquivalentItem(this.addedItems, toAdd, this.customer);
        if (addedItem == null || !this.customer.equals((Object)addedItem.getCustomer())) {
            addedItem = new RedeemingItem(toAdd.getItem(), 0, this.customer, false);
            this.addedItems.add(addedItem);
        }
        addedItem.increment();
        toAdd.decrement();
        if (toAdd.getQuantity() == 0) {
            this.availableItems.remove(toAdd);
        }
        if ((removedItem = this.getEquivalentItem(this.removedRedemptions, toAdd, toAdd.getCustomer())) != null) {
            removedItem.decrement();
            if (removedItem.getQuantity() == 0) {
                this.removedRedemptions.remove(removedItem);
            }
        }
        this.updateGui();
    }

    void gotRemoveItem(RedeemingItem toRemove) {
        RedeemingItem availItem = this.getEquivalentItem(this.availableItems, toRemove, null);
        if (availItem == null) {
            availItem = new RedeemingItem(toRemove.getItem(), 0, null, false);
            this.availableItems.add(availItem);
        }
        availItem.increment();
        toRemove.decrement();
        if (toRemove.getQuantity() == 0) {
            this.addedItems.remove(toRemove);
        }
        if (toRemove.isAlreadyRedeemed()) {
            RedeemingItem removal = this.getEquivalentItem(this.removedRedemptions, toRemove, toRemove.getCustomer());
            if (removal == null) {
                removal = new RedeemingItem(toRemove.getItem(), 0, toRemove.getCustomer(), true);
                this.removedRedemptions.add(removal);
            }
            removal.increment();
        }
        this.updateGui();
    }

    private int getPointsUsed() {
        int used = 0;
        for (RedeemingItem nextItem : this.addedItems) {
            if (!nextItem.getItem().hasLoyaltyPointsAvailable() || !this.customer.equals((Object)nextItem.getCustomer())) continue;
            used += nextItem.getCost();
        }
        return used;
    }

    private int getPointsLeft() {
        int pointsUsed = this.getPointsUsed();
        int remaining = this.virtualPoints - pointsUsed;
        return remaining;
    }

    private void resetCurrentInfo() {
        this.addedItems.clear();
        this.availableItems.clear();
        this.removedRedemptions.clear();
        this.account = null;
    }

    void gotOK() {
        HashSet<Customer> toSave = new HashSet<Customer>();
        for (RedeemingItem nextItem : this.removedRedemptions) {
            if (toSave.contains(nextItem.getCustomer())) continue;
            toSave.add(nextItem.getCustomer());
        }
        for (RedeemingItem nextItem : this.addedItems) {
            if (nextItem.isAlreadyRedeemed() || toSave.contains(nextItem.getCustomer())) continue;
            toSave.add(nextItem.getCustomer());
        }
        toSave.remove(this.account.getCustomer());
        EventContext context = LoginManager.getEventContext();
        this.unapplyLoyaltyPointTransactionsFromRemovedItems(context);
        this.applyLoyaltyPointTransactionsForRedeemedItems(context);
        for (Customer nextCustomer : toSave) {
            LoyaltyPointAdministrator.getInstance().updatePointsForCustomer(nextCustomer);
            nextCustomer.save();
        }
        this.resetCurrentInfo();
        this.account = null;
        this.customer = null;
        this.nav.back.emit();
    }

    private void unapplyLoyaltyPointTransactionsFromRemovedItems(EventContext context) {
        HashSet<SalesLineItem> toRemove = new HashSet<SalesLineItem>();
        for (RedeemingItem nextItem : this.removedRedemptions) {
            toRemove.add(nextItem.getItem());
        }
        if (toRemove.size() > 0) {
            LoyaltyPointAdministrator.getInstance().unapplyLoyaltyPointRedemptionDiscounts(toRemove, context);
        }
        for (RedeemingItem nextItem : this.removedRedemptions) {
            SalesLineItem removeItem = nextItem.getItem();
            int difference = removeItem.getQuantity().getValue().intValue() - nextItem.getQuantity();
            this.addedItems.remove(this.getEquivalentItem(this.addedItems, nextItem, nextItem.getCustomer()));
            if (difference == 0) continue;
            this.addedItems.add(new RedeemingItem(removeItem.split(SalesQuantity.valueOf((long)difference), context), difference, nextItem.getCustomer(), false));
        }
    }

    private void applyLoyaltyPointTransactionsForRedeemedItems(final EventContext context) {
        ProgressDialog.doProgressDialog((Task)new AbstractTask(){

            protected int getTotalSubTasks() {
                return LoyaltyRedemptionScreen.this.addedItems.size();
            }

            public String getName() {
                return "Redeeming Loyalty Points";
            }

            protected void performTask() throws Exception {
                for (RedeemingItem nextItem : LoyaltyRedemptionScreen.this.addedItems) {
                    if (!nextItem.isAlreadyRedeemed() && nextItem.getQuantity() > 0) {
                        SalesLineItem toRedeem = nextItem.getItem();
                        int difference = toRedeem.getQuantity().getValue().intValue() - nextItem.getQuantity();
                        if (difference > 0) {
                            toRedeem = toRedeem.split(SalesQuantity.valueOf((long)nextItem.getQuantity()), context);
                        }
                        toRedeem.setCustomer(nextItem.getCustomer());
                        if (!LoyaltyPointAdministrator.getInstance().redeemLoyaltyPoints(toRedeem, nextItem.getCustomer(), context)) break;
                    }
                    this.emitProgress();
                }
            }
        });
    }

    public void gotCancel() {
        this.resetCurrentInfo();
        this.account = null;
        this.customer = null;
    }

    public void show() {
        this.updateGui();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotCustomerChanged(Customer newCustomer) {
        if (this.isDisplaying() && newCustomer != null && !this.customer.equals((Object)newCustomer)) {
            if (SystemProperty.getInstance().isLoyaltyEnabled()) {
                ProgressDialog.doProgressDialog((Task)new LoyaltyResyncTask((GuiHandler)new WaitermateGuiHandler(), newCustomer));
            }
            this.customer = newCustomer;
            this.updateGui();
        }
    }

    private RedeemingItem getEquivalentItem(Collection<RedeemingItem> items, RedeemingItem item, Customer matchCustomer) {
        for (RedeemingItem nextItem : items) {
            if (!nextItem.getItem().equals((Object)item.getItem()) || matchCustomer != null && !matchCustomer.equals((Object)nextItem.getCustomer())) continue;
            return nextItem;
        }
        return null;
    }
}

