/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.loyaltytransaction;

import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesLineItem;

class RedeemingItem {
    private final SalesLineItem item;
    private int quantity;
    private Customer customer;
    private final boolean alreadyRedeemed;

    public RedeemingItem(SalesLineItem yourItem, int yourQuantity, Customer yourCustomer, boolean redeemed) {
        this.item = yourItem;
        this.quantity = yourQuantity;
        this.customer = yourCustomer;
        this.alreadyRedeemed = redeemed;
    }

    int getQuantity() {
        return this.quantity;
    }

    void increment() {
        ++this.quantity;
    }

    void decrement() {
        --this.quantity;
    }

    void setQuantity(int value) {
        this.quantity = value;
    }

    SalesLineItem getItem() {
        return this.item;
    }

    Customer getCustomer() {
        return this.customer;
    }

    void setCustomer(Customer value) {
        this.customer = value;
    }

    boolean isAlreadyRedeemed() {
        return this.alreadyRedeemed;
    }

    public int getCost() {
        int adjItemQty = this.item.getQuantity().getValue().intValue() > 0 ? this.item.getQuantity().getValue().intValue() : 1;
        return (int)Math.ceil(this.item.getLoyaltyPointsCost() / adjItemQty * this.quantity);
    }
}

