/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.mototransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.TransactionSummary;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class MOTOTransactionPanel
extends JPanel
implements ActionListener {
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH;
    private static int COMPONENT_START;
    private static int COMPONENT_WIDTH;
    private JLabel due;
    private JLabel subTotal;
    private JLabel balance;
    private JLabel surchargeLabel;
    private JButton paid;
    private JButton tip;
    private JButton surchargeCheck;
    private StandardSecurityDecorator surchargeToggle;
    private JPanel textPanel;
    public final Signal paidSelected = Signals.createSignal();
    public final Signal tipSelected = Signals.createSignal();
    public final Signal cashSelected = Signals.createSignal();
    private DefaultScrollPaneModel subTypes;
    public final Signal typeChanged = Signals.createSignal();
    private List buttons;

    public MOTOTransactionPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.setupComponents();
    }

    private void setupComponents() {
        this.textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 7), 0, 0));
        this.add((Component)this.textPanel, new Rectangle(5, 0, 10, 20));
        this.setupPaymentPanels();
        this.setupBalancePanel();
    }

    private void setupPaymentPanels() {
        JLabel dueLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DUE") + "</h2></html>");
        this.textPanel.add((Component)dueLabel, new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.due = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.due.setName("dueLabel");
        this.textPanel.add((Component)this.due, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        JPanel group1 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 4), 5, 5));
        group1.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SUBTOTAL")));
        this.textPanel.add((Component)group1, new Rectangle(0, 1, 10, 3));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"PAID")), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.paid = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.paid.setName("paid");
        this.paid.addActionListener(this);
        group1.add((Component)this.paid, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"TIP")), new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        this.tip = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.tip.setName("tipButton");
        this.tip.addActionListener(this);
        group1.add((Component)new StandardSecurityDecorator((JComponent)this.tip, AllPermissions.TIPS), new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
        this.surchargeLabel = new JLabel(Internationalization.getLiteralFor((String)"SURCHARGE"));
        group1.add((Component)this.surchargeLabel, new Rectangle(LABEL_START, 2, LABEL_WIDTH, 1));
        this.surchargeLabel.setName("debitSurchargeLabel");
        this.surchargeCheck = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.surchargeCheck.setName("debitSurchargeCheck");
        this.surchargeCheck.addActionListener(this);
        this.surchargeCheck.setSelected(true);
        this.surchargeToggle = new StandardSecurityDecorator((JComponent)this.surchargeCheck, AllPermissions.REMOVE_PAYMENT_SURCHARGE);
        this.surchargeCheck.setVisible(true);
        this.surchargeToggle.setVisible(true);
        this.surchargeToggle.setSecurityVisible(true);
        group1.add((Component)this.surchargeToggle, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, 1));
        group1.add((Component)new JLabel("       " + Internationalization.getLiteralFor((String)"SUB_TOTAL")), new Rectangle(LABEL_START, 3, LABEL_WIDTH, 1));
        this.subTotal = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.subTotal.setName("subTotalLabel");
        group1.add((Component)this.subTotal, new Rectangle(COMPONENT_START, 3, COMPONENT_WIDTH, 1));
        this.subTypes = new DefaultScrollPaneModel(1, 7);
        CustomScrollPane pane = new CustomScrollPane((CustomScrollPaneModel)this.subTypes);
        this.add((Component)pane, new Rectangle(0, 0, 5, 20));
    }

    private void setupBalancePanel() {
        JLabel balanceLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"BALANCE") + "</h2></html>");
        this.textPanel.add((Component)balanceLabel, new Rectangle(LABEL_START, 5, LABEL_WIDTH, 1));
        this.balance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.balance.setName("balanceLabel");
        this.textPanel.add((Component)this.balance, new Rectangle(COMPONENT_START, 5, COMPONENT_WIDTH, 1));
    }

    public void setDetails(TransactionSummary summary) {
        this.due.setText("<html><h2>" + summary.getDue() + "</h2></html>");
        this.paid.setText(summary.getPaid().toString());
        this.tip.setText(summary.getTip().toString());
        this.subTotal.setText(summary.getTotal().toString());
        Price balancePrice = new Price(summary.getDue().doubleValue() - summary.getPaid().doubleValue(), 0.01);
        this.surchargeToggle.setSecurityVisible(true);
        this.surchargeToggle.setVisible(true);
        this.surchargeCheck.setText(summary.getSurcharge().toString(true));
        if (balancePrice.doubleValue() >= 0.0) {
            this.balance.setText("<html><h2>" + balancePrice + "</h2></html>");
        } else {
            this.balance.setText("<html><h2><font color=\"red\">" + balancePrice + "</font></h2></html>");
        }
    }

    public void setPaidEnabled(boolean enabled) {
        this.paid.setEnabled(enabled);
    }

    void enableAutoSurcharge(boolean surchargeAuto) {
        if (this.surchargeLabel != null) {
            this.surchargeLabel.setEnabled(!surchargeAuto);
            this.surchargeCheck.setEnabled(!surchargeAuto && !AdyenIntegrationConfig.getInstance().isConfigured());
            this.surchargeToggle.setEnabled(!surchargeAuto && !AdyenIntegrationConfig.getInstance().isConfigured());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.paid) {
            this.paidSelected.emit();
        } else if (e.getSource() == this.tip) {
            this.tipSelected.emit();
        } else {
            this.typeChanged.emit();
        }
    }

    public boolean isSurchargeSelected() {
        if (this.surchargeCheck != null) {
            return this.surchargeCheck.isSelected();
        }
        return true;
    }

    public void setSurchargeLabel(String string) {
        if (this.surchargeLabel != null) {
            this.surchargeLabel.setText(string);
        }
    }

    public void setSurchargeSelected(boolean selected) {
        if (this.surchargeCheck != null) {
            this.surchargeCheck.setSelected(selected);
        }
    }

    public void setButtonsEnabled(boolean enabled) {
        if (this.paid != null) {
            this.paid.setEnabled(enabled);
            this.tip.setEnabled(enabled);
            this.surchargeCheck.setEnabled(enabled && AdyenIntegrationConfig.getInstance().isConfigured());
        }
    }

    public FinanceUnit getSelectedSubType() {
        Iterator it = this.buttons.iterator();
        CustomToggleButton selectedButton = null;
        while (it.hasNext()) {
            NameDecorator decorator = (NameDecorator)it.next();
            CustomToggleButton button = (CustomToggleButton)decorator.getDecorateComponent();
            if (!button.isSelected()) continue;
            selectedButton = button;
        }
        return selectedButton != null ? (FinanceUnit)selectedButton.getData() : null;
    }

    public void setSubTypes(List subtypes) {
        this.buttons = DataScrollPaneModel.createToggleButtons((Collection)subtypes, (ButtonGroup)new ButtonGroup(), (ActionListener)this);
        this.subTypes.setItems((Collection)this.buttons);
        this.typeChanged.emit();
    }

    static {
        COMPONENT_START = LABEL_WIDTH = 7;
        COMPONENT_WIDTH = 3;
    }
}

