/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.paths;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import ordermate.database.Payable;
import ordermate.database.finance.SplitItemGroup;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.payment.paths.Path;
import waitermate.gui.screens.payment.transactions.AccountPaymentsScreen;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class AutoSplitPath
extends Path {
    public final Signal normalMode = Signals.createSignal();
    private Map<Integer, List<Sellable>> itemsByCustomer;
    private Account toPay;
    boolean restrictSaveToPaid;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();

    public AutoSplitPath() {
        this.transactions = new AccountPaymentsScreen();
        this.transactions.done.connect((Object)this, "splitAccount");
        this.transactions.back.connect((Object)this.back, "emit");
        this.transactions.setAllowDebtorPayments(false);
        this.transactions.setAllowAccountAdjustement(false);
    }

    @Override
    public void start(Account theAccount, boolean newRestrictSaveToPaid) {
        this.toPay = theAccount;
        this.restrictSaveToPaid = newRestrictSaveToPaid;
        this.itemsByCustomer = new LinkedHashMap<Integer, List<Sellable>>();
        for (Sellable item : this.sellableFactory.getUnPaidSellables((ItemGroup)this.toPay)) {
            Integer customer = item.getSeat();
            List<Sellable> itemList = this.itemsByCustomer.get(customer);
            if (itemList == null) {
                itemList = new LinkedList<Sellable>();
                this.itemsByCustomer.put(customer, itemList);
            }
            itemList.add(item);
        }
        this.splitAccount();
    }

    private void splitAccount() {
        if (this.sellableFactory.getUnPaidSellables((ItemGroup)this.toPay).isEmpty() && this.toPay.getPaidState() != Payable.PAID) {
            this.normalMode.emit();
        } else if (this.itemsByCustomer.isEmpty()) {
            this.done.emit();
        } else {
            ArrayList<JToggleButton> buttonList = new ArrayList<JToggleButton>(this.itemsByCustomer.size());
            HashMap<JToggleButton, Integer> buttonCustomerMap = new HashMap<JToggleButton, Integer>();
            for (Integer customer : this.itemsByCustomer.keySet()) {
                JToggleButton custButton = customer.equals(0) ? new JToggleButton("<html><center>" + Internationalization.getLiteralFor((String)"ALL") + "<br>" + Internationalization.getLiteralFor((String)"CUSTOMERS") + "</center></html>") : new JToggleButton("<html><center>" + Internationalization.getLiteralFor((String)"CUSTOMER") + "<br>" + customer + "</center></html>");
                buttonList.add(custButton);
                buttonCustomerMap.put(custButton, customer);
            }
            Collections.sort(buttonList, new CustomerComparator(buttonCustomerMap));
            DefaultScrollPaneModel model = new DefaultScrollPaneModel(4, 2);
            CustomScrollPane scrollPane = new CustomScrollPane((CustomScrollPaneModel)model);
            model.setItems(buttonList);
            PopupWindow popup = new PopupWindow();
            popup.getNavBar().setText("Select seats to pay");
            popup.setCancelButtonVisible(true);
            popup.setComponent((JComponent)scrollPane);
            boolean okSelected = popup.start();
            if (!okSelected) {
                this.back.emit();
            } else {
                ArrayList<Sellable> selectedItems = new ArrayList<Sellable>();
                for (JToggleButton button : buttonList) {
                    if (!button.isSelected()) continue;
                    Integer selectedCustomer = (Integer)buttonCustomerMap.get(button);
                    selectedItems.addAll((Collection<Sellable>)this.itemsByCustomer.get(selectedCustomer));
                    this.itemsByCustomer.remove(selectedCustomer);
                }
                if (selectedItems.isEmpty()) {
                    Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"YOU_MUST_SELECT_AT_LEAST_ONE_CUSTOMER_TO_CONTINUE"), (String)Internationalization.getLiteralFor((String)"NO_ACCOUNTS_SELECTED"));
                    this.splitAccount();
                } else {
                    this.payItems(selectedItems);
                }
            }
        }
    }

    private void payItems(List<Sellable> selectedItems) {
        SplitItemGroup group = new SplitItemGroup(this.toPay, selectedItems);
        this.transactions.startTransactions((Payable)group, this.restrictSaveToPaid, false);
    }

    private static class CustomerComparator
    implements Comparator<JToggleButton> {
        private Map<JToggleButton, Integer> buttonCustomerMap;

        public CustomerComparator(Map<JToggleButton, Integer> buttonCustomer) {
            this.buttonCustomerMap = buttonCustomer;
        }

        @Override
        public int compare(JToggleButton o1, JToggleButton o2) {
            Integer intOne = this.buttonCustomerMap.get(o1);
            Integer intTwo = this.buttonCustomerMap.get(o2);
            return intOne.compareTo(intTwo);
        }
    }
}

