/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.paths;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ordermate.database.Payable;
import ordermate.database.finance.SplitItemGroup;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.transferitems.selectitems.SplitSelectItems;
import waitermate.gui.screens.payment.paths.Path;
import waitermate.gui.screens.payment.paths.PercentageSplitPath;
import waitermate.gui.screens.payment.transactions.AccountPaymentsScreen;

public class SplitPath
extends Path {
    public final Signal normalMode = Signals.createSignal();
    private SplitSelectItems selectTransferItems;
    private int billNumber;
    private boolean restrictSaveToPaid;
    private PercentageSplitPath percentSplitPath;
    private Account toPay;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();

    public SplitPath() {
        this.transactions = new AccountPaymentsScreen();
        this.transactions.done.connect((Object)this, "splitAccount");
        this.transactions.back.connect(this.back);
        this.transactions.percentageSplitBill.connect((Object)this, "doPercentageSplit");
        this.transactions.setAllowDebtorPayments(false);
        this.transactions.setAllowAccountAdjustement(false);
        this.percentSplitPath = new PercentageSplitPath();
        this.percentSplitPath.done.connect((Object)this, "splitAccount");
        this.percentSplitPath.back.connect(this.back);
        this.selectTransferItems = new SplitSelectItems(true, true);
        this.selectTransferItems.items.connect((Object)this, "gotItems");
        this.selectTransferItems.back.connect(this.back);
        this.selectTransferItems.itemsSplit.connect((Object)this, "gotItemsSplit");
    }

    @Override
    public void start(Account newToPay, boolean newRestrictSaveToPaid) {
        this.restrictSaveToPaid = newRestrictSaveToPaid;
        this.toPay = newToPay;
        this.billNumber = 1;
        this.splitAccount();
    }

    void gotItemsSplit(Account forAccount) {
        forAccount.save();
    }

    public void doPercentageSplit() {
        this.percentSplitPath.start(this.transactions.getItemGroup(), this.restrictSaveToPaid);
    }

    private void splitAccount() {
        if (this.sellableFactory.getUnPaidSellables((ItemGroup)this.toPay).isEmpty() && this.toPay.getPaidState() != Payable.PAID) {
            this.normalMode.emit();
        } else if (this.sellableFactory.getUnPaidSellables((ItemGroup)this.toPay).isEmpty()) {
            this.done.emit();
        } else {
            this.selectTransferItems.startSelection((List<Sellable>)this.sellableFactory.getUnPaidSellables((ItemGroup)this.toPay), Internationalization.getLiteralFor((String)"SELECT_ITEMS_FOR_BILL") + " " + this.billNumber);
        }
    }

    void gotItems(Set<Sellable> items) {
        SplitItemGroup filter = new SplitItemGroup(this.toPay, new ArrayList<Sellable>(items));
        this.transactions.startTransactions((Payable)filter, this.restrictSaveToPaid, false);
        ++this.billNumber;
    }
}

