/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.selectadjustment;

import au.com.ordermate.persistence.Displayable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import ordermate.database.finance.priceadjustment.PriceAdjustmentI;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DeletableRenderer;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class SelectPriceAdjustmentPanel
extends JPanel {
    public final Signal selected = Signals.createSignal(PriceAdjustmentI.class, (String)"adjustment");
    public final Signal removed = Signals.createSignal(SalesPriceAdjustmentI.class, (String)"adjustment");
    private final JTabbedPane tabbedPane;
    private final RendererScrollPaneModel dollarModel;
    private final RendererScrollPaneModel percentageModel;
    private final RendererScrollPaneModel existingModel;
    private final CustomScrollPane dollarPane;
    private final CustomScrollPane removePanel;
    private boolean displayDollars;

    public SelectPriceAdjustmentPanel() {
        DisplayableRenderer dollarRenderer = new DisplayableRenderer();
        dollarRenderer.selected.connect((Object)this, "gotSelectAdjustment");
        this.dollarModel = new RendererScrollPaneModel((Renderer)dollarRenderer);
        this.dollarPane = new CustomScrollPane((CustomScrollPaneModel)this.dollarModel);
        DisplayableRenderer percentageRenderer = new DisplayableRenderer();
        percentageRenderer.selected.connect((Object)this, "gotSelectAdjustment");
        this.percentageModel = new RendererScrollPaneModel((Renderer)percentageRenderer);
        CustomScrollPane percentagePane = new CustomScrollPane((CustomScrollPaneModel)this.percentageModel);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(OrderMateTheme.getLargeFont());
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.tabbedPane);
        this.tabbedPane.addTab(Internationalization.getLiteralFor((String)"PERCENTAGE"), (Component)percentagePane);
        this.tabbedPane.addTab(Internationalization.getLiteralFor((String)"DOLLAR_AMOUNT"), (Component)this.dollarPane);
        DeletableRenderer deletableRenderer = new DeletableRenderer();
        deletableRenderer.selected.connect((Object)this, "gotRemoveAdjustment");
        this.existingModel = new RendererScrollPaneModel((Renderer)deletableRenderer);
        this.removePanel = new CustomScrollPane((CustomScrollPaneModel)this.existingModel);
        this.removePanel.setName("RemoveAdjustmentPanel");
        this.removePanel.setColumns(4);
        this.removePanel.setRowsPerPage(1);
        this.removePanel.setBorder((Border)BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"EXISTING_ADJUSTMENTS__PRESS_TO_REMOVE")));
        this.displayDollars = true;
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.removePanel, "Last");
    }

    public void displayAdjustmentsOnTabs(Collection<TriggeredPriceAdjustment> adjustments, boolean shouldDisplayDollars, Collection existingAdjustments) {
        this.setupTabs(shouldDisplayDollars);
        List dollars = PriceAdjustmentManager.getInstance().getMatching(adjustments, PriceAdjustmentUnit.DOLLAR_UNIT);
        List percentages = PriceAdjustmentManager.getInstance().getMatching(adjustments, PriceAdjustmentUnit.PERCENTAGE_UNIT);
        this.dollarModel.removeAllObjects();
        this.dollarModel.addObjects((Collection)dollars);
        this.percentageModel.removeAllObjects();
        this.percentageModel.addObjects((Collection)percentages);
        this.existingModel.removeAllObjects();
        this.existingModel.addObjects(existingAdjustments);
        this.removePanel.setVisible(!existingAdjustments.isEmpty());
    }

    private void setupTabs(boolean shouldDisplayDollars) {
        if (this.displayDollars == shouldDisplayDollars) {
            return;
        }
        if (shouldDisplayDollars) {
            this.tabbedPane.addTab(Internationalization.getLiteralFor((String)"DOLLAR_AMOUNT"), (Component)this.dollarPane);
        } else {
            this.tabbedPane.removeTabAt(1);
        }
        this.displayDollars = shouldDisplayDollars;
    }

    public boolean isDollarDisplayed() {
        return this.tabbedPane.getSelectedIndex() == 1;
    }

    public boolean isPercentageDisplayed() {
        return this.tabbedPane.getSelectedIndex() == 0;
    }

    public void gotSelectAdjustment(Displayable adjustment) {
        this.selected.emit((Object)adjustment);
    }

    public void gotRemoveAdjustment(Displayable adjustment) {
        this.removed.emit((Object)adjustment);
    }
}

