/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.Payable;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.SplitItemGroup;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerUpdateManager;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.SaveAccount;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import ordermate.internationalization.Internationalization;
import ordermate.services.hardware.physical.eftpos.CashDrawerManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.dialogs.AutoComboSelector;
import waitermate.gui.screens.debtor.SelectDebtorPayment;
import waitermate.gui.screens.debtor.components.DebtorPaymentProcessor;
import waitermate.gui.screens.discount.DiscountGuiUtils;
import waitermate.gui.screens.ordering.accountadmin.discountitems.AdjustmentItems;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.debtorTransaction.DebtorTransaction;
import waitermate.gui.screens.payment.debtorTransaction.PiggyDebtorTransaction;
import waitermate.gui.screens.payment.loyaltytransaction.LoyaltyRedemptionScreen;
import waitermate.gui.screens.payment.selectadjustment.DiscountReasonPopup;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustment;
import waitermate.gui.screens.payment.tabtransaction.TabTransactionScreen;
import waitermate.gui.screens.payment.transactions.AbstractPaymentsScreen;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.payment.transactions.DebtorSaleHandler;
import waitermate.gui.screens.payment.transactions.LoyaltyRefundWarningHelper;
import waitermate.gui.screens.payment.transactions.PaymentsNav;
import waitermate.gui.screens.payment.transactions.PaymentsPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.SignalEmittingTimer;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.showitem.ShowItemsUtils;

public class AccountPaymentsScreen
extends AbstractPaymentsScreen {
    public final Signal done = Signals.createSignal();
    public final Signal splitBill = Signals.createSignal();
    public final Signal autoSplitBill = Signals.createSignal();
    private final Signal debtorScreenCancelled = DebtorTransaction.createCancelledSignal();
    private final Signal debtorSelected = DebtorTransaction.createDebtorSelectedSignal();
    private final Signal debtorPaymentCancelled = Signals.createSignal();
    private final Signal<List, AbstractDebtor, ?, ?, ?> debtorPaymentSelected = Signals.createSignal(List.class, (String)"transaction", AbstractDebtor.class, (String)"debtor");
    public final Signal percentageSplitBill = Signals.createSignal();
    private LoyaltyRedemptionScreen loyaltyScreen;
    private SelectPriceAdjustment adjustmentScreen;
    private AdjustmentItems itemAdjustmentScreen;
    private SelectDebtorPayment debtorPayment;
    private TabTransactionScreen tabSelectionScreen;
    private final Signal autoComboDone = Signals.createSignal();
    private final DebtorPaymentProcessor debtorPaymentProcessor = new DebtorPaymentProcessor();
    private SignalEmittingTimer saveTimer;
    private boolean canSplitBill;
    private boolean shouldShowCategory = true;
    private DebtorTransactionManager debtorTransactionManager;

    public AccountPaymentsScreen() {
        super(new PaymentsPanel(), new PaymentsNav());
        PaymentsNav navPanel = (PaymentsNav)this.getNavBar();
        navPanel.splitBill.connect(this.splitBill);
        navPanel.autoSplitBill.connect(this.autoSplitBill);
        navPanel.percentageSplitBill.connect(this.percentageSplitBill);
        navPanel.createCombo.connect((Object)this, "gotMakeCombo");
        navPanel.breakCombo.connect((Object)this, "gotBreakCombo");
        this.adjustmentScreen = new SelectPriceAdjustment(true);
        this.itemAdjustmentScreen = new AdjustmentItems();
        this.loyaltyScreen = new LoyaltyRedemptionScreen();
        if (Terminal.getLocalHost().hasBarTabsMode()) {
            this.tabSelectionScreen = new TabTransactionScreen();
            this.tabSelectionScreen.cancel.connect((Object)this, "display");
            this.tabSelectionScreen.tabSelectedSignal.connect((Object)this, "gotTabSelected");
        }
        PaymentsPanel gui = this.getTransactionPanel();
        gui.newDebtorTransaction.connect((Object)this, "gotDebtorStart");
        gui.newDebtorRoomTransaction.connect((Object)this, "gotRoom");
        this.debtorScreenCancelled.connect((Object)this, "display");
        this.debtorSelected.connect((Object)this, "gotDebtorComplete");
        this.debtorPayment = new SelectDebtorPayment();
        this.debtorPaymentCancelled.connect((Object)this, "display");
        this.debtorPaymentSelected.connect((Object)this, "gotDebtorPaymentSelected");
        gui.newApplyPreviousTransaction.connect((Object)this, "gotApplyPreviousTransaction");
        gui.accountDiscount.connect((Object)this, "gotAccountDiscountSelected");
        gui.itemDiscount.connect((Object)this, "gotItemDiscountSelected");
        gui.surcharge.connect((Object)this, "gotSurchargeSelected");
        this.adjustmentScreen.back.connect((Object)this, "display");
        this.adjustmentScreen.addAdjustment.connect((Object)this, "gotAddAdjustment");
        this.adjustmentScreen.removeAdjustment.connect((Object)this, "gotRemoveAdjustment");
        this.itemAdjustmentScreen.done.connect((Object)this, "gotItemAdjustment");
        this.itemAdjustmentScreen.removeItemAdjustment.connect((Object)this, "gotRemoveAdjustment");
        this.itemAdjustmentScreen.cancel.connect((Object)this, "display");
        gui.newLoyaltyTransaction.connect((Object)this, "gotLoyalty");
        this.loyaltyScreen.getNavBar().cancel.connect((Object)this, "display");
        this.loyaltyScreen.getNavBar().back.connect((Object)this, "display");
        gui.newBarTabTransaction.connect((Object)this, "gotTab");
        CustomerUpdateManager.getInstance().customerUpdated.connect((Object)this, "gotUpdateCustomer");
        WaiterMateInputAdapter.getInstance().customerInput.connect((Object)this, "gotCustomer");
        this.shouldShowCategory = CustomerCategory.getAllCategories().size() > 1;
    }

    @Override
    public void startTransactions(Payable toPay, boolean restrictSaveToPaid, boolean allowSplitBill) {
        this.canSplitBill = allowSplitBill;
        super.startTransactions(toPay, allowSplitBill, restrictSaveToPaid);
    }

    @Override
    protected void setupPaymentMethodButtons() {
        SystemProperty property = SystemProperty.getInstance();
        ItemGroup currentAccount = this.getItemGroup();
        if (currentAccount.isOpen() && property.isLoyaltyEnabled() && currentAccount.hasCustomer() && currentAccount.getCustomer().getCategory() != null && currentAccount.getCustomer().getCategory().isLoyaltyPointsEnabled()) {
            this.getTransactionPanel().setLoyaltyButtonEnabled(LoyaltyPointAdministrator.getInstance().isLoyaltyPossible(currentAccount, currentAccount.getCustomer().getLoyaltyPoints()));
        } else {
            this.getTransactionPanel().setLoyaltyButtonEnabled(false);
        }
        if (!property.getPropertyIntegration().equals((Object)PropertyIntegrationType.NONE)) {
            if (currentAccount instanceof SplitItemGroup) {
                this.getTransactionPanel().setRoomButtonEnabled(false);
            } else {
                this.getTransactionPanel().setRoomButtonEnabled(this.getItemGroup().getDue().getNumCents() > 0);
            }
        }
        if (this.getItemGroup().getFinanceTransactions().size() == 0) {
            this.getTransactionPanel().setTabEnabled(true);
        } else {
            this.getTransactionPanel().setTabEnabled(false);
        }
        this.getTransactionPanel().setVisibleItemDiscountButton(this.getItemGroup().isOpen());
        super.setupPaymentMethodButtons();
        this.getTransactionPanel().setDebtorsEnabled(this.allowDebtor());
        this.getTransactionPanel().setVoucherButtonEnabled(this.allowVoucherPayment());
        this.getTransactionPanel().setVisiblePreauth(this.allowPreauth());
    }

    protected boolean allowDebtor() {
        return this.getItemGroup().isOpen() && this.canSplitBill;
    }

    protected boolean allowVoucherPayment() {
        Payable payable = this.getPayable();
        if (payable instanceof ItemGroup) {
            Account account = ((ItemGroup)payable).getAccount();
            for (GiftVoucherTransaction txn : account.getVoucherTxns()) {
                if (!txn.isActive() || !txn.isTopup()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean allowPreauth() {
        User user = LoginManager.getInstance().getUser();
        if (user == null) {
            return false;
        }
        if (Terminal.getLocalHost().isBartabPreauth()) {
            Account account = null;
            if (this.getPayable() instanceof ItemGroup) {
                account = ((ItemGroup)this.getPayable()).getAccount();
            } else {
                OrderMate.LOG.warn("Cannot do pre-auth on " + this.getPayable().getClass());
            }
            if (account == null) {
                return false;
            }
            PreauthTransaction txn = (PreauthTransaction)PersistenceManager.getObject(PreauthTransaction.class, (String)PreauthTransaction.getExisting((Account)account).toString());
            if (txn != null) {
                return user.hasPermission(AllPermissions.PAY);
            }
            if (account instanceof BarTabAccount) {
                return user.hasPermission(AllPermissions.PREAUTH_BARTAB);
            }
        }
        return false;
    }

    @Override
    protected void doDone() {
        boolean proceed = true;
        LoyaltyRefundWarningHelper helper = new LoyaltyRefundWarningHelper(this.getItemGroup());
        if (helper.isLoyaltyRefundWarningRequired()) {
            proceed = Dialogs.displayDialog((JComponent)helper.createLoyaltyRefundWarningPanel(), (String)"Warning", (boolean)true, (boolean)false, (boolean)true);
        }
        if (proceed) {
            if (this.debtorTransactionManager != null) {
                this.debtorTransactionManager.commitChanges(LoginManager.getEventContext());
                this.debtorTransactionManager = null;
            }
            this.done.emit();
        }
    }

    @Override
    protected void doBack() {
        if (this.debtorTransactionManager != null) {
            this.debtorTransactionManager.cancelChanges();
            this.debtorTransactionManager = null;
        }
        super.doBack();
    }

    @Override
    protected void doShowDetails() {
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItems(this.getItemGroup());
    }

    @Override
    protected void doDelete(FinanceTransaction toDelete) {
        this.postDelete(toDelete);
    }

    private void postDelete(FinanceTransaction toDelete) {
        this.getItemGroup().removeFinanceTransaction(toDelete);
        toDelete.getPayoffGroup().removeFinanceTransaction(toDelete);
        if (toDelete.needsOpenCashdrawer()) {
            CashDrawerManager.getInstance().openAllCashDrawersPayment(LoginManager.getInstance().getUser(), toDelete, Terminal.getLocalHost());
        }
    }

    @Override
    protected void doPrint() {
        if (this.debtorTransactionManager != null) {
            this.debtorTransactionManager.commitChanges(LoginManager.getEventContext());
            this.debtorTransactionManager = null;
        }
        WaitermateSaveAccount.getInstance().printReceiptDockets(this.getItemGroup());
    }

    void gotDebtorStart() {
        DebtorTransaction.getInstance().start(CustomerDebtor.class, this.debtorScreenCancelled, this.debtorSelected, this.getItemGroup().getCustomer(), (Account)this.getPayable(), "");
    }

    void gotDebtorComplete(AbstractDebtor debtor) {
        Account account = this.getItemGroup().getAccount();
        if (this.debtorPaymentProcessor.payToDebtor(account, debtor, this.getDebtorTransactionManager())) {
            new DebtorSaleHandler().salePerformed(debtor, account);
            WaitermateSaveAccount.getInstance().printClosingReceipts(account);
            WaitermateSaveAccount.getInstance().printPrep(account);
            this.done.emit();
            return;
        }
        this.display();
    }

    void gotTabSelected(BarTabAccount tab) {
        boolean enoughCredit;
        ItemGroup group = this.getItemGroup();
        Account account = group.getAccount();
        List items = group.getItemHelper().getUnpaidItems();
        boolean bl = enoughCredit = !tab.exceedsCreditLimit(group.getDue()) || CreditLimitPanel.doCreditLimitDialog((CreditLimited)tab, group.getDue(), tab.getLabel(), true);
        if (enoughCredit && WaitermateSaveAccount.getInstance().addInfo(account)) {
            WaitermateSaveAccount.getInstance().saveAndTransferToBarTabAccount(tab, account, items, LoginManager.getEventContext(), true);
            tab.unlock();
            this.done.emit();
        } else {
            tab.unlock();
        }
    }

    void gotRoom() {
        if (PiggyConfig.getConfig().isEnabled()) {
            PiggyDebtorTransaction piggyDebtorTransaction = new PiggyDebtorTransaction();
            piggyDebtorTransaction.setDebtorPaymentProcessor(this.debtorPaymentProcessor);
            piggyDebtorTransaction.setDebtorTransactionManager(this.getDebtorTransactionManager());
            ItemGroup itemGroup = (ItemGroup)this.getPayable();
            piggyDebtorTransaction.setItemGroup(itemGroup);
            piggyDebtorTransaction.setCancelSignal(this.debtorScreenCancelled);
            piggyDebtorTransaction.setDoneSignal(this.done);
            piggyDebtorTransaction.init();
            piggyDebtorTransaction.display();
        } else {
            DebtorTransaction.getInstance().start(RoomAccount.class, this.debtorScreenCancelled, this.debtorSelected, null, null, "");
        }
    }

    void gotTab() {
        this.tabSelectionScreen.start();
    }

    void gotLoyalty() {
        this.loyaltyScreen.startRedeemingItems(this.getItemGroup());
    }

    void gotApplyPreviousTransaction() {
        this.debtorPayment.start(this.debtorPaymentCancelled, this.debtorPaymentSelected, this.getItemGroup().getCustomer(), this.getDebtorTransactionManager());
    }

    void gotCustomer(Customer incoming) {
        if (this.isDisplaying()) {
            if (SystemProperty.getInstance().isLoyaltyEnabled()) {
                ProgressDialog.doProgressDialog((Task)new LoyaltyResyncTask((GuiHandler)new WaitermateGuiHandler(), incoming));
            }
            this.getItemGroup().setCustomer(incoming, LoginManager.getEventContext());
            this.setNavBarText();
            this.updateTotals();
            this.setupPaymentMethodButtons();
            CustomerUpdateManager.getInstance().addCustomerToUpdate(incoming);
        }
    }

    public void gotUpdateCustomer(Customer cust) {
        if (this.isDisplaying() && this.getItemGroup() != null && this.getItemGroup().getCustomer() != null && this.getItemGroup().getCustomer().equals((Object)cust)) {
            this.setNavBarText();
            this.updateTotals();
            this.setupPaymentMethodButtons();
        }
    }

    @Override
    protected void setNavBarText() {
        ItemGroup currentAccount = this.getItemGroup();
        if (currentAccount.hasCustomer()) {
            Customer customer = currentAccount.getCustomer();
            String text = "<html>Customer: <br>" + customer.getName();
            if (SystemProperty.getInstance().isLoyaltyEnabled() && customer.getCategory() != null && customer.getCategory().isLoyaltyPointsEnabled()) {
                text = text + " (" + customer.getLoyaltyPoints() + ")";
            }
            if (this.shouldShowCategory && customer.getCategory() != null) {
                text = text + "<br>" + customer.getCategory().getLabel();
            }
            if (customer.hasPriceAdjustment()) {
                text = text + "<br>(" + customer.getPriceAdjustment().getLabel() + " " + customer.getPriceAdjustment().getType() + ")";
            }
            text = text + "</html>";
            this.getNavBar().setText(text);
        } else {
            this.getNavBar().setText("");
        }
    }

    void gotAccountDiscountSelected() {
        this.adjustmentScreen.allowDollarValue(this.getItemGroup().allowsAdvancedPriceAdjustments());
        this.adjustmentScreen.start(this.getItemGroup().getPriceAdjHelper().getDiscounts(), null, PriceAdjustmentDirection.DISCOUNT, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ACCOUNT_LEVEL, this.getTriggerActivationContext());
    }

    void gotItemDiscountSelected() {
        this.itemAdjustmentScreen.startDiscountAccount(this.getItemGroup());
    }

    void gotItemAdjustment() {
        this.updateTotals();
        this.display();
    }

    void gotSurchargeSelected() {
        this.adjustmentScreen.allowDollarValue(this.getItemGroup().allowsAdvancedPriceAdjustments());
        List surcharges = this.getItemGroup().getPriceAdjHelper().getSurcharges();
        Iterator it = surcharges.iterator();
        while (it.hasNext()) {
            SalesPriceAdjustment salesPriceAdjustment = (SalesPriceAdjustment)it.next();
            if (!PriceAdjustmentType.FINAL.equals((Object)salesPriceAdjustment.getType()) && !PriceAdjustmentType.FINAL_PAYMENT.equals((Object)salesPriceAdjustment.getType())) continue;
            it.remove();
        }
        this.adjustmentScreen.start(surcharges, null, PriceAdjustmentDirection.SURCHARGE, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ACCOUNT_LEVEL, this.getTriggerActivationContext());
    }

    void gotAddAdjustment(InventoryPriceAdjustment adjustment) {
        String reason = null;
        if (adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && adjustment.getType().equals((Object)PriceAdjustmentType.CUSTOM) && Terminal.getLocalHost().isPromptForCustomDiscountReason()) {
            if (DiscountReasonPopup.areReasonsAvailable()) {
                reason = DiscountReasonPopup.promptForReason();
                if (reason == null) {
                    this.display();
                    return;
                }
            } else {
                WaiterMate.LOG.warn("Cannot supply reason code for acount discount as none are available.");
            }
        }
        if (adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && adjustment.getType().equals((Object)PriceAdjustmentType.NORMAL) && adjustment.isOpenPrice()) {
            Account account = this.getItemGroup().getAccount();
            DiscountGuiUtils.getNewPriceForOpenPriceDiscountAccount(adjustment, account);
        } else {
            SalesPriceAdjustment salesAdj = adjustment.createSalesPriceAdjustment((PriceAdjustable)this.getItemGroup().getAccount(), LoginManager.getEventContext());
            salesAdj.setReason(reason, LoginManager.getEventContext());
        }
        this.updateTotals();
        this.display();
    }

    void gotRemoveAdjustment(SalesPriceAdjustmentI adjustment) {
        this.getItemGroup().removePriceAdjustment((SalesPriceAdjustment)adjustment, LoginManager.getEventContext());
        this.updateTotals();
        this.display();
    }

    void gotDebtorInfoCancel() {
        DebtorTransaction.getInstance().start(CustomerDebtor.class, this.debtorScreenCancelled, this.debtorSelected, this.getItemGroup().getCustomer(), (Account)this.getPayable(), "");
    }

    void gotDebtorPaymentSelected(List<DebtorPayment> payments, AbstractDebtor debtor) {
        ArrayList<FinanceTransaction> debtorTransactions;
        try {
            debtorTransactions = this.getDebtorTransactionManager().transferDebtorPaymentsToPayable(payments, debtor, LoginManager.getEventContext());
        }
        catch (Exception e) {
            debtorTransactions = new ArrayList();
            OrderMate.LOG.error("Payable not an instance of account!" + e);
        }
        this.resumeTransactions(debtorTransactions);
    }

    private TriggerActivationContext getTriggerActivationContext() {
        return new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.getItemGroup().getAccount());
    }

    private void updatePriceAdjustments() {
        if (this.getItemGroup().isDiscounted()) {
            this.getTransactionPanel().setAccountDiscountInfo(this.getItemGroup().getPriceAdjHelper().stringifyDiscountSummary());
        } else {
            this.getTransactionPanel().setAccountDiscountInfo(Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "0.00");
        }
        if (this.getItemGroup().getPriceAdjHelper().isAnyItemDiscounted(false)) {
            ItemGroup group = this.getItemGroup();
            this.getTransactionPanel().setItemDiscountInfo(group.getPriceAdjHelper().stringfyItemDiscountsSummary(), LoyaltyPointAdministrator.getInstance().isAtLeastOneLoyaltyRedemption(group));
        } else {
            this.getTransactionPanel().setItemDiscountInfo(Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "0.00", false);
        }
        if (this.getItemGroup().getPriceAdjHelper().isSurcharged()) {
            this.getTransactionPanel().setSurchargeInfo(this.getItemGroup().getPriceAdjHelper().stringifySurchargeSummary());
        } else {
            this.getTransactionPanel().setSurchargeInfo(Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "0.00");
        }
    }

    @Override
    protected void update() {
        this.updateTotals();
        this.getTransactionNavBar().showComboCreator(false, false);
        if (SystemProperty.getInstance().formAutoCombosOnPayment() && this.getItemGroup() instanceof Account && !SystemProperty.getInstance().isCustomerAssignmentPerSeat()) {
            AutoComboSelector autoComboSelector = this.configureAutoComboSelector();
            this.getTransactionNavBar().showComboCreator(autoComboSelector.canMakeCombos(), autoComboSelector.canBreakCombos());
        }
    }

    @Override
    protected void updateTotals() {
        super.updateTotals();
        this.updatePriceAdjustments();
        this.updateSaveTimer();
    }

    public void display() {
        this.resumeTransactions();
        if (this.getItemGroup() instanceof Account) {
            WaitermateAccountGui.getInstance().accountChanged((Account)this.getItemGroup());
        }
        super.display();
        this.updateSaveTimer();
    }

    private void updateSaveTimer() {
        if (this.saveTimer != null) {
            WaiterMate.LOG.info("stopping timer");
            this.saveTimer.stop();
        }
        if (this.getItemGroup().getPaidState().equals(Payable.PAID)) {
            WaiterMate.LOG.info("Creating new timer");
            this.saveTimer = new SignalEmittingTimer(Terminal.getLocalHost().getAutoSavePaidAccDelay(), Terminal.getLocalHost().getAutoSavePaidAccCountDown(), (AbstractScreen)this, this.getTransactionNavBar().save, "The account will be automatically saved ", "Save");
        }
    }

    @Override
    protected void updateNavBar() {
        ItemGroup currentAccount = this.getItemGroup();
        List discounts = PriceAdjustmentManager.getInstance().getMatching((Collection)currentAccount.getPriceAdjHelper().getDiscounts(), PriceAdjustmentUnit.DOLLAR_UNIT);
        List surcharges = PriceAdjustmentManager.getInstance().getMatching((Collection)currentAccount.getPriceAdjHelper().getSurcharges(), PriceAdjustmentUnit.DOLLAR_UNIT);
        boolean hasDollarAdjustment = !discounts.isEmpty() || !surcharges.isEmpty() || currentAccount instanceof PhoneAccount && ((PhoneAccount)currentAccount).isDeliverable();
        SellableWrapperFactory factory = new SellableWrapperFactory();
        boolean splitBillIsPossible = !factory.getUnPaidSellables(currentAccount).isEmpty() && !this.hasNewTransactions() && !hasDollarAdjustment;
        boolean autoSplitBillIsPossible = splitBillIsPossible && currentAccount instanceof TableAccount && Terminal.getLocalHost().getSeatNums();
        boolean percentageSplitBillisPossible = !this.hasNewTransactions() && !hasDollarAdjustment && MathsUtils.approxGreaterThan((double)currentAccount.getDue().doubleValue(), (double)0.0);
        this.getTransactionNavBar().setInfo(splitBillIsPossible, autoSplitBillIsPossible, percentageSplitBillisPossible);
    }

    void gotMakeCombo() {
        if (!(this.getItemGroup() instanceof Account)) {
            return;
        }
        AutoComboSelector autoComboSelector = this.configureAutoComboSelector();
        if (autoComboSelector.startMake()) {
            this.getItemGroup().save();
            this.display();
        }
    }

    void gotBreakCombo() {
        if (!(this.getItemGroup() instanceof Account)) {
            return;
        }
        AutoComboSelector autoComboSelector = this.configureAutoComboSelector();
        if (autoComboSelector.startBreak()) {
            this.getItemGroup().save();
            this.display();
        }
    }

    public ItemGroup getItemGroup() {
        return (ItemGroup)this.getPayable();
    }

    public void setAllowDebtorPayments(boolean allow) {
        this.getTransactionPanel().setDebtorsEnabled(allow);
    }

    @Override
    public void tearDown() {
        if (this.saveTimer != null) {
            this.saveTimer.stop();
            this.hidden.disconnect((Object)this.saveTimer);
        }
        super.tearDown();
    }

    private AutoComboSelector configureAutoComboSelector() {
        AutoComboSelector autoComboSelector = AutoComboSelector.getInstance();
        autoComboSelector.configureSignal(this.autoComboDone);
        autoComboSelector.setContext(this.getItemGroup(), null, LoginManager.getEventContext());
        return autoComboSelector;
    }

    @Override
    protected DebtorTransactionManager getDebtorTransactionManager() {
        if (this.debtorTransactionManager != null && !this.getPayable().equals(this.debtorTransactionManager.getPayable())) {
            if (!this.debtorTransactionManager.isFinalised()) {
                this.debtorTransactionManager.cancelChanges();
            }
            this.debtorTransactionManager = null;
        }
        if (this.debtorTransactionManager == null) {
            this.debtorTransactionManager = new DebtorTransactionManager(this.getPayable(), (GuiHandler)new WaitermateGuiHandler());
        }
        return this.debtorTransactionManager;
    }
}

