/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public class PaymentsNav
extends NavBar {
    public final Signal balanceAccount = Signals.createSignal();
    public final Signal showItems = Signals.createSignal();
    public final Signal splitBill = Signals.createSignal();
    public final Signal autoSplitBill = Signals.createSignal();
    public final Signal percentageSplitBill = Signals.createSignal();
    public final Signal save = Signals.createSignal();
    public final Signal createCombo = Signals.createSignal();
    public final Signal breakCombo = Signals.createSignal();
    public final Signal printEftposDockets = Signals.createSignal();
    private JButton balanceAccountButton;
    private JButton showItemsButton;
    private StandardSecurityDecorator splitBillButton;
    private StandardSecurityDecorator autoSplitBillButton;
    private StandardSecurityDecorator percentSplitBillButton;
    private StandardSecurityDecorator createComboButton;
    private StandardSecurityDecorator breakComboButton;
    private StandardSecurityDecorator saveButtonDecorator;
    private StandardSecurityDecorator printEftposDocketsDecorator;
    private boolean allowSplitBillMode = false;

    public PaymentsNav() {
        this.addLeft(this.getBackButton());
        JButton eftposButton = this.constructButton(IconLoader.get((String)"/waitermate/images/printEftpos.png"), Internationalization.getLiteralFor((String)"PRINT_EFTPOS_DOCKETS"), "printEftpos", this.printEftposDockets);
        this.printEftposDocketsDecorator = new StandardSecurityDecorator((JComponent)eftposButton, AllPermissions.PRINT_BILL);
        this.addRight((Component)this.printEftposDocketsDecorator);
        this.printEftposDocketsDecorator.setVisible(false);
        this.createComboButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/comboMake.png"), Internationalization.getLiteralFor((String)"MAKE_COMBOS"), "Create combos"), AllPermissions.MAKE_COMBOS);
        this.breakComboButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/comboMake.png"), Internationalization.getLiteralFor((String)"BREAK_COMBOS"), "Break combos"), AllPermissions.BREAK_COMBOS);
        this.addRight((Component)this.createComboButton);
        this.addRight((Component)this.breakComboButton);
        this.splitBillButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/splitBill.png"), Internationalization.getLiteralFor((String)"SPLIT_BILL"), "SplitBill"), AllPermissions.SPLIT_BILL);
        this.autoSplitBillButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/splitBillPatrons.png"), Internationalization.getLiteralFor((String)"AUTO_SPLIT_BILL"), "AutoSplitBill"), AllPermissions.SPLIT_BILL);
        this.percentSplitBillButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/splitBillPercent.png"), Internationalization.getLiteralFor((String)"PERCENTAGE_SPLIT_BILL"), "SplitBill"), AllPermissions.SPLIT_BILL);
        if (SystemProperty.getInstance().isSplitBillEnabled()) {
            this.addRight((Component)this.autoSplitBillButton);
            this.addRight((Component)this.percentSplitBillButton);
            this.addRight((Component)this.splitBillButton);
        }
        this.balanceAccountButton = this.constructButton(IconLoader.get((String)"/waitermate/images/money.png"), "Balance Account", "BalanceAccount");
        this.addRight(this.balanceAccountButton);
        this.showItemsButton = this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), Internationalization.getLiteralFor((String)"SHOW_ORDER"), "ShowOrder");
        this.addRight(this.showItemsButton);
        this.addRight(this.getPrintButton());
        JButton saveButton = this.constructButton(IconLoader.get((String)"/waitermate/images/save.png"), Internationalization.getLiteralFor((String)"SAVE"), "saveButton");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentsNav.this.save.emit();
            }
        });
        this.saveButtonDecorator = new StandardSecurityDecorator((JComponent)saveButton, AllPermissions.SAVE);
        this.addRight((Component)this.saveButtonDecorator);
        this.setCenterFont(OrderMateTheme.getSmallFont());
    }

    public void setAllowModeChange(boolean allowIt) {
        this.allowSplitBillMode = allowIt;
        this.splitBillButton.setVisible(allowIt);
        this.autoSplitBillButton.setVisible(allowIt);
        this.percentSplitBillButton.setVisible(allowIt);
    }

    public StandardSecurityDecorator getSaveButton() {
        return this.saveButtonDecorator;
    }

    public StandardSecurityDecorator getCreateComboButton() {
        return this.createComboButton;
    }

    public StandardSecurityDecorator getBreakComboButton() {
        return this.breakComboButton;
    }

    public void setInfo(boolean splitBillIsPossible, boolean autoSplitBillIsPossible, boolean percentSplitPossible) {
        if (this.allowSplitBillMode) {
            this.splitBillButton.setEnabled(splitBillIsPossible);
            this.autoSplitBillButton.setEnabled(autoSplitBillIsPossible);
            this.percentSplitBillButton.setEnabled(percentSplitPossible);
            this.createComboButton.setEnabled(splitBillIsPossible);
            this.breakComboButton.setEnabled(splitBillIsPossible);
        }
    }

    public void showComboCreator(boolean showMake, boolean showBreak) {
        this.createComboButton.setVisible(showMake);
        this.breakComboButton.setVisible(showBreak);
    }

    public void showAutoSplitBill(boolean show) {
        if (this.allowSplitBillMode) {
            this.autoSplitBillButton.setVisible(show);
        }
    }

    public void showBalanceAccounts(boolean show) {
        this.balanceAccountButton.setVisible(show);
    }

    public void showSplit(boolean show) {
        this.splitBillButton.setVisible(show);
        this.autoSplitBillButton.setVisible(show);
        this.percentSplitBillButton.setVisible(show);
    }

    public void showPrintEftpos(boolean value) {
        this.printEftposDocketsDecorator.setVisible(value);
    }

    public JButton getBalanceAccountButton() {
        return this.balanceAccountButton;
    }

    public JButton getShowItemsButton() {
        return this.showItemsButton;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.showItemsButton) {
            this.showItems.emit();
        } else if (e.getSource() == this.balanceAccountButton) {
            this.balanceAccount.emit();
        } else if (this.splitBillButton != null && e.getSource() == this.splitBillButton.getDecorateComponent()) {
            this.splitBill.emit();
        } else if (this.autoSplitBillButton != null && e.getSource() == this.autoSplitBillButton.getDecorateComponent()) {
            this.autoSplitBill.emit();
        } else if (this.percentSplitBillButton != null && e.getSource() == this.percentSplitBillButton.getDecorateComponent()) {
            this.percentageSplitBill.emit();
        } else if (this.createComboButton != null && e.getSource() == this.createComboButton.getDecorateComponent()) {
            this.createCombo.emit();
        } else if (this.breakComboButton != null && e.getSource() == this.breakComboButton.getDecorateComponent()) {
            this.breakCombo.emit();
        } else {
            super.actionPerformed(e);
        }
    }
}

