/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import ordermate.database.Payable;
import ordermate.database.finance.AccountPercentagePayable;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.ItemGroup;
import ordermate.gui.SaveAccount;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.transactions.AbstractPaymentsScreen;
import waitermate.gui.screens.payment.transactions.PaymentsNav;
import waitermate.gui.screens.payment.transactions.PaymentsPanel;
import waitermate.guikit.showitem.ShowItemsUtils;

public class PercentagePaymentScreen
extends AbstractPaymentsScreen {
    public final Signal doneSignal = Signals.createSignal();

    public PercentagePaymentScreen() {
        super(new PaymentsPanel(), new PaymentsNav());
        PaymentsNav nav = this.getTransactionNavBar();
        nav.showSplit(false);
        nav.showComboCreator(false, false);
        nav.setInfo(false, false, false);
    }

    @Override
    protected void setupPaymentMethodButtons() {
        super.setupPaymentMethodButtons();
        PaymentsPanel theGui = this.getTransactionPanel();
        theGui.setVisibleAccountButton(false);
        theGui.setVisibleLoyaltyButton(false);
        theGui.setVisibleRoomButton(false);
        theGui.setVisibleTabButton(false);
        theGui.setAccountAdjustmentsEnabled(false);
        theGui.setItemAdjustmentsEnabled(false);
        theGui.setVisiblePreviousTransactionButton(false);
    }

    @Override
    protected void doDelete(FinanceTransaction toDelete) {
        this.getPayable().removeFinanceTransaction(toDelete);
        this.update();
    }

    @Override
    protected void doDone() {
        this.getPayable().pay();
        this.doneSignal.emit();
    }

    @Override
    protected void doPrint() {
        WaitermateSaveAccount.getInstance().printReceiptDockets(this.getItemGroup());
    }

    @Override
    protected void updateNavBar() {
    }

    @Override
    protected void doShowDetails() {
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItems(this.getItemGroup());
    }

    public ItemGroup getItemGroup() {
        return ((AccountPercentagePayable)this.getPayable()).getItemGroup();
    }

    @Override
    protected void setNavBarText() {
        this.getNavBar().setText(this.getPayable().getLabel());
    }

    @Override
    protected void update() {
        this.updateTotals();
    }

    public void startTransactions(Payable toPay, boolean mustBePaid) {
        super.startTransactions(toPay, false, mustBePaid);
    }
}

