/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.voucher;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class VoucherTransactionPanel
extends JPanel {
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH = 7;
    private static int LABEL_HEIGHT = 1;
    private static int COMPONENT_START = LABEL_WIDTH;
    private static int COMPONENT_WIDTH = 3;
    private static int COMPONENT_HEIGHT = 1;
    private JLabel due;
    private JLabel subTotal;
    private JLabel balance;
    private JLabel voucherBalance;
    private JButton paid;
    public final Signal paidSelected = Signals.createSignal();

    public VoucherTransactionPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        JPanel textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 6), 0, 0));
        this.add((Component)textPanel, new Rectangle(0, 0, 20, 20));
        textPanel.add((Component)new JLabel(HtmlUtils.htmlHeader((String)Internationalization.getLiteralFor((String)"DUE"), (int)2)), new Rectangle(LABEL_START, 0, LABEL_WIDTH, LABEL_HEIGHT));
        this.due = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        textPanel.add((Component)this.due, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        textPanel.add((Component)new JLabel(HtmlUtils.html((String)Internationalization.getLiteralFor((String)"VOUCHER_BALANCE"))), new Rectangle(LABEL_START, 1, LABEL_WIDTH, LABEL_HEIGHT));
        this.voucherBalance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        textPanel.add((Component)this.voucherBalance, new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        JPanel group1 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 5, 5));
        group1.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SUBTOTAL")));
        textPanel.add((Component)group1, new Rectangle(0, 2, 10, 3));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"PAID")), new Rectangle(LABEL_START, 0, LABEL_WIDTH, LABEL_HEIGHT));
        this.paid = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.paid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherTransactionPanel.this.paidSelected.emit();
            }
        });
        group1.add((Component)this.paid, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        this.paid.setName("Paid");
        group1.add((Component)new JLabel("       " + Internationalization.getLiteralFor((String)"SUB_TOTAL")), new Rectangle(LABEL_START, 2, LABEL_WIDTH, LABEL_HEIGHT));
        this.subTotal = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        group1.add((Component)this.subTotal, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        textPanel.add((Component)new JLabel(HtmlUtils.htmlHeader((String)Internationalization.getLiteralFor((String)"ACCOUNT_BALANCE"), (int)2)), new Rectangle(LABEL_START, 5, LABEL_WIDTH, LABEL_HEIGHT));
        this.balance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        textPanel.add((Component)this.balance, new Rectangle(COMPONENT_START, 5, COMPONENT_WIDTH, COMPONENT_HEIGHT));
    }

    public void setDetails(Price dueAmount, Price paidAmount, Price voucherValue) {
        this.due.setText(HtmlUtils.htmlHeader((String)dueAmount.toString(), (int)2));
        this.voucherBalance.setText(voucherValue.toString());
        this.paid.setText(paidAmount.toString());
        this.subTotal.setText(new Price(paidAmount.doubleValue(), 0.01).toString());
        Price balancePrice = new Price(dueAmount.doubleValue() - paidAmount.doubleValue(), 0.01);
        if (balancePrice.doubleValue() >= 0.0) {
            this.balance.setText(HtmlUtils.htmlHeader((String)balancePrice.toString(), (int)2));
        } else {
            this.balance.setText(HtmlUtils.htmlHeader((String)HtmlUtils.boldColor((String)balancePrice.toString(), (String)"red"), (int)2));
        }
    }

    public void setPaidEnabled(boolean enabled) {
        this.paid.setEnabled(enabled);
    }
}

