/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.webtransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.task.BasicTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.onlinepayment.OnlinePaymentRequest;
import ordermate.integration.onlinepayment.OnlinePaymentRequestor;
import ordermate.integration.onlinepayment.OnlinePaymentResponse;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXDatePicker;
import waitermate.LoginManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

class OnlinePaymentProcess {
    private final AtomicReference<OnlinePaymentResponse> onlineResponse = new AtomicReference();
    private Price due;
    private Price amount;
    private String paymentId;
    private String authCode;
    private Date expiryDate;
    private Date issueDate;
    private OnlinePaymentRequest request;
    private OnlinePaymentRequestor requestor;
    private final EventContext context;
    private WebTransaction newTransaction;
    private Account account;
    boolean forceRequirements = false;
    Signal<?, ?, ?, ?, ?> done = Signals.createSignal();

    OnlinePaymentProcess(Price amount, Account theAccount, EventContext context) {
        this.amount = amount;
        this.account = theAccount;
        this.due = this.account.getDue();
        this.context = context;
    }

    void start() {
        this.newTransaction = null;
        if (!this.account.isPersistent()) {
            OrderMate.LOG.error("Cannot currently online pay with an unsaved account");
            Dialogs.displayOkDialog((String)"Please save the account first before requesting an online payment", (String)"Save Account First");
            return;
        }
        try {
            this.requestor = (OnlinePaymentRequestor)SimpleRMI.getObject((InetAddress)Terminal.getServerMateTerminal().getAddress(), (String)"Online Payment Requestor", (int)11100);
            if (this.requestor == null) {
                OrderMate.LOG.error("No Payment Requestor");
                Dialogs.displayOkDialog((String)"Cannot contact Online Payment Processor, please see logs", (String)"No Payment Processor");
                return;
            }
            this.request = this.getRequest();
            if (this.request != null && this.confirmPaymentAmount()) {
                this.fillRequirements();
                this.startOnlineRequest(this.requestor);
            }
        }
        catch (Exception ex) {
            Dialogs.displayOkDialog((String)"Error with Online Payment Processor, please see logs", (String)"Payment Processor Error");
            OrderMate.LOG.error("Cannot contact payment requestor:", (Throwable)ex);
        }
    }

    private OnlinePaymentRequest getRequest() throws RemoteException {
        List requests = this.requestor.getPaymentRequests();
        if (requests == null || requests.isEmpty()) {
            Dialogs.displayOkDialog((String)"There are no configured online payments. Please contact OrderMate", (String)"No Online Payments");
            return null;
        }
        if (requests.size() == 1) {
            return (OnlinePaymentRequest)requests.get(0);
        }
        for (OnlinePaymentRequest req : requests) {
            this.resolveIcon(req);
        }
        return (OnlinePaymentRequest)Dialogs.displaySelectionDialog((String)"Select the online payment provider", (List)requests);
    }

    private void resolveIcon(OnlinePaymentRequest request) {
    }

    private boolean confirmPaymentAmount() {
        if (this.amount == null) {
            this.amount = this.due;
        }
        boolean good = true;
        do {
            double price;
            if ((price = Dialogs.getPriceDouble((String)("To Pay with " + this.request.getLabel()), (double)this.amount.doubleValue())) == Double.MIN_VALUE) {
                return false;
            }
            this.amount = new Price(price, 0.01);
            if (!this.amount.greaterThan((Object)this.due)) continue;
            Dialogs.displayOkDialog((String)(this.amount + " is greater than due amount, " + this.due), (String)"Cannot over pay");
            good = false;
        } while (!good);
        return true;
    }

    private void fillRequirements() {
        this.paymentId = this.getText(this.request.isPaymentIdRequired(), "Payment / Account ID:");
        this.authCode = this.getText(this.request.isAuthCodeRequired(), "Auth Code:");
        this.expiryDate = this.getDate(this.request.isExpiryDateRequired(), "Expiry Date ");
        this.issueDate = this.getDate(this.request.isIssueDateRequired(), "Issue Date ");
    }

    private String getText(boolean required, final String title) {
        if (required) {
            final AtomicReference ref = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ref.set(Dialogs.getString((String)title, (String)""));
                    }
                });
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot get Text for online payment", (Throwable)ex);
            }
            return (String)ref.get();
        }
        return null;
    }

    private Date getDate(boolean required, String title) {
        String dateText;
        if (required && !StringUtils.isEmpty((String)(dateText = this.getText(required, title)))) {
            try {
                return new SimpleDateFormat("dd-MM-yyyy").parse(dateText);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot parse date: " + dateText, (Throwable)ex);
            }
        }
        return null;
    }

    private void startOnlineRequest(final OnlinePaymentRequestor requestor) {
        this.onlineResponse.set(null);
        OrderMate.LOG.info("Beginning Online Payment request for " + this.amount + " to " + this.request.getLabel() + " appId " + this.request.getAppId() + " linkId " + this.request.getProviderLinkId());
        JDialog onlinePaymentDialog = new JDialog();
        onlinePaymentDialog.setUndecorated(true);
        onlinePaymentDialog.setModal(true);
        onlinePaymentDialog.setAlwaysOnTop(true);
        final EventContext eventContext = LoginManager.getEventContext();
        BasicTask onlineTask = new BasicTask("Requesting Payment...", 1, new Runnable(){

            @Override
            public void run() {
                try {
                    OnlinePaymentProcess.this.request.setAmount(OnlinePaymentProcess.this.amount);
                    OnlinePaymentResponse response = requestor.requestPayment(OnlinePaymentProcess.this.request, eventContext.getTerminal().getID(), OnlinePaymentProcess.this.account.getID(), OnlinePaymentProcess.this.paymentId, OnlinePaymentProcess.this.authCode, OnlinePaymentProcess.this.expiryDate, OnlinePaymentProcess.this.issueDate);
                    if (response != null) {
                        OrderMate.LOG.info("Got Payment Response:" + response.isSuccess());
                        OnlinePaymentProcess.this.onlineResponse.set(response);
                    }
                }
                catch (RemoteException ex) {
                    OrderMate.LOG.error("Problem making Online Payment", (Throwable)ex);
                }
            }
        });
        onlineTask.done.connect((Object)this, "gotFinishedOnlinePayment");
        ProgressDialog pd = ProgressDialog.createProgressDialog((JDialog)onlinePaymentDialog, (Task)onlineTask);
        JPanel buttonHolder = new JPanel(new FlowLayout(1));
        JButton cancelButton = new JButton("Cancel Request");
        buttonHolder.add(cancelButton);
        OrderMateTheme.setupTouchScreenButton((AbstractButton)cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    requestor.requestCancel(OnlinePaymentProcess.this.request);
                }
                catch (RemoteException ex) {
                    OrderMate.LOG.error("Cannot cancel payment request:", (Throwable)ex);
                }
            }
        });
        pd.add((Component)buttonHolder);
        pd.start(false);
        onlinePaymentDialog.setLocationRelativeTo(ScreenResource.getTarget());
        pd.setVisible(true);
    }

    void gotFinishedOnlinePayment() {
        OrderMate.LOG.info("Finished Online Payment " + this.onlineResponse.get());
        OnlinePaymentResponse response = this.onlineResponse.get();
        if (response != null && response.isSuccess()) {
            FinanceUnit type = FinanceUnit.getUnitForName((String)response.getUnit());
            if (type == null) {
                type = FinanceUnit.financeUnitTypeMap.keySet().contains(response.getUnit()) ? FinanceUnit.createUnit((FinanceUnit.FinanceUnitType)((FinanceUnit.FinanceUnitType)FinanceUnit.financeUnitTypeMap.get(response.getUnit())), (String)response.getUnit(), (boolean)false) : FinanceUnit.createUnit((FinanceUnit.FinanceUnitType)FinanceUnit.WEB_TYPE, (String)response.getUnit(), (boolean)false);
            }
            Price finalAmount = new Price(response.getAmount().toString());
            this.newTransaction = new WebTransaction(this.context.getUser(), this.context.getTerminal(), finalAmount, Price.ZERO_DOLLAR, this.context.getTerminal().getAssignedCashDrawer(this.context.getUser()), type, this.context.getShift());
            this.newTransaction.setTransactionReference(response.getTxnReference());
            this.newTransaction.setSource(response.getSource());
        } else {
            String reason;
            String string = reason = response == null ? null : response.getReason();
            if (StringUtils.isEmpty((String)reason)) {
                reason = "Please see logs";
            }
            Dialogs.displayOkDialog((String)reason, (String)"Online Payment Failed");
        }
        this.onlineResponse.set(null);
        this.done.emit();
    }

    WebTransaction getTransaction() {
        return this.newTransaction;
    }

    private class WebPaymentReqPanel
    extends JPanel
    implements ActionListener {
        private JButton paymentIdButton;
        private JButton authCodeButton;
        private JXDatePicker issueDateField;
        private JXDatePicker expiryDateField;

        private WebPaymentReqPanel() {
            this.setupComponents();
        }

        private void setupComponents() {
            this.paymentIdButton = new JButton("");
            this.authCodeButton = new JButton("");
            this.expiryDateField = new JXDatePicker();
            this.issueDateField = new JXDatePicker();
            this.setLayout((LayoutManager)new GraphPaperLayout(10, 6));
            Font thicker = OrderMateTheme.getMediumFont();
            JLabel paymentLabel = new JLabel("Payment / Account ID");
            paymentLabel.setFont(thicker);
            JLabel authLabel = new JLabel("Authorisation Code");
            authLabel.setFont(thicker);
            JLabel expiryLabel = new JLabel("Expiry Date");
            expiryLabel.setFont(thicker);
            JLabel issueLabel = new JLabel("Issue Date");
            issueLabel.setFont(thicker);
            int count = 1;
            if (OnlinePaymentProcess.this.request.isPaymentIdRequired()) {
                this.paymentIdButton.addActionListener(this);
                this.add((Component)paymentLabel, new Rectangle(1, count, 3, 1));
                this.add((Component)this.paymentIdButton, new Rectangle(4, count, 5, 1));
                ++count;
            }
            if (OnlinePaymentProcess.this.request.isAuthCodeRequired()) {
                this.authCodeButton.addActionListener(this);
                this.add((Component)authLabel, new Rectangle(1, count, 3, 1));
                this.add((Component)this.authCodeButton, new Rectangle(4, count, 5, 1));
                ++count;
            }
            if (OnlinePaymentProcess.this.request.isExpiryDateRequired()) {
                this.add((Component)expiryLabel, new Rectangle(1, count, 3, 1));
                this.add((Component)this.expiryDateField, new Rectangle(4, count, 5, 1));
                ++count;
            }
            if (OnlinePaymentProcess.this.request.isIssueDateRequired()) {
                this.add((Component)issueLabel, new Rectangle(1, count, 3, 1));
                this.add((Component)this.issueDateField, new Rectangle(4, count, 5, 1));
                ++count;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.paymentIdButton) {
                String payId = Dialogs.getString((String)"Payment / Account ID", (String)this.paymentIdButton.getText());
                this.paymentIdButton.setText(payId);
            } else if (e.getSource() == this.authCodeButton) {
                String auth = Dialogs.getString((String)"Auth Code ", (String)this.authCodeButton.getText());
                this.authCodeButton.setText(auth);
            }
        }
    }
}

