/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.webtransaction;

import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.TransactionSummary;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.internationalization.Internationalization;
import ordermate.services.finance.transactions.FinanceTransactionFactory;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.AbstractTransactionNav;
import waitermate.gui.screens.payment.eftpos.EftposTransactionScreen;
import waitermate.gui.screens.payment.webtransaction.OnlinePaymentProcess;
import waitermate.gui.screens.payment.webtransaction.WebTransactionNav;
import waitermate.gui.screens.payment.webtransaction.WebTransactionPanel;
import waitermate.guikit.dialogs.Dialogs;

public class WebTransactionScreen
extends EftposTransactionScreen {
    private final DecimalFormat format = new DecimalFormat("0.0#%");
    private FinanceTransactionFactory transactionFactory = new FinanceTransactionFactory();
    private Price paid;
    private Price tip;
    private Price surcharge;
    private FinanceUnit type;
    Signal<TransactionSummary, ?, ?, ?, ?> valuesChanged = Signals.createSignal(TransactionSummary.class, (String)"summary");
    private WebTransactionPanel gui = new WebTransactionPanel();
    private OnlinePaymentProcess onlineProcess;

    public WebTransactionScreen() {
        this.gui.paidSelected.connect((Object)this, "gotPaid");
        this.gui.tipSelected.connect((Object)this, "gotTip");
        this.gui.typeChanged.connect((Object)this, "gotType");
        this.valuesChanged.connect((Object)this.gui, "setDetails");
        this.valuesChanged.connect((Object)this.getNavBar(), "setDetails");
        ((WebTransactionNav)this.getNavBar()).onlinePressed.connect((Object)this, "gotOnline");
    }

    @Override
    public void startAddingTransaction(Price due, Payable payGroup) {
        super.startAddingTransaction(due, payGroup);
        this.paid = new Price(due.doubleValue(), 0.01);
        this.tip = new Price(0.0, 0.01);
        this.gui.setSubTypes(FinanceUnit.getWebUnits());
        this.gui.setPaidEnabled(payGroup.isPaidModifiable());
        this.gui.setSurchargeSelected(true);
        this.update();
        this.display();
    }

    @Override
    protected FinanceTransaction createTransaction(boolean autoSurcharge) {
        FinanceUnit unit = this.gui.getSelectedSubType();
        if (!this.autoSurchargeEnabled) {
            this.paid = this.paid.add(this.surcharge);
        } else {
            this.surcharge = Price.ZERO_DOLLAR;
        }
        WebTransaction newTransaction = this.transactionFactory.createWebTransaction(LoginManager.getEventContext(), this.paid, this.tip, unit);
        newTransaction.setSurcharge(this.surcharge);
        if (this.getNote() != null && !this.getNote().isEmpty()) {
            newTransaction.setNote(this.getNote());
        }
        return newTransaction;
    }

    @Override
    public void gotRecommendedPriceSelected(Price p) {
        this.paid = p;
        this.tip = Price.ZERO_DOLLAR;
        this.update();
    }

    private void update() {
        if (this.gui != null) {
            this.autoSurchargeEnabled = this.autoSurchargeEnabled && this.type.isUsesEftpos();
            this.surcharge = this.gui.isSurchargeSelected() && !this.autoSurchargeEnabled ? FinanceSurchargeCalculator.calculateSurcharge((Price)this.paid, (Price)this.tip, (FinanceUnit)this.type) : Price.ZERO_DOLLAR;
            this.gui.setSurchargeLabel("Surcharge for " + this.type.getLabel() + " (" + this.format.format(this.type.getSurcharge()) + ")");
        } else {
            this.surcharge = Price.ZERO_DOLLAR;
        }
        TransactionSummary summary = TransactionSummary.TransactionSummaryBuilder.start().paid(this.paid).tip(this.tip).cashout(Price.ZERO_DOLLAR).surcharge(this.surcharge).due(this.getDue()).build();
        this.valuesChanged.emit((Object)summary);
    }

    void gotPaid() {
        double newPaid = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"PAID") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")), (boolean)this.isCustomRefundEnabled());
        if (newPaid != Double.MIN_VALUE) {
            this.paid = new Price(newPaid, 0.01);
            this.update();
        }
    }

    void gotTip() {
        double newTip = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"TIP") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newTip != Double.MIN_VALUE) {
            this.tip = new Price(newTip, 0.01);
            this.update();
        }
    }

    void gotType() {
        this.type = this.gui.getSelectedSubType();
        this.update();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public AbstractTransactionNav createNavBar() {
        return new WebTransactionNav();
    }

    @Override
    public List<Sellable> getPayableItemsFromItemGroup(ItemGroup group) {
        return this.sellableFactory.getSellables(group);
    }

    @Override
    protected void checkAutoSurcharge() {
        this.gui.enableAutoSurcharge(this.autoSurchargeEnabled);
    }

    public void gotOnline() {
        this.onlineProcess = new OnlinePaymentProcess(this.paid, (Account)this.getItemGroup(), LoginManager.getEventContext());
        this.onlineProcess.done.connect((Object)this, "gotOnlineFinished");
        this.onlineProcess.start();
    }

    public void gotOnlineFinished() {
        WebTransaction txn = this.onlineProcess.getTransaction();
        if (txn != null) {
            this.transactionCompleted((FinanceTransaction)txn);
        }
        this.onlineProcess.done.disconnect((Object)this);
        this.onlineProcess = null;
    }
}

