/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.pettycash;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.Dialogs;

public class WMPettyCashGui
extends JPanel
implements ActionListener {
    public final Signal<CashDrawer, ?, ?, ?, ?> addPettyCash = Signals.createSignal(CashDrawer.class, (String)"cd");
    public final Signal<CashDrawer, PettyCashEntry, ?, ?, ?> editPettyCash = Signals.createSignal(CashDrawer.class, (String)"cd", PettyCashEntry.class, (String)"pcEntry");
    private JButton addPCButton;
    private JButton editPCButton;
    private RendererScrollPaneModel<CashDrawer> cdModel;
    private RendererScrollPaneModel<PettyCashEntry> pcModel;
    private CustomScrollPane cdScroll;
    private CustomScrollPane pcScroll;
    private CashDrawerRenderer cdRenderer;
    private PCRenderer pcRenderer;

    WMPettyCashGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 30)));
        this.cdRenderer = new CashDrawerRenderer();
        this.cdModel = new RendererScrollPaneModel((Renderer)this.cdRenderer, 1, 5);
        this.cdScroll = new CustomScrollPane(this.cdModel);
        this.cdScroll.setDecorationLocation(DecoratorLocation.East);
        this.cdScroll.setBorder((Border)new TitledBorder("Cashdrawer"));
        this.add((Component)this.cdScroll, new Rectangle(1, 1, 8, 16));
        this.pcRenderer = new PCRenderer();
        this.pcModel = new RendererScrollPaneModel((Renderer)this.pcRenderer, 1, 5);
        this.pcScroll = new CustomScrollPane(this.pcModel);
        this.pcScroll.setName("pettyCashEntries");
        this.pcScroll.setBorder((Border)new TitledBorder("Entries"));
        this.pcScroll.setDecorationLocation(DecoratorLocation.East);
        this.add((Component)this.pcScroll, new Rectangle(11, 1, 8, 16));
        this.addPCButton = new JButton();
        this.add((Component)this.addPCButton, new Rectangle(1, 25, 8, 4));
        this.addPCButton.setText("Create Petty Cash Entry");
        this.addPCButton.setFont(OrderMateTheme.getMediumFont());
        this.addPCButton.setIcon(IconLoader.get((String)"/waitermate/images/money.png"));
        this.addPCButton.addActionListener(this);
        this.editPCButton = new JButton();
        this.add((Component)this.editPCButton, new Rectangle(11, 25, 8, 4));
        this.editPCButton.setFont(OrderMateTheme.getMediumFont());
        this.editPCButton.setText("Edit Petty Cash Entry");
        this.editPCButton.setIcon(IconLoader.get((String)"/waitermate/images/edit.png"));
        this.editPCButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CashDrawer cd = this.cdRenderer.getSelected();
        if (cd == null) {
            Dialogs.displayOkDialog((String)"There are no cashdrawers attached to this terminal", (String)"Cannot add or view petty cash entries");
            return;
        }
        PettyCashEntry pcEntry = this.pcRenderer.getSelected();
        if (e.getSource() == this.addPCButton) {
            this.addPettyCash.emit((Object)cd);
        } else if (e.getSource() == this.editPCButton) {
            this.editPettyCash.emit((Object)cd, (Object)pcEntry);
        }
    }

    void setCashDrawers(List<CashDrawer> availableCashDrawers) {
        this.cdModel.removeAllObjects();
        this.cdModel.addObjects(availableCashDrawers);
    }

    public void setPettyCashEntries(List<PettyCashEntry> allPCEntries) {
        this.pcModel.removeAllObjects();
        this.pcModel.addObjects(allPCEntries);
    }

    public CashDrawer getSelectedCashdrawer() {
        return this.cdRenderer.getSelected();
    }

    private class PCRenderer
    implements Renderer<JToggleButton, PettyCashEntry> {
        private ButtonGroup bg = new ButtonGroup();
        private Map<JToggleButton, PettyCashEntry> map = new HashMap<JToggleButton, PettyCashEntry>();

        private PCRenderer() {
        }

        public JToggleButton createComponent() {
            JToggleButton button = new JToggleButton();
            OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
            this.bg.add(button);
            return button;
        }

        public void setupComponent(JToggleButton component, PettyCashEntry pc, int index) {
            if (index == 0) {
                component.setSelected(true);
            }
            component.setText(new HtmlBuilder().appendBold(pc.getValue().toString(true)).appendLineBreak().appendBoldColor(pc.getDescription(), "Gray").toString());
            this.map.put(component, pc);
        }

        PettyCashEntry getSelected() {
            for (Map.Entry<JToggleButton, PettyCashEntry> entry : this.map.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().isSelected()) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    private class CashDrawerRenderer
    implements Renderer<JToggleButton, CashDrawer> {
        private ButtonGroup bg = new ButtonGroup();
        private Map<JToggleButton, CashDrawer> map = new HashMap<JToggleButton, CashDrawer>();

        private CashDrawerRenderer() {
        }

        public JToggleButton createComponent() {
            JToggleButton button = new JToggleButton();
            OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
            this.bg.add(button);
            return button;
        }

        public void setupComponent(JToggleButton component, CashDrawer object, int index) {
            if (index == 0) {
                component.setSelected(true);
            }
            component.setText(object.getLabel());
            this.map.put(component, object);
        }

        CashDrawer getSelected() {
            for (Map.Entry<JToggleButton, CashDrawer> entry : this.map.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().isSelected()) continue;
                return entry.getValue();
            }
            return null;
        }
    }
}

