/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.pettycash;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.AllPermissions;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.pettycash.WMPettyCashEditor;
import waitermate.gui.screens.pettycash.WMPettyCashGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class WMPettyCashScreen
extends AbstractScreen {
    private WMPettyCashGui gui;
    private NavBar nav;
    private WMPettyCashEditor pettyCashEditor;
    public final Signal back = Signals.createSignal();
    public final Signal ok = Signals.createSignal();

    public WMPettyCashScreen() {
        this.nav = new NavBar();
        this.nav.ok.connect(this.ok);
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.setText("Petty Cash");
    }

    public JComponent getMainArea() {
        if (this.gui == null) {
            this.gui = new WMPettyCashGui();
            this.gui.addPettyCash.connect((Object)this, "gotCreatePettyCashEntry");
            this.gui.editPettyCash.connect((Object)this, "gotEditPettyCashEntry");
            this.gui.setCashDrawers(Terminal.getLocalHost().getAvailableCashDrawers(LoginManager.getInstance().getUser()));
        }
        this.refresh();
        return this.gui;
    }

    private void refresh() {
        List pcEntries = PersistenceManager.getObjectList(PettyCashEntry.class, (String)Query.select(PettyCashEntry.class).linkUsing(PettyCashEntry.Properties.PARENT, CashdrawerReconciliation.Properties.ID).linkUsing(CashdrawerReconciliation.Properties.PARENT, ShiftReconciliation.Properties.ID).equals(ShiftReconciliation.Properties.SHIFT, (Object)Terminal.getLocalHost().getShift()).orderBy(PettyCashEntry.Properties.ID, true).limit(60).toString());
        this.gui.setPettyCashEntries(pcEntries);
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    private boolean doEdit(CashDrawer cd, PettyCashEntry entry) {
        this.pettyCashEditor = null;
        if (this.pettyCashEditor == null) {
            this.pettyCashEditor = new WMPettyCashEditor();
        }
        this.pettyCashEditor.setEntry(entry);
        PopupWindow window = new PopupWindow(true);
        window.getNavBar().getCancelButton().setText("Cancel");
        window.getNavBar().getOkButton().setText("Save");
        window.getNavBar().setText((entry.isPersistent() ? "Edit" : "Create") + " Petty Cash Entry");
        window.setComponent((JComponent)this.pettyCashEditor);
        return window.start();
    }

    public void gotCreatePettyCashEntry(CashDrawer cd) {
        ShiftReconciliation rec = this.primeReconciliation();
        if (rec == null) {
            return;
        }
        CashdrawerReconciliation cdRec = rec.getCashDrawerReconciliation(cd);
        if (cdRec == null) {
            Dialogs.displayOkDialog((String)"There is no reconciliation for this cashdrawer.", (String)"Cannot create Petty Cash");
            return;
        }
        PettyCashEntry entry = new PettyCashEntry();
        cdRec.addEntry((AbstractReconciliationEntry)entry);
        entry.setParent(cdRec);
        entry.setUser(LoginManager.getInstance().getUser());
        entry.setFinanceUnit(FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.CASH_TYPE));
        if (this.doEdit(cd, entry)) {
            cdRec.addEntry((AbstractReconciliationEntry)entry);
            cdRec.save();
            this.refresh();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ShiftReconciliation primeReconciliation() {
        Shift shift = Terminal.getLocalHost().getShift();
        ShiftReconciliation rec = (ShiftReconciliation)PersistenceManager.getObject(ShiftReconciliation.class, (String)Query.select(ShiftReconciliation.class).equals(ShiftReconciliation.Properties.SHIFT, (Object)shift).toString());
        if (rec == null) {
            if (LoginManager.getInstance().getUser().hasPermission(AllPermissions.MYTILLS_RECONCILIATION)) {
                if (!Dialogs.displayChoiceDialog((String)("There is no current Reconciliation for " + shift + ". Would you like to create one?"), (String)"Create Reconciliation?", (boolean)false)) return rec;
                rec = new ShiftReconciliation(shift, LoginManager.getInstance().getUser());
                rec.save();
                return rec;
            }
            Dialogs.displayOkDialog((String)("There is no current Reconciliation for " + shift), (String)"Cannot create Petty Cash");
            return null;
        }
        if (!rec.isCompleted()) return rec;
        if (LoginManager.getInstance().getUser().hasPermission(AllPermissions.EDIT_COMPLETED_RECONCILIATIONS)) {
            if (Dialogs.displayChoiceDialog((String)("The Reconciliation for " + shift + " has been marked as completed. Continue?"), (String)"Create Petty Cash Entry?", (boolean)false)) return rec;
            return null;
        }
        Dialogs.displayOkDialog((String)("The Reconciliation for " + shift + " has been marked as completed."), (String)"Cannot create Petty Cash");
        return null;
    }

    public void gotEditPettyCashEntry(CashDrawer cd, PettyCashEntry entry) {
        if (entry == null) {
            Dialogs.displayOkDialog((String)"Please select a petty cash entry", (String)"No entry selected");
            return;
        }
        if (this.doEdit(cd, entry)) {
            entry.saveChild();
            this.refresh();
        }
    }
}

