/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class RecEntryHolder
extends JPanel
implements ActionListener {
    Signal<RecEntryHolder, ?, ?, ?, ?> gotType = Signals.createSignal(RecEntryHolder.class, (String)"recType");
    private final AbstractReconciliationEntry.RecEntryType type;
    private JButton selector;
    private JLabel totalLabel;
    private JLabel expectedLabel;
    private JLabel varianceLabel;
    private List<AbstractReconciliationEntry> entries;
    private Price expected;
    private Price total;
    private Price variance;
    private Price additional;
    private boolean hasExpected = true;
    private boolean negative = false;

    RecEntryHolder(AbstractReconciliationEntry.RecEntryType yourType) {
        super(new GridLayout(1, 6));
        this.type = yourType;
        this.entries = new ArrayList<AbstractReconciliationEntry>();
        this.add(Box.createHorizontalGlue());
        this.selector = new JButton(StringUtils.underscoreToDisplayable((String)yourType.name().toLowerCase()));
        OrderMateTheme.setupTouchScreenButton((AbstractButton)this.selector);
        this.selector.addActionListener(this);
        this.add(this.selector);
        this.totalLabel = new JLabel("$0.00");
        this.totalLabel.setName(yourType + " Total");
        this.totalLabel.setHorizontalAlignment(4);
        this.add(this.totalLabel);
        this.expectedLabel = new JLabel("$0.00");
        this.expectedLabel.setName(yourType + " Expected");
        this.expectedLabel.setHorizontalAlignment(4);
        this.expectedLabel.setForeground(Color.GRAY);
        this.add(this.expectedLabel);
        this.varianceLabel = new JLabel("$0.00");
        this.varianceLabel.setName(yourType + " Variance");
        this.varianceLabel.setHorizontalAlignment(4);
        this.varianceLabel.setForeground(Color.GRAY);
        this.add(this.varianceLabel);
        this.add(Box.createHorizontalGlue());
    }

    public void negative() {
        this.negative = true;
    }

    public void setAdditionalValue(Price value) {
        this.additional = value;
    }

    public void hideExpected() {
        this.hasExpected = false;
        this.expectedLabel.setVisible(false);
        this.varianceLabel.setVisible(false);
    }

    public void clearTotal() {
        this.total = Price.ZERO_DOLLAR;
    }

    public void setBlind(boolean value) {
        if (this.hasExpected) {
            this.varianceLabel.setVisible(!value);
            this.expectedLabel.setVisible(!value);
        }
    }

    public void setEditable(boolean value) {
        this.selector.setEnabled(value);
    }

    AbstractReconciliationEntry.RecEntryType getType() {
        return this.type;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.gotType.emit((Object)this);
    }

    void clear() {
        this.entries.clear();
        this.total = Price.ZERO_DOLLAR;
        this.expected = Price.ZERO_DOLLAR;
        this.variance = Price.ZERO_DOLLAR;
        this.additional = null;
    }

    void addEntry(AbstractReconciliationEntry entry) {
        this.total = this.total.add(entry.getValue());
    }

    void setExpected(Price value) {
        this.expected = value;
    }

    void update() {
        if (this.additional != null) {
            this.totalLabel.setText(this.total.toString(true));
            this.variance = this.total.subtract(this.expected.add(this.additional));
            this.expectedLabel.setText("(" + this.additional.toString(true) + ") + " + this.expected.toString(true));
            this.varianceLabel.setText(this.variance.toString(true));
        } else {
            if (this.negative) {
                this.totalLabel.setText("(" + this.total.toString(true) + ")");
            } else {
                this.totalLabel.setText(this.total.toString(true));
            }
            this.variance = this.total.subtract(this.expected);
            this.expectedLabel.setText(this.expected.toString(true));
            this.varianceLabel.setText(this.variance.toString(true));
        }
    }
}

