/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.util.Price;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.TipsEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

class WMRecTipsEntryEditor
extends JPanel {
    private KeypadDialog keyDog;
    private final CashdrawerReconciliation rec;
    private Map<String, TipHolder> unitMap;

    WMRecTipsEntryEditor(CashdrawerReconciliation rec) {
        this.rec = rec;
        this.setupComponents();
    }

    private void setupComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.unitMap = new HashMap<String, TipHolder>();
        for (FinanceUnit.FinanceUnitType unitType : new FinanceUnit.FinanceUnitType[]{FinanceUnit.CASH_TYPE, FinanceUnit.CREDIT_TYPE, FinanceUnit.DEBIT_TYPE}) {
            TipHolder holder = new TipHolder(unitType);
            this.unitMap.put(unitType.toString(), holder);
            this.add(holder);
            this.add(Box.createVerticalStrut(5));
        }
        for (TipsEntry entry : this.rec.getTipsEntries()) {
            this.unitMap.get(entry.getFinanceUnit().getType()).setEntry(entry);
        }
    }

    class TipHolder
    extends JPanel
    implements ActionListener {
        private TipsEntry entry;
        private Price value;
        private JLabel unitTypeLabel;
        private JButton valueButton;
        private FinanceUnit.FinanceUnitType unitType;

        public TipHolder(FinanceUnit.FinanceUnitType unitType) {
            super(new GridLayout(1, 2, 5, 5));
            this.value = Price.ZERO_DOLLAR;
            this.unitType = unitType;
            this.unitTypeLabel = new JLabel(unitType.toString());
            this.valueButton = new JButton("$0.00");
            OrderMateTheme.setupTouchScreenButton((AbstractButton)this.valueButton);
            this.valueButton.addActionListener(this);
            this.valueButton.setName(unitType.toString() + "Button");
            this.valueButton.setPreferredSize(new Dimension(120, 40));
            this.add(this.unitTypeLabel);
            this.add(this.valueButton);
        }

        private void setEntry(TipsEntry entry) {
            this.entry = entry;
            this.value = entry.getValue();
            this.updateText();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.doAmount();
        }

        private void updateText() {
            this.valueButton.setText(this.value.toString(true));
        }

        private void doAmount() {
            if (WMRecTipsEntryEditor.this.keyDog == null) {
                WMRecTipsEntryEditor.this.keyDog = new KeypadDialog();
                WMRecTipsEntryEditor.this.keyDog.setup(true);
            }
            WMRecTipsEntryEditor.this.keyDog.setValue(this.entry != null ? this.entry.getValue().toString(false) : Price.ZERO_DOLLAR.toString(false));
            WMRecTipsEntryEditor.this.keyDog.setUnits("$ " + this.unitType.toString() + ": ");
            if (Dialogs.displayDialog((JComponent)WMRecTipsEntryEditor.this.keyDog, (String)"Enter Tip Value", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true)) {
                double entryValue;
                if (this.entry == null) {
                    this.entry = WMRecTipsEntryEditor.this.rec.getTipsEntry(this.unitType);
                }
                if ((entryValue = WMRecTipsEntryEditor.this.keyDog.getValueAsDouble()) >= 0.0) {
                    this.value = new Price(entryValue, 0.01);
                }
                this.entry.setValue(this.value);
                this.updateText();
            }
            WMRecTipsEntryEditor.this.keyDog = null;
        }
    }
}

