/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class WMReconciliationGui
extends JPanel
implements ActionListener {
    public final Signal<CashDrawer, Shift, ?, ?, ?> addRec = Signals.createSignal(CashDrawer.class, (String)"cd", Shift.class, (String)"shift");
    public final Signal<CashDrawer, Shift, ?, ?, ?> viewRec = Signals.createSignal(CashDrawer.class, (String)"cd", Shift.class, (String)"shift");
    private JButton addRecButton;
    private JButton viewRecButton;
    private RendererScrollPaneModel<CashDrawer> cdModel;
    private RendererScrollPaneModel<Shift> shiftModel;
    private CustomScrollPane cdScroll;
    private CustomScrollPane shiftScroll;
    private CashDrawerRenderer cdRenderer;
    private ShiftRenderer shiftRenderer;

    WMReconciliationGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 30)));
        this.cdRenderer = new CashDrawerRenderer();
        this.cdModel = new RendererScrollPaneModel((Renderer)this.cdRenderer, 1, 5);
        this.cdScroll = new CustomScrollPane(this.cdModel);
        this.cdScroll.setDecorationLocation(DecoratorLocation.East);
        this.cdScroll.setBorder((Border)new TitledBorder("Cashdrawer"));
        this.add((Component)this.cdScroll, new Rectangle(1, 1, 8, 16));
        this.shiftRenderer = new ShiftRenderer();
        this.shiftModel = new RendererScrollPaneModel((Renderer)this.shiftRenderer, 1, 5);
        this.shiftScroll = new CustomScrollPane(this.shiftModel);
        this.shiftScroll.setBorder((Border)new TitledBorder("Shift"));
        this.shiftScroll.setDecorationLocation(DecoratorLocation.East);
        this.add((Component)this.shiftScroll, new Rectangle(11, 1, 8, 16));
        this.addRecButton = new JButton();
        this.add((Component)this.addRecButton, new Rectangle(1, 25, 8, 4));
        this.addRecButton.setText("Edit Reconciliation");
        this.addRecButton.setFont(OrderMateTheme.getMediumFont());
        this.addRecButton.setIcon(IconLoader.get((String)"/waitermate/images/money.png"));
        this.addRecButton.addActionListener(this);
        this.viewRecButton = new JButton();
        this.add((Component)this.viewRecButton, new Rectangle(11, 25, 8, 4));
        this.viewRecButton.setFont(OrderMateTheme.getMediumFont());
        this.viewRecButton.setText("View Reconciliation");
        this.viewRecButton.setIcon(IconLoader.get((String)"/waitermate/images/page.png"));
        this.viewRecButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CashDrawer cd = this.cdRenderer.getSelected();
        if (cd == null) {
            return;
        }
        Shift shift = this.shiftRenderer.getSelected();
        if (e.getSource() == this.addRecButton) {
            this.addRec.emit((Object)cd, (Object)shift);
        } else if (e.getSource() == this.viewRecButton) {
            this.viewRec.emit((Object)cd, (Object)shift);
        }
    }

    void setCashDrawers(List<CashDrawer> availableCashDrawers) {
        this.cdModel.removeAllObjects();
        this.cdModel.addObjects(availableCashDrawers);
    }

    public void setShifts(List<Shift> allShiftsFor) {
        this.shiftModel.removeAllObjects();
        this.shiftModel.addObjects(allShiftsFor);
    }

    private class ShiftRenderer
    implements Renderer<JToggleButton, Shift> {
        private ButtonGroup bg = new ButtonGroup();
        private Map<JToggleButton, Shift> map = new HashMap<JToggleButton, Shift>();

        private ShiftRenderer() {
        }

        public JToggleButton createComponent() {
            JToggleButton button = new JToggleButton();
            OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
            this.bg.add(button);
            return button;
        }

        public void setupComponent(JToggleButton component, Shift object, int index) {
            if (index == 0) {
                component.setSelected(true);
            }
            component.setText(object.getLabel());
            this.map.put(component, object);
        }

        Shift getSelected() {
            for (Map.Entry<JToggleButton, Shift> entry : this.map.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().isSelected()) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    private class CashDrawerRenderer
    implements Renderer<JToggleButton, CashDrawer> {
        private ButtonGroup bg = new ButtonGroup();
        private Map<JToggleButton, CashDrawer> map = new HashMap<JToggleButton, CashDrawer>();

        private CashDrawerRenderer() {
        }

        public JToggleButton createComponent() {
            JToggleButton button = new JToggleButton();
            OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
            this.bg.add(button);
            return button;
        }

        public void setupComponent(JToggleButton component, CashDrawer object, int index) {
            if (index == 0) {
                component.setSelected(true);
            }
            component.setText(object.getLabel());
            this.map.put(component, object);
        }

        CashDrawer getSelected() {
            for (Map.Entry<JToggleButton, CashDrawer> entry : this.map.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().isSelected()) continue;
                return entry.getValue();
            }
            return null;
        }
    }
}

