/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.glazedlists.PropertyAccessorComparator;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.awt.Component;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.AllPermissions;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.reconciliation.WMCashDrawerReconciliation;
import waitermate.gui.screens.reconciliation.WMReconciliationGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class WMReconciliationScreen
extends AbstractScreen {
    private WMReconciliationGui gui;
    private NavBar nav;
    private WMCashDrawerReconciliation cdRecScreen;
    public final Signal back = Signals.createSignal();
    public final Signal ok = Signals.createSignal();

    public WMReconciliationScreen() {
        this.nav = new NavBar();
        this.nav.ok.connect(this.ok);
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.setText("Cashdrawer Reconciliations");
    }

    public JComponent getMainArea() {
        if (this.gui == null) {
            this.gui = new WMReconciliationGui();
            this.gui.addRec.connect((Object)this, "gotCreateRec");
            this.gui.viewRec.connect((Object)this, "gotViewRec");
        }
        return this.gui;
    }

    public void display(boolean fullScreen) {
        this.getMainArea();
        this.gui.setCashDrawers(Terminal.getLocalHost().getAvailableCashDrawers(LoginManager.getInstance().getUser()));
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        Date to = cal.getTime();
        cal.add(5, -60);
        Date from = cal.getTime();
        List shifts = Shift.getAllShiftsFor((Date)from, (Date)to);
        Collections.sort(shifts, new PropertyAccessorComparator((PropertyAccessor)Shift.Properties.TRADING_DAY, true));
        this.gui.setShifts(shifts);
        super.display(fullScreen);
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    private boolean primeEditor(CashDrawer cd, Shift shift, boolean editable) {
        ShiftReconciliation shiftRec = (ShiftReconciliation)PersistenceManager.getObject(ShiftReconciliation.class, (String)Query.select(ShiftReconciliation.class).equals(ShiftReconciliation.Properties.SHIFT, (Object)shift).toString());
        if (shiftRec == null) {
            if (!editable) {
                Dialogs.displayOkDialog((String)("No Reconciliation exists for this shift " + shift), (String)"No Rec for Shift");
                return false;
            }
            boolean create = Dialogs.displayChoiceDialog((String)"No Reconciliation exists for this shift. Do you want to make a new one?", (String)"New Reconciliation?", (boolean)false);
            if (!create) {
                return false;
            }
            shiftRec = new ShiftReconciliation(shift, LoginManager.getEventContext().getUser());
            shiftRec.save();
        }
        CashdrawerReconciliation cdRec = null;
        cdRec = shiftRec.getCashDrawerReconciliation(cd);
        if (cdRec == null) {
            Dialogs.displayOkDialog((String)("There is no Reconciliation for this Cashdrawer: " + cd), (String)"No Cashdrawer Reconciliation");
            return false;
        }
        if (this.cdRecScreen == null) {
            this.cdRecScreen = new WMCashDrawerReconciliation();
            this.cdRecScreen.done.connect((Object)this, "display");
        }
        boolean notBlind = LoginManager.getInstance().getUser().hasPermission(AllPermissions.WAITERMATE_RECONCILIATION);
        this.cdRecScreen.setReconciliation(cdRec, editable && !shiftRec.isCompleted(), !notBlind);
        return true;
    }

    public void gotCreateRec(CashDrawer cd, Shift shift) {
        if (this.primeEditor(cd, shift, true)) {
            this.cdRecScreen.display();
        }
    }

    public void gotViewRec(CashDrawer cd, Shift shift) {
        if (this.primeEditor(cd, shift, false)) {
            this.cdRecScreen.display();
        }
    }
}

