/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations;

import au.com.ordermate.util.DateTimeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class ReservationDurationSelector {
    private final ReservationDurationPanel durationPanel = new ReservationDurationPanel();
    private final PopupWindow durationPopup = new PopupWindow();
    private int selectedDuration;

    public ReservationDurationSelector() {
        this.durationPopup.setComponent((JComponent)this.durationPanel);
        this.durationPopup.setOkButtonEnable(false);
        this.durationPopup.setCancelButtonText(Internationalization.getLiteralFor((String)"CANCEL"));
        this.durationPopup.setText(Internationalization.getLiteralFor((String)"BOOKING_DURATION"));
        this.selectedDuration = -1;
    }

    public int select(List<Integer> durationOptions, String message) {
        this.durationPanel.setDurationOptions(durationOptions);
        this.durationPanel.setMessage(message);
        boolean selected = Dialogs.displayDialog((PopupWindow)this.durationPopup, null, null);
        return selected ? this.selectedDuration : -1;
    }

    class ReservationDurationPanel
    extends JPanel
    implements ActionListener {
        private JLabel titleLabel;
        private JLabel messageLabel;
        private JPanel buttonPanel;
        private JPanel centreHolder;
        private List<Integer> durationOptions;
        private List<JButton> durationOptionButtons;

        public ReservationDurationPanel() {
            super(new BorderLayout());
            this.setPreferredSize(new Dimension(320, 400));
            this.setupComponents();
        }

        private void setupComponents() {
            this.titleLabel = new JLabel();
            this.titleLabel.setText(Internationalization.getLiteralFor((String)"DURATION_FOR_SEATING"));
            this.titleLabel.setFont(OrderMateTheme.getLargeFont());
            this.messageLabel = new JLabel();
            this.centreHolder = new JPanel(new BorderLayout());
            this.buttonPanel = new JPanel(new FlowLayout(0));
            JPanel bottomHolder = new JPanel(new FlowLayout());
            bottomHolder.add(this.messageLabel);
            this.messageLabel.setFont(OrderMateTheme.getMediumFont());
            this.centreHolder.add((Component)this.buttonPanel, "Center");
            this.add((Component)this.titleLabel, "North");
            this.add((Component)this.centreHolder, "Center");
            this.add((Component)bottomHolder, "South");
        }

        private void setMessage(String text) {
            this.messageLabel.setText(text);
        }

        private void setDurationOptions(List<Integer> availableOptions) {
            this.clearDurationOptionButtons();
            this.durationOptions = availableOptions;
            if (this.durationOptions != null && !this.durationOptions.isEmpty()) {
                this.durationOptionButtons = new ArrayList<JButton>(this.durationOptions.size());
                this.buttonPanel.removeAll();
                for (Integer nextOption : availableOptions) {
                    String readableDuration = DateTimeUtils.convertToReadableTime((long)((long)nextOption.intValue() * 60000L));
                    JButton button = new JButton(readableDuration);
                    OrderMateTheme.setupUntoggledButton((AbstractButton)button);
                    button.addActionListener(this);
                    button.setPreferredSize(new Dimension(100, 100));
                    this.durationOptionButtons.add(button);
                    this.buttonPanel.add(button);
                }
                this.buttonPanel.validate();
                this.centreHolder.validate();
                this.validate();
                this.repaint();
            }
        }

        private void clearDurationOptionButtons() {
            if (this.durationOptionButtons != null) {
                for (JButton durationOptionBtn : this.durationOptionButtons) {
                    durationOptionBtn.removeActionListener(this);
                    this.buttonPanel.remove(durationOptionBtn);
                }
                this.durationOptionButtons.clear();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            ReservationDurationSelector.this.selectedDuration = -1;
            for (int i = 0; i < this.durationOptionButtons.size(); ++i) {
                if (source == this.durationOptionButtons.get(i)) {
                    OrderMateTheme.setupToggledButton((AbstractButton)this.durationOptionButtons.get(i));
                    ReservationDurationSelector.this.durationPopup.setOkButtonEnable(true);
                    ReservationDurationSelector.this.selectedDuration = this.durationOptions.get(i);
                    continue;
                }
                OrderMateTheme.setupUntoggledButton((AbstractButton)this.durationOptionButtons.get(i));
            }
        }
    }
}

