/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations.addreservation;

import au.com.ordermate.util.DateTimeUtils;
import java.sql.Time;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.queries.tables.LogicalTableQueries;
import ordermate.database.sales.Customer;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.integration.restaurantdiary.RDBookingSummary;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.customer.SalesHistoryPanel;
import waitermate.gui.screens.customer.add.AddCustomer;
import waitermate.gui.screens.reservations.addreservation.AddReservationNav;
import waitermate.gui.screens.reservations.addreservation.AddReservationPanel;
import waitermate.gui.screens.reservations.addreservation.WMReservationArriver;
import waitermate.gui.screens.reservations.resdiary.RDBookingView;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AddReservation
extends AbstractScreen {
    private final AddReservationPanel gui;
    private AddCustomer addCustomerState;
    private final SalesHistoryPanel salesHistoryPanel = new SalesHistoryPanel();
    private Customer theCustomer;
    private final AddReservationNav nav;
    private TableGroup section;
    private String tables;
    private Date date;
    private Date time;
    private int patrons;
    private String comments;
    private Reservation existingReservation;
    private RDBookingSummary rdBookingSummary;
    public final Signal reservationSaved = Signals.createSignal();
    public final Signal back = Signals.createSignal();
    private WMReservationArriver arriver;

    public AddReservation() {
        this.gui = new AddReservationPanel();
        this.nav = new AddReservationNav();
        this.init();
    }

    public void start(Customer customer, Date theDate) {
        this.existingReservation = null;
        this.resetFields("");
        this.setCustomer(customer);
        this.date = theDate;
        this.nav.setText("Add Reservation");
        this.display();
    }

    public void start(Reservation reservation) {
        this.resetFields(reservation.getCommentsSafe());
        this.setCustomer(reservation.getCustomer());
        this.existingReservation = reservation;
        this.section = reservation.getSection();
        this.tables = reservation.getTables();
        this.date = reservation.getDate();
        this.time = reservation.getTime();
        this.patrons = reservation.getNumPatrons();
        this.comments = reservation.getCommentsSafe();
        this.nav.setText("Edit Reservation");
        this.display();
    }

    public void setUp() {
        this.updateGui();
    }

    private void setDeleteButtonVisible(Reservation theRes) {
        if (theRes == null) {
            this.nav.setDeleteButtonVisible(false);
        } else {
            boolean enable = false;
            if (!theRes.getReservationState().equalsIgnoreCase("ARRIVED")) {
                enable = true;
            }
            this.nav.setDeleteButtonVisible(enable);
        }
    }

    private void setArrivedButtonVisible(Reservation reservation) {
        if (reservation == null) {
            this.nav.setArrivedButtonVisible(false);
        } else {
            GregorianCalendar reservationCalendar = new GregorianCalendar();
            reservationCalendar.setTime(reservation.getDate());
            GregorianCalendar systemCalendar = new GregorianCalendar();
            systemCalendar.setTimeInMillis(System.currentTimeMillis());
            boolean rightState = reservation.getReservationState().equals("CONFIRMED") || reservation.getReservationState().equals("BOOKED");
            boolean rightDay = reservationCalendar.get(6) == systemCalendar.get(6) && reservationCalendar.get(1) == systemCalendar.get(1);
            this.nav.setArrivedButtonVisible(rightState && rightDay);
        }
    }

    private void setConfirmButtonVisible(Reservation reservation) {
        if (reservation == null) {
            this.nav.setConfirmButtonVisible(false);
        } else {
            boolean enable = false;
            if (reservation.getReservationState().equals("BOOKED") && this.isDateAfterEqualToday(reservation.getDate())) {
                enable = true;
            }
            this.nav.setConfirmButtonVisible(enable);
        }
    }

    private boolean isDateAfterEqualToday(Date value) {
        int result = DateTimeUtils.compareDates((Date)value, (Date)new Date(), (boolean)false);
        return result != -1;
    }

    private void init() {
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.nav.ok.connect((Object)this, "gotOK");
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.partyArrived.connect((Object)this, "gotPartyArrived");
        this.nav.delete.connect((Object)this, "gotDelete");
        this.nav.confirm.connect((Object)this, "gotConfirm");
        this.nav.editCustomerSignal.connect((Object)this, "gotEditCustomer");
        this.nav.salesHistorySignal.connect((Object)this, "gotShowSalesHistory");
        this.nav.resDiaryInfoSignal.connect((Object)this, "gotResDiaryInfo");
        this.gui.commentsUpdated.connect((Object)this, "gotComments");
        this.gui.dateUpdated.connect((Object)this, "gotDate");
        this.gui.patronsUpdated.connect((Object)this, "gotPatrons");
        this.gui.sectionUpdated.connect((Object)this, "gotTable");
        this.gui.tableUpdated.connect((Object)this, "gotTableNames");
        this.gui.timeUpdated.connect((Object)this, "gotTime");
        this.resetFields("");
    }

    public void resetFields(String keyboardValue) {
        this.date = new Date(System.currentTimeMillis());
        GregorianCalendar tempCalendar = new GregorianCalendar();
        tempCalendar.set(10, 5);
        tempCalendar.set(12, 0);
        this.time = tempCalendar.getTime();
        this.patrons = 0;
        this.comments = "";
        this.section = null;
        this.tables = "";
        this.rdBookingSummary = null;
        this.nav.setArrivedButtonVisible(false);
        this.nav.setDeleteButtonVisible(false);
        this.nav.setConfirmButtonVisible(false);
        this.gui.reset();
        this.gui.resetKeyboard(keyboardValue);
        this.refreshNavButtons();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    private void updateGui() {
        String sectionString = this.section == null ? "" : this.section.getLabel();
        this.setCustomer(this.theCustomer);
        this.gui.updateDisplay(this.date, this.time, sectionString, this.patrons, this.comments, this.tables, this.existingReservation);
        this.gui.setTimeMinuteChange();
        boolean enable = this.isDateAfterEqualToday(this.date);
        if (enable && this.existingReservation != null) {
            enable = !this.existingReservation.getReservationState().equals("ARRIVED");
        }
        this.gui.enableButtons(enable);
        this.refreshNavButtons();
    }

    private void saveReservation() {
        if (this.comments == null || this.comments.trim().equals("")) {
            String string = this.comments = this.theCustomer != null ? this.theCustomer.getComments() : "";
        }
        if (this.existingReservation == null) {
            Reservation newReservation = new Reservation(this.theCustomer, DateTimeUtils.clearSeconds((Date)this.time), this.date, this.patrons, this.section, this.comments);
            newReservation.setTables(this.tables);
            newReservation.save();
            TerminalEventLog.logReservationBooked((Reservation)newReservation, (EventContext)LoginManager.getEventContext());
            ReservationIntegrationUtils.reservationUpdated((Reservation)this.existingReservation);
            this.reservationSaved.emit();
        } else {
            TerminalEventLog.logReservationEdited((Reservation)this.existingReservation, (Customer)this.theCustomer, (String)this.comments, (int)this.patrons, (TableGroup)this.section, (Date)this.date, (Date)this.time, (EventContext)LoginManager.getEventContext());
            this.existingReservation.setComments(this.comments);
            this.existingReservation.setNumPatrons(Integer.valueOf(this.patrons));
            this.existingReservation.setSection(this.section);
            this.existingReservation.setTables(this.tables);
            this.existingReservation.setDate(this.date);
            this.existingReservation.setTime(this.time);
            this.existingReservation.save();
            ReservationIntegrationUtils.reservationUpdated((Reservation)this.existingReservation);
            this.reservationSaved.emit();
        }
    }

    public void setCustomer(Customer cust) {
        this.theCustomer = cust;
        if (this.theCustomer != null) {
            this.gui.setCustomerDetails(cust.getNameAndTitle(), cust.getPrimaryPhoneNumber());
        } else {
            this.gui.setCustomerDetails("Unknown", "");
        }
    }

    public void refreshNavButtons() {
        this.nav.enableOkButton(this.gui.refreshOkButton());
        this.setArrivedButtonVisible(this.existingReservation);
        if (!RDConfiguration.checkConfigured()) {
            this.setDeleteButtonVisible(this.existingReservation);
            this.setConfirmButtonVisible(this.existingReservation);
        }
        this.nav.setEditCustomerButtonEnabled(this.theCustomer != null);
        this.nav.setShowSalesHistoryButtonEnabled(this.theCustomer != null);
        this.setResDiaryInfoButtonEnabled(this.existingReservation);
    }

    private void setResDiaryInfoButtonEnabled(Reservation reservation) {
        if (RDConfiguration.checkConfigured() && this.isDateAfterEqualToday(this.date)) {
            this.nav.setResDiaryInfoButtonEnabled(true);
        } else {
            this.nav.setResDiaryInfoButtonEnabled(false);
        }
    }

    public void gotCancel() {
        boolean goBack = true;
        if (SystemProperty.getInstance().isConfirmationsEnabled()) {
            goBack = Dialogs.displayChoiceDialog((String)"Are you sure you want to cancel?", (String)"Cancel?", (boolean)true);
        }
        if (goBack) {
            this.back.emit();
        }
    }

    void gotDate(Date value) {
        this.date = value;
        this.updateGui();
    }

    void gotTime(Time value) {
        this.time = new Date(value.getTime());
        this.updateGui();
    }

    void gotTable(TableGroup newSection) {
        this.section = newSection;
        this.updateGui();
    }

    public void gotTableNames(LogicalTable table) {
        this.tables = LogicalTableQueries.getTableNames((LogicalTable)table);
        this.section = table.getTableGroup();
        this.updateGui();
    }

    void gotPatrons(Integer value) {
        this.patrons = value;
        this.updateGui();
    }

    void gotComments(String value) {
        this.comments = value;
        this.updateGui();
    }

    void gotConfirm() {
        boolean result = Dialogs.displayChoiceDialog((String)"Confirm this reservation?", (String)"Confirm Reservation?", (boolean)false);
        if (result) {
            this.existingReservation.setReservationState("CONFIRMED");
            this.existingReservation.save();
            TerminalEventLog.logReservationConfirmed((Reservation)this.existingReservation, (EventContext)LoginManager.getEventContext());
            this.back.emit();
        }
    }

    public void gotPartyArrived() {
        boolean result = Dialogs.displayChoiceDialog((String)"Confirm that the party has arrived?", (String)"Party Arrived?", (boolean)false);
        if (result) {
            if (this.arriver != null) {
                this.arriver.destroy();
            }
            this.arriver = new WMReservationArriver(this.existingReservation);
            this.arriver.done.connect((Object)this, "gotArriveDone");
            this.arriver.arriveParty();
        }
    }

    public void gotArriveDone() {
        if (this.arriver != null) {
            this.arriver.destroy();
            this.arriver = null;
        }
        this.display();
    }

    public void gotDelete() {
        boolean result = Dialogs.displayChoiceDialog((String)"Are you sure you want to delete this reservation?", (String)"Delete Reservation?", (boolean)false);
        if (result) {
            this.existingReservation.deleteReservation();
            this.existingReservation.save();
            TerminalEventLog.logReservationDeleted((Reservation)this.existingReservation, (EventContext)LoginManager.getEventContext());
            this.gui.enableButtons(false);
            this.back.emit();
        }
    }

    public void gotOK() {
        this.saveReservation();
    }

    public void gotBack() {
        this.back.emit();
    }

    public void gotEditCustomer() {
        if (this.theCustomer != null) {
            if (this.addCustomerState == null) {
                this.addCustomerState = new AddCustomer();
                this.addCustomerState.back.connect((Object)this, "display");
                this.addCustomerState.customerSaved.connect((Object)this, "gotCustomerSaved");
            }
            this.addCustomerState.edit(this.theCustomer);
        }
    }

    public void gotCustomerSaved(Customer customer) {
        OrderMate.LOG.info("Finished editing customer in Reservations:" + customer);
        this.display();
    }

    public void gotShowSalesHistory() {
        SalesHistoryPanel.displayDialog(this.salesHistoryPanel, this.theCustomer);
    }

    public void gotResDiaryInfo() {
        if (this.existingReservation != null && this.existingReservation.getExternalId() != null) {
            if (this.rdBookingSummary == null) {
                this.rdBookingSummary = new RDBookingSummary(this.existingReservation.getExternalId() == null ? null : Long.valueOf(this.existingReservation.getExternalId()));
            }
            if (this.rdBookingSummary.isValid()) {
                RDBookingView rdBookingView = new RDBookingView(this.rdBookingSummary);
                rdBookingView.displayDialog();
            } else {
                Dialogs.displayOkDialog((String)"Unable to get ResDiary booking information", (String)"ResDiary Connection Problem");
            }
        }
    }
}

