/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public class AccountNavBar
extends NavBar {
    private StandardSecurityDecorator quickTransferButton;
    public final Signal quickTransfer = Signals.createSignal();
    public final Signal createNew = Signals.createSignal();
    protected JButton create;

    public AccountNavBar() {
        this.setupComponents();
    }

    public AccountNavBar(String newOrderButtonText, String newOrderButtonIcon) {
        this.setupComponents();
        this.create.setText(newOrderButtonText);
        this.create.setIcon(IconLoader.get((String)newOrderButtonIcon));
    }

    protected void setupComponents() {
        this.create = this.constructButton(IconLoader.get((String)"/waitermate/images/takeaway.png"), "New Order", "createOrder", this.createNew);
        JButton quickTransferJButton = this.constructButton(IconLoader.get((String)"/waitermate/images/transfer.png"), "Quick Transfer", "quickTransfer", this.quickTransfer);
        this.quickTransferButton = new StandardSecurityDecorator((JComponent)quickTransferJButton, AllPermissions.TRANSFER_ITEMS);
        this.addRight(this.create);
        if (!Terminal.getLocalHost().hasQuickSale() || Terminal.getLocalHost().hasTableMode() || Terminal.getLocalHost().hasTakeawayMode() || Terminal.getLocalHost().hasDriveThruMode() || Terminal.getLocalHost().hasDebtorsMode() || Terminal.getLocalHost().hasPhoneMode() || Terminal.getLocalHost().hasBarTabsMode()) {
            this.addRight((Component)this.quickTransferButton);
        }
    }

    public void setQuickTransferVisible(boolean value) {
        if (this.quickTransferButton != null) {
            this.quickTransferButton.setVisible(value);
        }
    }

    public void setCreateNewVisible(boolean visible) {
        this.create.setVisible(visible);
    }

    public AbstractButton getCreateNew() {
        return this.create;
    }
}

