/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.control.SearchControl;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.futureorder.FutureOrderManager;
import ordermate.futureorder.FutureOrderQueries;
import ordermate.gui.DisplayableObjectWrapper;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DrawerToggleButton;
import waitermate.guikit.components.SelectableToggleDrawerPanel;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.search.searchfield.WaitermateDateRangePanel;
import waitermate.guikit.search.searchfield.WaitermateDateRangeSearchField;
import waitermate.guikit.search.searchfield.WaitermateMultiSelectToggleButtonDialogSearchField;

public class AccountSearchControl
implements SearchControl<Account> {
    private AccountSearcher searcher;
    private RefreshAction refresh;
    private JPanel searchPanel;
    private JPanel mainSearchPanel;
    private JPanel footerSearchPanel;
    private List<SearchGuiField> allFields;
    private List<AccountType> accountTypes;
    private WaitermateDateRangeSearchField dateField;
    private JButton clearFilters;
    private JButton printButton;
    private SelectableToggleDrawerPanel sortDrawer;
    private final JCheckBox ascendingCheck;

    public AccountSearchControl(Refreshable parentPanel, AccountType ... types) {
        this.accountTypes = Arrays.asList(types);
        this.searcher = this.constructSearcher();
        this.refresh = new RefreshAction(parentPanel);
        this.searchPanel = new JPanel(new BorderLayout());
        this.searchPanel.setBorder(new TitledBorder("Search Fields"));
        this.mainSearchPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(1, 6), 3, 3));
        this.footerSearchPanel = new JPanel();
        this.footerSearchPanel.setLayout(new BoxLayout(this.footerSearchPanel, 0));
        this.searchPanel.add((Component)this.mainSearchPanel, "Center");
        this.searchPanel.add((Component)this.footerSearchPanel, "South");
        this.allFields = new ArrayList<SearchGuiField>();
        this.dateField = new WaitermateDateRangeSearchField("Date Range:", (IRangedSearchFilter)this.searcher.getDateDueRangeSearch(), Calendar.getInstance().getTime(), (Action)this.refresh, new WaitermateDateRangePanel(Calendar.getInstance(), Calendar.getInstance(), "Start Date:", "End Date:", this.refresh));
        this.ascendingCheck = new JCheckBox("Ascending?");
        OrderMateTheme.setupTransparentButton((AbstractButton)this.ascendingCheck);
        this.ascendingCheck.setName("ascendingCheck");
        this.ascendingCheck.setIcon(IconLoader.get((String)"/waitermate/images/cancel32.png"));
        this.ascendingCheck.setSelectedIcon(IconLoader.get((String)"/waitermate/images/ok32.png"));
        this.ascendingCheck.setSelected(true);
        this.ascendingCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountSearchControl.this.searcher.setOrderAscending(AccountSearchControl.this.ascendingCheck.isSelected());
                AccountSearchControl.this.sortBy();
            }
        });
        this.setupSearchComponents(this.searcher, this.refresh);
    }

    public WaitermateDateRangeSearchField getDateField() {
        return this.dateField;
    }

    protected List<AccountType> getTypes() {
        return this.accountTypes;
    }

    protected AccountSearcher constructSearcher() {
        this.searcher = new AccountSearcher();
        this.searcher.setAccountOpen(true);
        this.searcher.getAccountTypeListSearch().setSearchOptions(this.getTypes());
        return this.searcher;
    }

    protected void setupSearchComponents(AccountSearcher searcher, RefreshAction refresh) {
        WaitermateDateRangePanel.QueryTypeWithDatePropertyFlagStrategy flagStrategy = new WaitermateDateRangePanel.QueryTypeWithDatePropertyFlagStrategy(Account.class, Account.Properties.DATE_DUE, FutureOrderQueries.getAllAccountsWithADueDateQuery(this.getTypes()));
        this.dateField.getDateRangePanel().setFlagStrategy((WaitermateDateRangePanel.FlaggedDateStrategy)flagStrategy);
        this.dateField.useFixedDates();
        WaitermateMultiSelectToggleButtonDialogSearchField accountTypeField = new WaitermateMultiSelectToggleButtonDialogSearchField("Account Type:", searcher.getAccountTypeListSearch(), GlazedLists.eventList(this.getTypes()), (Action)refresh);
        this.addSearchGuiField((SearchGuiField)this.dateField, new Rectangle(0, 0, 1, 3));
        this.addSearchGuiField((SearchGuiField)accountTypeField, new Rectangle(0, 3, 1, 1));
        this.clearFilters = this.setupClearButton(refresh);
        this.printButton = this.setupPrintButton(searcher);
        this.addToFooterPanel(this.clearFilters);
        this.addToFooterPanel(this.printButton);
    }

    protected void addSearchGuiField(SearchGuiField guiField, Rectangle position) {
        this.allFields.add(guiField);
        this.mainSearchPanel.add(guiField.getGuiComponent(), position);
    }

    protected void addToFooterPanel(JComponent toAdd) {
        this.footerSearchPanel.add(toAdd);
    }

    public List<Account> getObjectList() {
        return this.getSearcher().search();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        List<SearchGuiField> list = this.allFields;
        synchronized (list) {
            for (SearchGuiField element : this.allFields) {
                SearchGuiField searchField = element;
                if (searchField instanceof WaitermateDateRangeSearchField) {
                    searchField.getSearchProperty();
                }
                if (!searchField.getGuiComponent().isEnabled()) continue;
                this.getSearcher().addSearchFilter(searchField.getSearchProperty());
            }
        }
    }

    public void resetSearch() {
        this.searcher.setActive(false);
        Iterator<SearchGuiField> iterator = this.allFields.iterator();
        while (iterator.hasNext()) {
            SearchGuiField element;
            SearchGuiField searchField = element = iterator.next();
            searchField.reset();
        }
        this.ascendingCheck.setSelected(true);
        this.searcher.clearSearchFilterValues();
        this.searcher.getAccountTypeListSearch().setSearchOptions(this.accountTypes);
        this.searcher.setActive(true);
        this.updateSearcher(this.searcher);
        this.refresh.doRefresh();
    }

    protected void updateSearcher(AccountSearcher searcher) {
        searcher.setAccountOpen(true);
    }

    public PropertySearcher<Account> getSearcher() {
        return this.searcher;
    }

    public JPanel getSearchPanel() {
        return this.searchPanel;
    }

    public RefreshAction getRefresh() {
        return this.refresh;
    }

    public DrawerToggleButton constructSortButton(NavBar nav) {
        DrawerToggleButton sortButton = nav.constructDrawerToggleButton("Sort", IconLoader.get((String)"/waitermate/images/atoz.png"), IconLoader.get((String)"/waitermate/images/atoz.png"));
        ArrayList<DisplayableObjectWrapper> properties = new ArrayList<DisplayableObjectWrapper>();
        properties.add(new DisplayableObjectWrapper((Object)Account.Properties.CREATION_DATE_TIME, "Time Created"));
        properties.add(new DisplayableObjectWrapper((Object)new PropertiedObject.Property[]{Account.Properties.DATE_DUE, Account.Properties.TIME_DUE}, "Time Due"));
        properties.add(new DisplayableObjectWrapper((Object)new PropertiedObject.Property[]{Customer.Properties.FIRST_NAME, Customer.Properties.LAST_NAME}, "First Name"));
        this.sortDrawer = new SelectableToggleDrawerPanel(properties, DisplayableObjectWrapper.class, true){

            protected JComponent getBottomComponent() {
                return AccountSearchControl.this.ascendingCheck;
            }
        };
        this.sortDrawer.setTitle("<HTML><FONT SIZE='+1'>Order Accounts:</FONT></HTML>");
        this.sortDrawer.changed.connect((Object)this, "sortBy");
        sortButton.setDrawer((JComponent)this.sortDrawer);
        return sortButton;
    }

    public void sortBy() {
        PropertiedObject.Property[] properties;
        List selections = this.sortDrawer.getSelectedObjects();
        if (selections == null || selections.size() == 0) {
            properties = new PropertiedObject.Property[]{Account.Properties.CREATION_DATE_TIME};
        } else {
            ArrayList<PropertiedObject.Property> selectedProperties = new ArrayList<PropertiedObject.Property>();
            for (Object selection : selections) {
                DisplayableObjectWrapper wrapper = (DisplayableObjectWrapper)selection;
                Object payload = wrapper.getWrappedObject();
                if (payload == null) continue;
                if (payload instanceof PropertiedObject.Property) {
                    selectedProperties.add((PropertiedObject.Property)payload);
                    continue;
                }
                if (!(payload instanceof PropertiedObject.Property[])) continue;
                for (PropertiedObject.Property nextProperty : (PropertiedObject.Property[])payload) {
                    selectedProperties.add(nextProperty);
                }
            }
            properties = selectedProperties.toArray(new PropertiedObject.Property[selectedProperties.size()]);
        }
        this.searcher.setOrderAscending(this.ascendingCheck.isSelected());
        this.searcher.setOrderByProps(properties);
        this.refresh.actionPerformed(new ActionEvent(this, 1, "refresh"));
    }

    private JButton setupPrintButton(final AccountSearcher searcher) {
        JButton toReturn = new JButton((Action)new BasicAction("Print", IconLoader.get((String)"/waitermate/guikit/images/print.png")){

            public void actionPerformed(ActionEvent e) {
                VirtualPrinter vp = AccountSearchControl.this.getDocketPrinters();
                if (vp != null) {
                    ProgressDialog.doProgressDialog((Task)FutureOrderManager.getInstance().createPrintTask(searcher, vp));
                } else {
                    Dialogs.displayOkDialog((String)"No Receipt Printer is attached. Please configure first.", (String)"No Receipt Printer");
                }
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)toReturn);
        return toReturn;
    }

    private JButton setupClearButton(RefreshAction refresh) {
        this.clearFilters = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(AccountSearchControl.this.clearFilters)) {
                    AccountSearchControl.this.gotClearFilters();
                }
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)this.clearFilters);
        this.clearFilters.setIcon(IconLoader.get((String)"/waitermate/guikit/images/clear.png"));
        this.clearFilters.setText("Clear Filters");
        this.clearFilters.addActionListener((ActionListener)refresh);
        return this.clearFilters;
    }

    protected VirtualPrinter getDocketPrinters() {
        ArrayList<VirtualPrinter> printerSet = new ArrayList<VirtualPrinter>();
        printerSet.addAll(Terminal.getLocalHost().getAvaliableWindowsReceiptPrinters());
        if (printerSet.size() > 1) {
            List buttons = AbstractScrollPaneModel.constructButtons(printerSet);
            OnePressPopupWindow printerDialog = new OnePressPopupWindow("Select Receipt Printer", (Collection)buttons, 1, 3, false);
            CustomButton selectedButton = (CustomButton)printerDialog.start();
            VirtualPrinter selectedPrinter = (VirtualPrinter)selectedButton.getData();
            printerSet.clear();
            printerSet.add(selectedPrinter);
        } else if (printerSet.isEmpty()) {
            return null;
        }
        return (VirtualPrinter)printerSet.get(0);
    }

    private void gotClearFilters() {
        this.resetSearch();
    }
}

