/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.reports.general.NumberReport;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class OnlineAccountSniffer
extends TimerTask {
    public final Signal<Long, ?, ?, ?, ?> onlineAccountWaiting = Signals.createSignal(Long.class, (String)"numWaiting");
    private static final String SQL = "SELECT COUNT(*) as value FROM sales_account JOIN finance_trading_day fday on fday.id = sales_account.fk_finance_trading_day WHERE sales_account.acc_class = 'ONLINE' AND fday.day > DATE_SUB(NOW(), interval 3 day) AND ((sales_account.acknowledged_time IS NULL && sales_account.account_state='OPEN') OR (ext_paid_flag = 1 AND sales_account.eta IS NULL))";
    private int lastValue = -1;
    private boolean alwaysNotify = false;

    public OnlineAccountSniffer() {
        ExperimentalFeature feature = ExperimentalFeature.find((String)"Online Orders Always Notify");
        if (feature != null) {
            this.alwaysNotify = feature.getBooleanValue(Boolean.FALSE);
        }
    }

    @Override
    public void run() {
        try {
            NumberReport report = (NumberReport)PersistenceManager.getObject(NumberReport.class, (String)SQL, null);
            if (report != null && (this.alwaysNotify || this.lastValue != report.intValue())) {
                this.onlineAccountWaiting.emit((Object)report.getValue());
                this.lastValue = report.intValue();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read from PersistenceManager for OnlineAccountSniffer.");
        }
    }
}

