/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.online;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.sales.Account;
import ordermate.database.sales.OnlineAccount;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.AccountSearchControl;
import waitermate.gui.screens.selectaccount.online.OnlineAccountRenderer;
import waitermate.gui.screens.selectaccount.online.OnlineAccountSearchControl;

public class OnlineAccountPanel
extends JPanel
implements Refreshable {
    public Signal selectedAccount = Signals.createSignal(Account.class, (String)"selected");
    public final String tabName = "Online";
    private static final int ACCOUNT_PANEL_ROWS = 5;
    private static final int ACCOUNT_PANEL_COLS = 3;
    private RendererScrollPaneModel<OnlineAccount> accounts;
    private CustomScrollPane accountsPane;
    private AccountSearchControl searchControl;
    private static final long SPAM_REFRESH_BLOCK = 2000L;
    private long lastRefresh = 0L;

    public OnlineAccountPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(4, 1), 0, 0));
        OnlineAccountRenderer renderer = new OnlineAccountRenderer();
        renderer.selected.connect((Object)this, "gotSelected");
        this.accounts = new RendererScrollPaneModel((Renderer)renderer, 3, 5);
        OnlineAccountSearchControl onlineAccountSearchControl = new OnlineAccountSearchControl(this);
        onlineAccountSearchControl.setIgnoreDeliverable(!SystemProperty.getInstance().canAssignDriver(DriverAssignmentSettlementType.ONLINE));
        this.searchControl = onlineAccountSearchControl;
        this.accountsPane = new CustomScrollPane(this.accounts);
        this.accountsPane.setEmptyMessage("There are no Online orders");
        this.add((Component)this.searchControl.getSearchPanel(), new Rectangle(0, 0, 1, 1));
        this.add((Component)this.accountsPane, new Rectangle(1, 0, 3, 1));
    }

    public void gotSelected(Displayable obj) {
        this.selectedAccount.emit((Object)obj);
    }

    public AccountSearchControl getSearchControl() {
        return this.searchControl;
    }

    public void refresh() {
        if (System.currentTimeMillis() - this.lastRefresh < 2000L) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.searchControl.refresh();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List accountSearchResults = OnlineAccountPanel.this.searchControl.getSearcher().search();
                final ArrayList<OnlineAccount> toSetOnScrollPane = new ArrayList<OnlineAccount>();
                for (Account acc : accountSearchResults) {
                    if (!(acc instanceof OnlineAccount)) continue;
                    toSetOnScrollPane.add((OnlineAccount)acc);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (OnlineAccountPanel.this.isShowing()) {
                            OnlineAccountPanel.this.accounts.setObjects(toSetOnScrollPane);
                        }
                        OnlineAccountPanel.this.lastRefresh = System.currentTimeMillis();
                    }
                });
            }
        };
        new Thread(runnable).start();
    }
}

