/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.online;

import au.com.ordermate.gui.CompositeIconGenerator;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import ordermate.OrderMate;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import waitermate.gui.screens.selectaccount.online.OnlineAccountSourceIconFactory;
import waitermate.gui.screens.selectaccount.phone.PhoneAccountRenderer;

public class OnlineAccountRenderer
extends DisplayableRenderer {
    private final PhoneAccountRenderer renderer = new PhoneAccountRenderer(){

        @Override
        protected void insertHTML(StringBuilder SB, PhoneAccount account) {
            super.insertHTML(SB, account);
            String source = account.getExtOrigin();
            if (StringUtils.isEmpty((String)source)) {
                source = account.getSource();
            }
            SB.append("<br>");
            if (StringUtils.isEmpty((String)source)) {
                source = "Total";
            }
            SB.append(source).append(" ").append(account.getSavedTotal().toString(true));
        }

        @Override
        protected ImageIcon getIcon(PhoneAccount account) {
            String source = ((OnlineAccount)account).getSource();
            if (source == null || source.isEmpty()) {
                return super.getIcon(account);
            }
            int ICON_SIZE = 25;
            String typeIcon = ((OnlineAccount)account).getLogicalTable() != null ? "/waitermate/images/tableMicro.png" : (account.isDeliverable() ? "/waitermate/images/house-small.png" : "/waitermate/images/phone-small.png");
            source = source.toLowerCase();
            String sourceIcon = null;
            OnlineAccountSourceIconFactory factory = new OnlineAccountSourceIconFactory();
            sourceIcon = factory.getIconName(source);
            CompositeIconGenerator generator = new CompositeIconGenerator(25, 1);
            generator.setIconHeight(25);
            if (sourceIcon == null) {
                OrderMate.LOG.warn("Cannot apply Icon for unknown online source:" + source);
            } else {
                generator.addIcon(sourceIcon);
            }
            generator.addIcon(typeIcon);
            return IconLoader.get((String)generator.generateIcon());
        }
    };
    private final WeakHashMap<CustomButton<OnlineAccount>, ?> createdButtons = new WeakHashMap();
    private static final Color TOGGLE_ON = new Color(0, 255, 0);
    private static final Color TOGGLE_OFF = new Color(255, 0, 0);

    public OnlineAccountRenderer() {
        new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet buttonSet = new HashSet(OnlineAccountRenderer.this.createdButtons.keySet());
                for (CustomButton button : buttonSet) {
                    OnlineAccount account = (OnlineAccount)button.getData();
                    if (account.isAcknowledged() && account.getEta() != null) {
                        if (button.getBackground() != TOGGLE_ON && button.getBackground() != TOGGLE_OFF) continue;
                        button.setBackground(null);
                        continue;
                    }
                    Color color = button.getBackground() == TOGGLE_ON ? TOGGLE_OFF : TOGGLE_ON;
                    button.setBackground(color);
                }
            }
        }).start();
    }

    public void setupComponent(Component component, Object object, int index) {
        this.renderer.setupComponent(component, object, index);
        this.createdButtons.put((CustomButton<OnlineAccount>)((CustomButton)component), null);
    }
}

