/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.online;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.searchers.sales.OnlineDueDateAccountSearcher;
import ordermate.futureorder.FutureOrderManager;
import ordermate.futureorder.FutureOrderQueries;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.selectaccount.AccountSearchControl;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.search.searchfield.WaitermateDateRangePanel;
import waitermate.guikit.search.searchfield.WaitermateMultiSelectToggleButtonDialogSearchField;

public class OnlineAccountSearchControl
extends AccountSearchControl {
    private JButton clearFilters;
    private JButton printButton;
    WaitermateMultiSelectToggleButtonDialogSearchField accountTypeField;
    private boolean ignoreDeliverable;

    public OnlineAccountSearchControl(Refreshable parentPanel) {
        super(parentPanel, new AccountType[0]);
    }

    public void setIgnoreDeliverable(boolean value) {
        this.ignoreDeliverable = value;
    }

    @Override
    protected AccountSearcher constructSearcher() {
        OnlineDueDateAccountSearcher searcher = new OnlineDueDateAccountSearcher(){

            public ObjectQuery getBaseQuery() {
                ObjectQuery query = super.getBaseQuery();
                if (OnlineAccountSearchControl.this.ignoreDeliverable) {
                    query.group().equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).or().isNull(OnlineAccount.Properties.ETA).endGroup();
                } else {
                    query.group().group().equals(OnlineAccount.Properties.DELIVERABLE, (Object)Boolean.FALSE).group().equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).or().isNull(OnlineAccount.Properties.ETA).endGroup().endGroup().or().group().equals(OnlineAccount.Properties.DELIVERABLE, (Object)Boolean.TRUE).equals(OnlineAccount.Properties.DELIVERED, (Object)Boolean.FALSE).isNull(OnlineAccount.Properties.DELIVERY).endGroup().endGroup();
                }
                return query;
            }
        };
        searcher.getAccountTypeListSearch().setSearchOptions(Arrays.asList(AccountType.onlineDeliveryType, AccountType.onlineTableType, AccountType.onlinePickupType));
        return searcher;
    }

    @Override
    protected void setupSearchComponents(AccountSearcher searcher, RefreshAction refresh) {
        this.getDateField().getDateRangePanel().setFlagStrategy((WaitermateDateRangePanel.FlaggedDateStrategy)new WaitermateDateRangePanel.QueryTypeWithDatePropertyFlagStrategy(Account.class, Account.Properties.DATE_DUE, FutureOrderQueries.getAllAccountsWithADueDateQuery((AccountType[])new AccountType[]{AccountType.onlineDeliveryType, AccountType.onlinePickupType})));
        this.getDateField().useFixedDates();
        this.accountTypeField = new WaitermateMultiSelectToggleButtonDialogSearchField("Account Type:", searcher.getAccountTypeListSearch(), GlazedLists.eventListOf((Object[])new AccountType[]{AccountType.onlineDeliveryType, AccountType.onlineTableType, AccountType.onlinePickupType}), (Action)refresh);
        this.addSearchGuiField((SearchGuiField)this.getDateField(), new Rectangle(0, 0, 1, 3));
        this.addSearchGuiField((SearchGuiField)this.accountTypeField, new Rectangle(0, 3, 1, 1));
        this.clearFilters = this.setupClearButton(refresh);
        this.printButton = this.setupPrintButton(searcher);
        this.addToFooterPanel(this.clearFilters);
        this.addToFooterPanel(this.printButton);
    }

    private JButton setupPrintButton(final AccountSearcher searcher) {
        JButton toReturn = new JButton((Action)new BasicAction("Print", IconLoader.get((String)"/waitermate/guikit/images/print.png")){

            public void actionPerformed(ActionEvent e) {
                VirtualPrinter vp = OnlineAccountSearchControl.this.getDocketPrinters();
                ProgressDialog.doProgressDialog((Task)FutureOrderManager.getInstance().createPrintTask(searcher, vp));
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)toReturn);
        return toReturn;
    }

    private JButton setupClearButton(RefreshAction refresh) {
        this.clearFilters = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(OnlineAccountSearchControl.this.clearFilters)) {
                    OnlineAccountSearchControl.this.gotClearFilters();
                }
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)this.clearFilters);
        this.clearFilters.setIcon(IconLoader.get((String)"/waitermate/guikit/images/clear.png"));
        this.clearFilters.setText("Clear Filters");
        this.clearFilters.addActionListener((ActionListener)refresh);
        return this.clearFilters;
    }

    private void gotClearFilters() {
        AccountSearcher searcher = (AccountSearcher)this.getSearcher();
        searcher.setActive(false);
        this.getDateField().reset();
        this.accountTypeField.reset();
        searcher.setActive(true);
        this.refresh();
    }
}

