/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.online;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.OnlineAccount;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.AbstractAccountSelection;
import waitermate.gui.screens.selectaccount.online.OnlineAccountPanel;
import waitermate.gui.screens.selectaccount.phone.PhoneNav;
import waitermate.gui.screens.selectaccount.phone.drivers.DriversScreen;
import waitermate.gui.screens.selectaccount.takeaway.ScreenRefreshThread;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DrawerToggleButton;

public class OnlineAccountSelection
extends AbstractAccountSelection
implements Refreshable {
    private final PhoneNav nav;
    private OnlineAccountPanel onlineAccountPanel;
    private final Signal<Account, ?, ?, ?, ?> driversAccountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    private final Signal driversBack = Signals.createSignal();
    private ScreenRefreshThread refreshThread;
    private static final int REFRESH_INTERVAL = 5000;

    public OnlineAccountSelection() {
        this.onlineAccountPanel = new OnlineAccountPanel();
        this.onlineAccountPanel.selectedAccount.connect((Object)this, "gotAccount");
        this.nav = new PhoneNav(Terminal.getLocalHost().hasDeliveryMode(), DriverAssignmentSettlementType.ONLINE);
        this.nav.setCreateDeliveryVisible(false);
        this.nav.setCreateNewVisible(false);
        this.driversAccountSelected.connect((Object)this, "gotAccount");
        this.driversBack.connect((Object)this, "display");
        DrawerToggleButton sortButton = this.onlineAccountPanel.getSearchControl().constructSortButton(this.nav);
        this.nav.addLeft((Component)sortButton);
        this.nav.drivers.connect((Object)this, "gotViewDrivers");
    }

    @Override
    protected List<AccountType> getAccountTypes() {
        return Arrays.asList(AccountType.onlineDeliveryType, AccountType.onlinePickupType);
    }

    public JComponent getMainArea() {
        return this.onlineAccountPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotAccount(Account account) {
        if (account instanceof OnlineAccount) {
            ((OnlineAccount)account).acknowledge();
        }
        this.accountSelected.emit((Object)account);
    }

    public void gotAccount(Displayable account) {
        this.gotAccount((Account)account);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.onlineAccountPanel.getSearchControl().getDateField().getFixedDatesPanel().refreshRangePanel();
        this.refresh();
        if (this.refreshThread == null) {
            this.refreshThread = new ScreenRefreshThread(this, 5000);
        }
    }

    public void tearDown() {
        super.tearDown();
        if (this.refreshThread != null) {
            this.refreshThread.stop();
            this.refreshThread = null;
        }
    }

    public synchronized void refresh() {
        this.onlineAccountPanel.refresh();
    }

    void gotViewDrivers() {
        DriversScreen.getDriversScreen().start(this.driversAccountSelected, this.driversBack);
    }
}

