/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone;

import au.com.ordermate.OrderMateLog;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.callerid.Call;

public class CallerIDButton
extends JButton {
    private static final int STATUS_NOT_RINGING = 1;
    private static final int STATUS_RINGING = 2;
    private static final Color RINGING_ON = new Color(0, 255, 0);
    private static final Color RINGING_OFF = new Color(255, 0, 0);
    private String name;
    private int buttonStatus;
    private ButtonFlasher flasher;
    private Call theCall;

    public CallerIDButton(String buttonName) {
        super(buttonName);
        this.name = buttonName;
        this.flasher = new ButtonFlasher(this);
    }

    public void setStatusRinging(Call call) {
        this.flasher.stopThread();
        this.setEnabled(true);
        this.theCall = call;
        this.setText("<html>" + this.name + "<br>" + this.theCall.getPhoneNumber() + "<br>" + this.theCall.getCustomerName());
        this.buttonStatus = 2;
        this.flasher.startThread();
    }

    public void setStatusNotRinging() {
        this.setEnabled(false);
        this.setText(this.name);
        this.buttonStatus = 1;
        this.theCall = null;
        this.flasher.stopThread();
        this.setBackground(null);
    }

    public boolean isRinging() {
        return this.buttonStatus == 2;
    }

    public Call getCall() {
        return this.theCall;
    }

    public static class ButtonFlasher
    implements Runnable {
        private static final int DEF_MAX = 150;
        private Thread t;
        private int counter;
        private int maxCounter = 150;
        private boolean keepThreadGoing;
        private CallerIDButton theButton;

        public ButtonFlasher(CallerIDButton button) {
            this.theButton = button;
        }

        public void startThread() {
            this.keepThreadGoing = true;
            this.resetCounter();
            if (this.t == null) {
                this.t = new Thread(this);
                this.t.setPriority(1);
                this.t.setName("Flashing thread");
                this.t.start();
            }
        }

        public void stopThread() {
            this.keepThreadGoing = false;
        }

        @Override
        public void run() {
            while (this.counter < this.maxCounter && this.keepThreadGoing) {
                this.updateColor(this.counter);
                ++this.counter;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    OrderMateLog.LOG.error("Run thread error", (Throwable)e);
                }
            }
            this.t = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    theButton.setStatusNotRinging();
                }
            });
        }

        private void updateColor(final int flashCount) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (flashCount % 2 == 0) {
                        theButton.setBackground(RINGING_ON);
                    } else {
                        theButton.setBackground(RINGING_OFF);
                    }
                }
            });
        }

        private void resetCounter() {
            this.counter = 0;
            Terminal currentTerminal = Terminal.getLocalHostIfAvailable();
            this.maxCounter = currentTerminal != null && currentTerminal != Terminal.getServerMateTerminal() && currentTerminal.getCustomButtonFlashTime() > 0 ? currentTerminal.getCustomButtonFlashTime() : 150;
        }
    }
}

