/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PhoneAccount;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.dialogs.PhoneDeliveryTypeDialog;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.selectaccount.AbstractAccountSelection;
import waitermate.gui.screens.selectaccount.phone.CallerIDButton;
import waitermate.gui.screens.selectaccount.phone.PhoneAccountSearchControl;
import waitermate.gui.screens.selectaccount.phone.PhoneNav;
import waitermate.gui.screens.selectaccount.phone.PhoneSelectionPanel;
import waitermate.gui.screens.selectaccount.phone.drivers.DriversScreen;
import waitermate.gui.screens.selectaccount.takeaway.ScreenRefreshThread;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DrawerToggleButton;

public class PhoneSelection
extends AbstractAccountSelection
implements Refreshable {
    public final String tabName = "Phone";
    private PhoneSelectionPanel gui;
    private PhoneNav nav;
    private PhoneAccountSearchControl searchControl;
    private JPanel mainArea;
    private final Signal driversAccountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    private final Signal driversBack = Signals.createSignal();
    private ScreenRefreshThread refreshThread;
    private static final int REFRESH_INTERVAL = 5000;
    private static final long SPAM_REFRESH_BLOCK = 5000L;
    private long lastRefresh = 0L;

    public PhoneSelection(boolean withDelivery) {
        this.gui = new PhoneSelectionPanel();
        this.gui.accountSelected.connect((Object)this, "gotAccount");
        this.gui.buttonClicked.connect((Object)this, "buttonClicked");
        this.searchControl = new PhoneAccountSearchControl(this);
        this.nav = new PhoneNav(withDelivery);
        this.nav.createNew.connect((Object)this, "gotCreateNewPhoneAccount");
        this.nav.createNewDelivery.connect((Object)this, "gotCreateNewDeliveryAccount");
        this.nav.drivers.connect((Object)this, "gotViewDrivers");
        this.setupNavForQuickTransfer(this.nav);
        this.mainArea = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(4, 1), 0, 0));
        this.mainArea.add((Component)this.searchControl.getSearchPanel(), new Rectangle(0, 0, 1, 1));
        this.mainArea.add((Component)this.gui, new Rectangle(1, 0, 3, 1));
        if (Terminal.getLocalHost().getAvailableCallerIDUnit() != null) {
            CallerIDUnit.getUnit().callDetected.connect((Object)this.gui, "startFlashButtons");
            CallerIDUnit.getUnit().callPickedUp.connect((Object)this.gui, "stopFlashButtons");
        }
        if (withDelivery) {
            this.driversAccountSelected.connect((Object)this, "selectAccount");
            this.driversBack.connect((Object)this, "display");
        }
        DrawerToggleButton sortButton = this.searchControl.constructSortButton(this.nav);
        this.nav.addLeft((Component)sortButton);
    }

    protected void gotAccount(Account account) {
        PhoneAccount phoneAccount = (PhoneAccount)account;
        if (account.isPersistent()) {
            phoneAccount = (PhoneAccount)PersistenceManager.reacquire((PersistentObjectI)account);
        }
        if (phoneAccount == null) {
            OrderMate.LOG.error("Reacquired " + account + " but no longer exists.");
            return;
        }
        if (phoneAccount.isOpen() || phoneAccount.isDeliverable() && !phoneAccount.isDelivered()) {
            this.accountSelected.emit((Object)phoneAccount);
        } else {
            OrderMate.LOG.warn(account + " is not open, or has already been delivered");
        }
    }

    @Override
    public void setUp() {
        super.setUp();
        this.searchControl.getDateField().getFixedDatesPanel().refreshRangePanel();
        this.refreshNoSpam();
        Refreshable unspammableRefresher = new Refreshable(){

            public void refresh() {
                PhoneSelection.this.refreshNoSpam();
            }
        };
        if (this.refreshThread == null) {
            this.refreshThread = new ScreenRefreshThread(unspammableRefresher, 5000);
        }
    }

    public void tearDown() {
        super.tearDown();
        if (this.refreshThread != null) {
            this.refreshThread.stop();
            this.refreshThread = null;
        }
    }

    public void refreshNoSpam() {
        if (System.currentTimeMillis() - this.lastRefresh < 5000L) {
            return;
        }
        this.refresh();
    }

    public void refresh() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.searchControl.refresh();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List accounts = PhoneSelection.this.searchControl.getSearcher().search();
                int unassignCount = 0;
                final ArrayList<PhoneAccount> phAccounts = new ArrayList<PhoneAccount>();
                for (Account account : accounts) {
                    if (account instanceof PhoneAccount && ((PhoneAccount)account).isDeliverable() && !((PhoneAccount)account).hasDelivery()) {
                        ++unassignCount;
                    }
                    phAccounts.add((PhoneAccount)account);
                }
                final int unassigned = unassignCount;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PhoneSelection.this.gui.isShowing()) {
                            PhoneSelection.this.nav.setNumUnassignedAccounts(unassigned);
                            PhoneSelection.this.gui.setAccounts(phAccounts);
                        }
                        PhoneSelection.this.lastRefresh = System.currentTimeMillis();
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public JComponent getMainArea() {
        return this.mainArea;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void selectAccount(Displayable selected) {
        this.selectAccount((Account)selected);
    }

    public void selectAccount(Account account) {
        this.accountSelected.emit((Object)account);
    }

    void gotCreateNewPhoneAccount() {
        PhoneAccount account = new PhoneAccount(LoginManager.getEventContext());
        this.accountSelected.emit((Object)account);
    }

    void gotCreateNewDeliveryAccount() {
        EventContext ctx = LoginManager.getEventContext();
        PhoneAccount account = new PhoneAccount(ctx, AccountType.deliveryType);
        account.setDeliverable(true, ctx);
        this.accountSelected.emit((Object)account);
    }

    void gotViewDrivers() {
        DriversScreen.getDriversScreen().start(this.accountSelected, this.driversBack);
    }

    void buttonClicked(CallerIDButton button) {
        if (!button.isRinging()) {
            return;
        }
        int lineNumber = button.getCall().getLineNumber();
        String searchString = StringUtils.removePhoneNumberDashes((String)button.getCall().getPhoneNumber());
        if (searchString.equalsIgnoreCase("")) {
            searchString = BusinessInfo.getInstance().getPhoneAreaCodePrefix();
        }
        PhoneAccount account = new PhoneAccount(LoginManager.getEventContext());
        if (Terminal.getLocalHost().hasDeliveryMode()) {
            boolean isDeliverable = new PhoneDeliveryTypeDialog().isDeliverySelected();
            account.setDeliverable(isDeliverable, LoginManager.getEventContext());
        }
        Customer customer = SelectCustomer.startModal(searchString, account.getCustomerRequirements(), false);
        CallerIDUnit.getUnit().notifyCallPickedUp(lineNumber);
        if (customer != null) {
            account.lock(LoginManager.getInstance().getUser());
            account.setCustomer(customer, LoginManager.getEventContext());
            this.selectAccount((Account)account);
        }
    }

    @Override
    protected List<AccountType> getAccountTypes() {
        return Arrays.asList(AccountType.phoneType, AccountType.deliveryType);
    }

    public PhoneAccountSearchControl getSearchControl() {
        return this.searchControl;
    }
}

