/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.callerid.Call;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;
import ordermate.database.sales.Account;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.phone.CallerIDButton;
import waitermate.gui.screens.selectaccount.phone.PhoneAccountRenderer;

class PhoneSelectionPanel
extends JPanel
implements ActionListener {
    public final Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    public final Signal<CallerIDButton, ?, ?, ?, ?> buttonClicked = Signals.createSignal(CallerIDButton.class, (String)"callerIDButton");
    private CustomScrollPane accountsPane;
    private RendererScrollPaneModel<PhoneAccount> accounts;
    private PhoneAccountRenderer renderer;
    private CallerIDButton[] buttons;

    public PhoneSelectionPanel() {
        Terminal localhost = Terminal.getLocalHost();
        this.setLayout((LayoutManager)new GraphPaperLayout(8, 10));
        this.renderer = new PhoneAccountRenderer();
        if (localhost.getAvailableCallerIDUnit() == null) {
            this.setupNoCallerID();
        } else {
            CallerIDUnit unit = localhost.getAvailableCallerIDUnit();
            this.setupCallerID(unit.getNumberOfLines());
        }
    }

    private void setupNoCallerID() {
        this.renderer.selected.connect((Object)this, "selectAccount");
        this.accounts = new RendererScrollPaneModel((Renderer)this.renderer, 3, 6);
        this.accountsPane = new CustomScrollPane(this.accounts);
        this.accountsPane.setEmptyMessage("There are no phone orders");
        this.add((Component)this.accountsPane, new Rectangle(0, 0, 8, 10));
        this.buttons = new CallerIDButton[0];
    }

    private void setupCallerID(int numButtons) {
        int i;
        this.buttons = new CallerIDButton[numButtons];
        JPanel buttonsPanel = new JPanel();
        if (numButtons <= 4) {
            buttonsPanel.setLayout(new GridLayout(1, 4));
        } else {
            buttonsPanel.setLayout(new GridLayout(1, numButtons));
        }
        CallerIDUnit unit = CallerIDUnit.getUnit();
        for (i = 0; i < unit.getNumberOfLines(); ++i) {
            CallerIDButton button = new CallerIDButton("Line " + (unit.getFirstLineNumber() + i));
            button.addActionListener(this);
            button.setEnabled(false);
            this.buttons[i] = button;
            buttonsPanel.add(button);
        }
        if (numButtons < 4) {
            for (i = 0; i < 4 - numButtons; ++i) {
                buttonsPanel.add(new JLabel());
            }
        }
        this.renderer.selected.connect((Object)this, "selectAccount");
        this.accounts = new RendererScrollPaneModel((Renderer)this.renderer, 3, 4);
        this.accountsPane = new CustomScrollPane(this.accounts);
        this.add((Component)buttonsPanel, new Rectangle(0, 8, 8, 2));
        this.accountsPane = new CustomScrollPane(this.accounts);
        this.add((Component)this.accountsPane, new Rectangle(0, 0, 8, 8));
    }

    public void setAccounts(List<PhoneAccount> theAccounts) {
        this.accounts.setObjects(theAccounts);
        this.invalidate();
        this.repaint();
    }

    public void selectAccount(Displayable account) {
        this.accountSelected.emit((Object)((Account)account));
    }

    public void startFlashButtons(Call newCall) {
        if (this.buttons.length > 0 && this.buttons.length >= newCall.getLineNumber()) {
            this.buttons[newCall.getLineNumber() - 1].setStatusRinging(newCall);
        }
    }

    public void stopFlashButtons(Integer lineNumber) {
        if (this.buttons.length > 0) {
            this.buttons[lineNumber - 1].setStatusNotRinging();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof CallerIDButton) {
            this.buttonClicked.emit((Object)((CallerIDButton)e.getSource()));
        }
    }
}

